/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.processor;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import javax.tools.Diagnostic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"*"})
public class CleaningAnnotationProcessor
extends AbstractProcessor {
    private static final AtomicReference<Boolean> HAS_BUG = new AtomicReference();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (!this.shouldWorkaroundBug()) {
                return false;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Attempting to workaround 6512707");
            final Trees t = Trees.instance(this.processingEnv);
            final LinkedList toClean = new LinkedList();
            new ElementScanner6<Void, Void>(){

                @Override
                public Void visitExecutable(ExecutableElement e, Void p) {
                    MethodTree tree = t.getTree(e);
                    if (tree != null && tree.getKind() == Tree.Kind.METHOD) {
                        JCTree.JCMethodDecl jcTree = (JCTree.JCMethodDecl)tree;
                        toClean.add(jcTree.defaultValue);
                    }
                    return (Void)super.visitExecutable(e, p);
                }
            }.scan(roundEnv.getRootElements(), null);
            Method cleanTrees = JavacProcessingEnvironment.class.getDeclaredMethod("cleanTrees", List.class);
            cleanTrees.setAccessible(true);
            cleanTrees.invoke(null, List.from(toClean.toArray(new JCTree[0])));
        }
        catch (Throwable t) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Failed with a Throwable: " + t.getMessage());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private boolean shouldWorkaroundBug() {
        Boolean result = HAS_BUG.get();
        if (result != null) {
            return result;
        }
        Context ctx = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        TreeMaker make = TreeMaker.instance(ctx);
        final JCTree.JCLiteral val = make.Literal("");
        JCTree.JCMethodDecl method = make.MethodDef(null, null, null, List.<JCTree.JCTypeParameter>nil(), List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), null, val);
        final boolean[] noBug = new boolean[]{false};
        new TreeScanner(){

            public void scan(JCTree tree) {
                noBug[0] = noBug[0] | tree == val;
                super.scan(tree);
            }
        }.scan(method);
        HAS_BUG.compareAndSet(null, !noBug[0]);
        return HAS_BUG.get();
    }
}

