/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.web.core.syntax.JspParserErrorAnnotation;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class ErrorAnnotation {
    public static final int JSP_ERROR = 1;
    private FileObject jspFo;
    private ArrayList annotations;

    public ErrorAnnotation(FileObject jspFo) {
        this.jspFo = jspFo;
        this.annotations = new ArrayList();
    }

    public void annotate(ErrorInfo[] errors) {
        DataObject doJsp;
        try {
            doJsp = DataObject.find((FileObject)this.jspFo);
        }
        catch (DataObjectNotFoundException e) {
            return;
        }
        EditorCookie editor = (EditorCookie)doJsp.getCookie(EditorCookie.class);
        if (editor == null) {
            return;
        }
        StyledDocument document = editor.getDocument();
        if (document == null) {
            return;
        }
        if (editor.getOpenedPanes() == null) {
            return;
        }
        JEditorPane component = editor.getOpenedPanes()[0];
        if (component != null) {
            if (errors != null && errors.length > 0) {
                Utilities.setStatusBoldText((JTextComponent)component, (String)(" " + errors[0].getDescription()));
            } else {
                Utilities.clearStatusText((JTextComponent)component);
            }
        }
        Collection newAnnotations = this.getAnnotations(errors, document);
        ArrayList added = new ArrayList(newAnnotations);
        added.removeAll(this.annotations);
        ArrayList unchanged = new ArrayList(this.annotations);
        unchanged.retainAll(newAnnotations);
        ArrayList removed = this.annotations;
        removed.removeAll(newAnnotations);
        ErrorAnnotation.detachAnnotations(removed);
        if (!added.isEmpty()) {
            final ArrayList finalAdded = added;
            final DataObject doJsp2 = doJsp;
            Runnable docRenderer = new Runnable(){

                @Override
                public void run() {
                    LineCookie cookie = (LineCookie)doJsp2.getCookie(LineCookie.class);
                    Line.Set lines = cookie.getLineSet();
                    for (LineSetAnnotation ann : finalAdded) {
                        ann.attachToLineSet(lines);
                    }
                }
            };
            document.render(docRenderer);
        }
        this.annotations = unchanged;
        this.annotations.addAll(added);
    }

    private Collection getAnnotations(ErrorInfo[] errors, StyledDocument document) {
        BaseDocument doc = (BaseDocument)document;
        HashMap<Integer, JspParserErrorAnnotation> map = new HashMap<Integer, JspParserErrorAnnotation>(errors.length);
        for (int i = 0; i < errors.length; ++i) {
            JspParserErrorAnnotation ann;
            ErrorInfo err = errors[i];
            int line = err.getLine();
            int column = err.getColumn();
            if (line < 0) {
                try {
                    int firstNonWS = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)0);
                    line = Utilities.getLineOffset((BaseDocument)doc, (int)firstNonWS) + 1;
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (column < 0) {
                column = 0;
            }
            String message = err.getDescription();
            switch (err.getType()) {
                case 1: {
                    ann = new JspParserErrorAnnotation(line, column, message, (NbEditorDocument)document);
                    break;
                }
                default: {
                    ann = new JspParserErrorAnnotation(line, column, message, (NbEditorDocument)document);
                }
            }
            Integer lineInt = new Integer(line);
            map.put(lineInt, ann);
        }
        return map.values();
    }

    private static void detachAnnotations(Collection anns) {
        for (Annotation ann : anns) {
            if (ann.getAttachedAnnotatable() == null) continue;
            ann.detach();
        }
    }

    public static class ErrorInfo {
        private String description;
        private int line;
        private int column;
        private int type;

        public ErrorInfo(String description, int line, int column, int type) {
            this.description = description;
            this.line = line;
            this.column = column;
            this.type = type;
        }

        public String getDescription() {
            return this.description;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public int getType() {
            return this.type;
        }
    }

    public static abstract class LineSetAnnotation
    extends Annotation {
        public abstract void attachToLineSet(Line.Set var1);
    }
}

