/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.api.Formattable;
import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.util.AbstractDiagnosticFormatter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;

public final class RawDiagnosticFormatter
extends AbstractDiagnosticFormatter {
    public RawDiagnosticFormatter(Options options) {
        super(null, new AbstractDiagnosticFormatter.SimpleConfiguration(options, EnumSet.of(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY, DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS)));
    }

    public String formatDiagnostic(JCDiagnostic d, Locale l) {
        try {
            StringBuffer buf = new StringBuffer();
            if (d.getPosition() != -1L) {
                buf.append(this.formatSource(d, false, (Locale)null));
                buf.append(':');
                buf.append(this.formatPosition(d, DiagnosticFormatter.PositionKind.LINE, (Locale)null));
                buf.append(':');
                buf.append(this.formatPosition(d, DiagnosticFormatter.PositionKind.COLUMN, (Locale)null));
                buf.append(':');
            } else {
                buf.append('-');
            }
            buf.append(' ');
            buf.append(this.formatMessage(d, (Locale)null));
            if (this.displaySource(d)) {
                buf.append("\n" + this.formatSourceLine(d, 0));
            }
            return buf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String formatMessage(JCDiagnostic d, Locale l) {
        List<String> subDiags;
        StringBuilder buf = new StringBuilder();
        Collection<String> args = this.formatArguments(d, l);
        buf.append(this.localize(null, d.getCode(), args.toArray()));
        if (d.isMultiline() && ((AbstractCollection)((Object)this.getConfiguration().getVisible())).contains((Object)DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS) && (subDiags = this.formatSubdiagnostics(d, null)).nonEmpty()) {
            String sep = "";
            buf.append(",{");
            for (String sub : this.formatSubdiagnostics(d, null)) {
                buf.append(sep);
                buf.append("(" + sub + ")");
                sep = ",";
            }
            buf.append('}');
        }
        return buf.toString();
    }

    protected String formatArgument(JCDiagnostic diag, Object arg, Locale l) {
        String s = arg instanceof Formattable ? arg.toString() : (arg instanceof BaseFileObject ? ((BaseFileObject)arg).getShortName() : super.formatArgument(diag, arg, null));
        if (arg instanceof JCDiagnostic) {
            return "(" + s + ")";
        }
        return s;
    }

    protected String localize(Locale l, String key, Object ... args) {
        StringBuilder buf = new StringBuilder();
        buf.append(key);
        String sep = ": ";
        for (Object o : args) {
            buf.append(sep);
            buf.append(o);
            sep = ", ";
        }
        return buf.toString();
    }

    public boolean isRaw() {
        return true;
    }
}

