/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageAttachments;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageBody;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageElement;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageHeader;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.TargetElement;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.All;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMQName;
import org.netbeans.modules.websvc.wsitmodelext.security.AsymmetricBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.Attachments;
import org.netbeans.modules.websvc.wsitmodelext.security.Body;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.EncryptedElements;
import org.netbeans.modules.websvc.wsitmodelext.security.EncryptedParts;
import org.netbeans.modules.websvc.wsitmodelext.security.Header;
import org.netbeans.modules.websvc.wsitmodelext.security.Lax;
import org.netbeans.modules.websvc.wsitmodelext.security.LaxTsFirst;
import org.netbeans.modules.websvc.wsitmodelext.security.LaxTsLast;
import org.netbeans.modules.websvc.wsitmodelext.security.Layout;
import org.netbeans.modules.websvc.wsitmodelext.security.RequiredElements;
import org.netbeans.modules.websvc.wsitmodelext.security.SecurityPolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.SignedElements;
import org.netbeans.modules.websvc.wsitmodelext.security.SignedParts;
import org.netbeans.modules.websvc.wsitmodelext.security.Strict;
import org.netbeans.modules.websvc.wsitmodelext.security.SymmetricBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.TransportBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.Trust10;
import org.netbeans.modules.websvc.wsitmodelext.security.Trust13;
import org.netbeans.modules.websvc.wsitmodelext.security.TrustElement;
import org.netbeans.modules.websvc.wsitmodelext.security.Wss10;
import org.netbeans.modules.websvc.wsitmodelext.security.Wss11;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.XPath;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.EncryptBeforeSigning;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.EncryptSignature;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.IncludeTimestamp;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportIssuedTokens;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefEncryptedKey;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefIssuerSerial;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefKeyIdentifier;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefThumbprint;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.OnlySignEntireHeadersAndBody;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.ProtectTokens;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.RequireClientEntropy;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.RequireServerEntropy;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.RequireSignatureConfirmation;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.KeyStore;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.TrustStore;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireDerivedKeys;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireInternalReference;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireIssuerSerialReference;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;

public class SecurityPolicyModelHelper {
    private static HashMap<ConfigVersion, SecurityPolicyModelHelper> instances = new HashMap();
    private ConfigVersion configVersion = ConfigVersion.getDefault();

    private SecurityPolicyModelHelper(ConfigVersion configVersion) {
        this.configVersion = configVersion;
    }

    public static final synchronized SecurityPolicyModelHelper getInstance(ConfigVersion configVersion) {
        SecurityPolicyModelHelper instance = instances.get(configVersion);
        if (instance == null) {
            instance = new SecurityPolicyModelHelper(configVersion);
            instances.put(configVersion, instance);
        }
        return instance;
    }

    public static boolean isSecurityEnabled(WSDLComponent c) {
        Policy p = PolicyModelHelper.getPolicyForElement(c);
        if (p != null) {
            ExtensibilityElement secElem = SecurityPolicyModelHelper.getSecurityBindingTypeElement(c);
            return secElem != null;
        }
        return false;
    }

    public void disableSecurity(WSDLComponent c, boolean removeStoreConfig) {
        RMModelHelper rmh;
        assert (c instanceof Binding || c instanceof BindingOperation);
        this.setSecurityBindingType(c, null);
        SecurityTokensModelHelper.getInstance(this.configVersion).setSupportingTokens(c, null, 100);
        if (c instanceof Binding) {
            ProprietarySecurityPolicyModelHelper.setStreamingSecurity((Binding)c, true);
        }
        this.disableWss(c);
        this.disableTrust(c);
        this.removeTargets(c);
        Policy p = PolicyModelHelper.getPolicyForElement(c);
        if (p != null && removeStoreConfig) {
            KeyStore ks = (KeyStore)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, KeyStore.class, false);
            TrustStore ts = (TrustStore)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, TrustStore.class, false);
            if (ks != null) {
                PolicyModelHelper.removeElement((WSDLComponent)ks);
            }
            if (ts != null) {
                PolicyModelHelper.removeElement((WSDLComponent)ts);
            }
        }
        if (c instanceof Binding) {
            Binding b = (Binding)c;
            Collection ops = b.getBindingOperations();
            for (BindingOperation op : ops) {
                this.disableSecurity((WSDLComponent)op, removeStoreConfig);
            }
        } else {
            BindingOperation bop = (BindingOperation)c;
            BindingInput bi = bop.getBindingInput();
            BindingOutput bo = bop.getBindingOutput();
            if (bi != null) {
                PolicyModelHelper.removePolicyForElement((WSDLComponent)bi);
            }
            if (bo != null) {
                PolicyModelHelper.removePolicyForElement((WSDLComponent)bo);
            }
        }
        if ((rmh = RMModelHelper.getInstance(this.configVersion)).isRMEnabled(c)) {
            rmh.setSequenceBinding((Binding)c, null);
        }
        PolicyModelHelper.cleanPolicies(c);
    }

    public WssElement enableWss(WSDLComponent c, boolean wss11) {
        if (c == null) {
            return null;
        }
        PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
        if (c instanceof Binding || c instanceof BindingOperation || c instanceof BindingInput || c instanceof BindingOutput || c instanceof BindingFault) {
            c = pmh.createPolicy(c, true);
        }
        if (wss11) {
            if (SecurityPolicyModelHelper.isWss10(c)) {
                this.disableWss(c);
            }
            if (!SecurityPolicyModelHelper.isWss11(c)) {
                return (WssElement)pmh.createElement(c, SecurityPolicyQName.WSS11.getQName(this.configVersion), Wss11.class, false);
            }
            return SecurityPolicyModelHelper.getWss11(c);
        }
        if (SecurityPolicyModelHelper.isWss11(c)) {
            this.disableWss(c);
        }
        if (!SecurityPolicyModelHelper.isWss10(c)) {
            return (WssElement)pmh.createElement(c, SecurityPolicyQName.WSS10.getQName(this.configVersion), Wss10.class, false);
        }
        return SecurityPolicyModelHelper.getWss10(c);
    }

    public TrustElement enableTrust(WSDLComponent c, ConfigVersion cfgVersion) {
        if (c == null) {
            return null;
        }
        PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
        if (c instanceof Binding || c instanceof BindingOperation || c instanceof BindingInput || c instanceof BindingOutput || c instanceof BindingFault) {
            c = pmh.createPolicy(c, true);
        }
        if (!SecurityPolicyModelHelper.isTrust(c, cfgVersion)) {
            if (cfgVersion == ConfigVersion.CONFIG_1_0) {
                return (TrustElement)pmh.createElement(c, SecurityPolicyQName.TRUST10.getQName(this.configVersion), Trust10.class, false);
            }
            return (TrustElement)pmh.createElement(c, SecurityPolicyQName.TRUST13.getQName(this.configVersion), Trust13.class, false);
        }
        return SecurityPolicyModelHelper.getTrust(c, cfgVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableWss(WSDLComponent c) {
        PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
        WSDLModel model = c.getModel();
        if (c instanceof Binding || c instanceof BindingOperation || c instanceof BindingInput || c instanceof BindingOutput || c instanceof BindingFault) {
            c = pmh.createPolicy(c, true);
        }
        Wss10 wss10 = SecurityPolicyModelHelper.getWss10(c);
        Wss11 wss11 = SecurityPolicyModelHelper.getWss11(c);
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            if (wss10 != null) {
                ((WSDLComponent)wss10.getParent()).removeExtensibilityElement((ExtensibilityElement)wss10);
            }
            if (wss11 != null) {
                ((WSDLComponent)wss11.getParent()).removeExtensibilityElement((ExtensibilityElement)wss11);
            }
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableTrust(WSDLComponent c) {
        boolean isTransaction;
        WSDLModel model = c.getModel();
        PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
        if (c instanceof Binding || c instanceof BindingOperation || c instanceof BindingInput || c instanceof BindingOutput || c instanceof BindingFault) {
            c = pmh.createPolicy(c, true);
        }
        if (!(isTransaction = model.isIntransaction())) {
            model.startTransaction();
        }
        TrustElement trust = SecurityPolicyModelHelper.getTrust(c, this.configVersion);
        try {
            if (trust != null) {
                ((WSDLComponent)trust.getParent()).removeExtensibilityElement((ExtensibilityElement)trust);
            }
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }

    static boolean isWss10(WSDLComponent c) {
        return SecurityPolicyModelHelper.getWss10(c) != null;
    }

    public static boolean isWss11(WSDLComponent c) {
        return SecurityPolicyModelHelper.getWss11(c) != null;
    }

    static boolean isTrust(WSDLComponent c, ConfigVersion cfgVersion) {
        return SecurityPolicyModelHelper.getTrust(c, cfgVersion) != null;
    }

    static Wss10 getWss10(WSDLComponent c) {
        if (c instanceof Binding || c instanceof BindingOperation) {
            c = PolicyModelHelper.getPolicyForElement(c);
        }
        return (Wss10)PolicyModelHelper.getTopLevelElement(c, Wss10.class, false);
    }

    public static Wss11 getWss11(WSDLComponent c) {
        if (c instanceof Binding || c instanceof BindingOperation) {
            c = PolicyModelHelper.getPolicyForElement(c);
        }
        return (Wss11)PolicyModelHelper.getTopLevelElement(c, Wss11.class, false);
    }

    static TrustElement getTrust(WSDLComponent c, ConfigVersion cfgVersion) {
        if (c instanceof Binding || c instanceof BindingOperation) {
            c = PolicyModelHelper.getPolicyForElement(c);
        }
        if (cfgVersion.equals((Object)ConfigVersion.CONFIG_1_0)) {
            return (TrustElement)PolicyModelHelper.getTopLevelElement(c, Trust10.class, false);
        }
        return (TrustElement)PolicyModelHelper.getTopLevelElement(c, Trust13.class, false);
    }

    public static boolean isRequireSignatureConfirmation(WSDLComponent comp) {
        Wss11 wss11 = SecurityPolicyModelHelper.getWss11(comp);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wss11, RequireSignatureConfirmation.class);
    }

    static boolean isAttributeEnabled(ExtensibilityElement element, Class a) {
        if (element != null) {
            Policy p = (Policy)PolicyModelHelper.getTopLevelElement((WSDLComponent)element, Policy.class, false);
            return PolicyModelHelper.getTopLevelElement((WSDLComponent)p, a, false) != null;
        }
        return false;
    }

    public void enableIncludeTimestamp(WSDLComponent secBinding, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(secBinding, SecurityPolicyQName.INCLUDETIMESTAMP.getQName(this.configVersion), IncludeTimestamp.class, true);
        } else {
            PolicyModelHelper.removeElement(secBinding, IncludeTimestamp.class, true);
        }
    }

    public void enableEncryptSignature(WSDLComponent secBinding, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(secBinding, SecurityPolicyQName.ENCRYPTSIGNATURE.getQName(this.configVersion), EncryptSignature.class, true);
        } else {
            PolicyModelHelper.removeElement(secBinding, EncryptSignature.class, true);
        }
    }

    void enableSignEntireHeadersAndBody(WSDLComponent secBinding, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(secBinding, SecurityPolicyQName.ONLYSIGNENTIREHEADERSANDBODY.getQName(this.configVersion), OnlySignEntireHeadersAndBody.class, true);
        } else {
            PolicyModelHelper.removeElement(secBinding, OnlySignEntireHeadersAndBody.class, true);
        }
    }

    public void enableProtectTokens(WSDLComponent secBinding, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(secBinding, SecurityPolicyQName.PROTECTTOKENS.getQName(this.configVersion), ProtectTokens.class, true);
        } else {
            PolicyModelHelper.removeElement(secBinding, ProtectTokens.class, true);
        }
    }

    public void enableEncryptBeforeSigning(WSDLComponent secBinding, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(secBinding, SecurityPolicyQName.ENCRYPTBEFORESIGNING.getQName(this.configVersion), EncryptBeforeSigning.class, true);
        } else {
            PolicyModelHelper.removeElement(secBinding, EncryptBeforeSigning.class, true);
        }
    }

    public void enableMustSupportRefIssuerSerial(WssElement wss, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)wss, SecurityPolicyQName.MUSTSUPPORTREFISSUERSERIAL.getQName(this.configVersion), MustSupportRefIssuerSerial.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wss, MustSupportRefIssuerSerial.class, true);
        }
    }

    public void enableMustSupportRefKeyIdentifier(WssElement wss, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)wss, SecurityPolicyQName.MUSTSUPPORTREFKEYIDENTIFIER.getQName(this.configVersion), MustSupportRefKeyIdentifier.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wss, MustSupportRefKeyIdentifier.class, true);
        }
    }

    public static boolean isRequireDerivedKeys(WSDLComponent token) {
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)token, RequireDerivedKeys.class);
    }

    public void enableRequireDerivedKeys(WSDLComponent tokenType, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(tokenType, SecurityPolicyQName.REQUIREDERIVEDKEYS.getQName(this.configVersion), RequireDerivedKeys.class, true);
        } else {
            PolicyModelHelper.removeElement(tokenType, RequireDerivedKeys.class, true);
        }
    }

    public void enableRequireIssuerSerialReference(WSDLComponent tokenType, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(tokenType, SecurityPolicyQName.REQUIREISSUERSERIALREFERENCE.getQName(this.configVersion), RequireIssuerSerialReference.class, true);
        } else {
            PolicyModelHelper.removeElement(tokenType, RequireIssuerSerialReference.class, true);
        }
    }

    public void enableRequireInternalReference(WSDLComponent tokenType, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement(tokenType, SecurityPolicyQName.REQUIREINTERNALREFERENCE.getQName(this.configVersion), RequireInternalReference.class, true);
        } else {
            PolicyModelHelper.removeElement(tokenType, RequireInternalReference.class, true);
        }
    }

    public void enableMustSupportRefEncryptedKey(WssElement wss, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)wss, SecurityPolicyQName.MUSTSUPPORTREFENCRYPTEDKEY.getQName(this.configVersion), MustSupportRefEncryptedKey.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wss, MustSupportRefEncryptedKey.class, true);
        }
    }

    public void enableMustSupportRefThumbprint(WssElement wss, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)wss, SecurityPolicyQName.MUSTSUPPORTREFTHUMBPRINT.getQName(this.configVersion), MustSupportRefThumbprint.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wss, MustSupportRefThumbprint.class, true);
        }
    }

    public void enableRequireSignatureConfirmation(WssElement wss, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)wss, SecurityPolicyQName.REQUIRESIGNATURECONFIRMATION.getQName(this.configVersion), RequireSignatureConfirmation.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wss, RequireSignatureConfirmation.class, true);
        }
    }

    public void enableRequireClientEntropy(TrustElement trust, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)trust, SecurityPolicyQName.REQUIRECLIENTENTROPY.getQName(this.configVersion), RequireClientEntropy.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)trust, RequireClientEntropy.class, true);
        }
    }

    public void enableRequireServerEntropy(TrustElement trust, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)trust, SecurityPolicyQName.REQUIRESERVERENTROPY.getQName(this.configVersion), RequireServerEntropy.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)trust, RequireServerEntropy.class, true);
        }
    }

    public void enableMustSupportIssuedTokens(TrustElement trust, boolean enable) {
        if (enable) {
            PolicyModelHelper.getInstance(this.configVersion).createElement((WSDLComponent)trust, SecurityPolicyQName.MUSTSUPPORTISSUEDTOKENS.getQName(this.configVersion), MustSupportIssuedTokens.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)trust, MustSupportIssuedTokens.class, true);
        }
    }

    public static Vector<Vector> getTargets(WSDLComponent comp) {
        Vector<Object> columns;
        Vector existing;
        Vector<Object> columns2;
        Vector existing2;
        Vector<Object> columns3;
        Vector<Object> columns4;
        Vector<Vector> rows = new Vector<Vector>();
        Policy p = null;
        p = PolicyModelHelper.getPolicyForElement(comp);
        if (p == null) {
            return rows;
        }
        List bodies = Collections.emptyList();
        List attchs = Collections.emptyList();
        List headers = Collections.emptyList();
        List xpaths = Collections.emptyList();
        EncryptedParts encryptedParts = (EncryptedParts)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, EncryptedParts.class, false);
        EncryptedElements encryptedElements = (EncryptedElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, EncryptedElements.class, false);
        if (encryptedParts != null) {
            bodies = encryptedParts.getExtensibilityElements(Body.class);
            attchs = encryptedParts.getExtensibilityElements(Attachments.class);
            headers = encryptedParts.getExtensibilityElements(Header.class);
        }
        if (encryptedElements != null) {
            xpaths = encryptedElements.getExtensibilityElements(XPath.class);
        }
        if (bodies != null && !bodies.isEmpty()) {
            columns4 = new Vector<Object>();
            columns4.add(0, new MessageBody());
            columns4.add(1, Boolean.FALSE);
            columns4.add(2, Boolean.TRUE);
            columns4.add(3, Boolean.FALSE);
            rows.add(columns4);
        }
        if (attchs != null && !attchs.isEmpty()) {
            columns4 = new Vector();
            columns4.add(0, new MessageAttachments());
            columns4.add(1, Boolean.FALSE);
            columns4.add(2, Boolean.TRUE);
            columns4.add(3, Boolean.FALSE);
            rows.add(columns4);
        }
        for (Header h : headers) {
            MessageHeader header = SecurityPolicyModelHelper.getListModelForHeader(h);
            if (header == null) continue;
            columns3 = new Vector<Object>();
            columns3.add(0, header);
            columns3.add(1, Boolean.FALSE);
            columns3.add(2, Boolean.TRUE);
            columns3.add(3, Boolean.FALSE);
            rows.add(columns3);
        }
        for (XPath x : xpaths) {
            MessageElement e = SecurityPolicyModelHelper.getListModelForXPath(x);
            if (e == null) continue;
            columns3 = new Vector();
            columns3.add(0, e);
            columns3.add(1, Boolean.FALSE);
            columns3.add(2, Boolean.TRUE);
            columns3.add(3, Boolean.FALSE);
            rows.add(columns3);
        }
        SignedParts signedParts = (SignedParts)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, SignedParts.class, false);
        SignedElements signedElements = (SignedElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, SignedElements.class, false);
        if (signedParts != null) {
            bodies = signedParts.getExtensibilityElements(Body.class);
            attchs = signedParts.getExtensibilityElements(Attachments.class);
            headers = signedParts.getExtensibilityElements(Header.class);
        }
        if (signedElements != null) {
            xpaths = signedElements.getExtensibilityElements(XPath.class);
        }
        if (bodies != null && !bodies.isEmpty()) {
            MessageBody body = new MessageBody();
            existing2 = SecurityPolicyModelHelper.targetExists(rows, body);
            if (existing2 != null) {
                existing2.set(1, Boolean.TRUE);
            } else {
                columns2 = new Vector<Object>();
                columns2.add(0, body);
                columns2.add(1, Boolean.TRUE);
                columns2.add(2, Boolean.FALSE);
                columns2.add(3, Boolean.FALSE);
                rows.add(columns2);
            }
        }
        if (attchs != null && !attchs.isEmpty()) {
            MessageAttachments att = new MessageAttachments();
            existing2 = SecurityPolicyModelHelper.targetExists(rows, att);
            if (existing2 != null) {
                existing2.set(1, Boolean.TRUE);
            } else {
                columns2 = new Vector();
                columns2.add(0, att);
                columns2.add(1, Boolean.TRUE);
                columns2.add(2, Boolean.FALSE);
                columns2.add(3, Boolean.FALSE);
                rows.add(columns2);
            }
        }
        for (Header h : headers) {
            MessageHeader header = SecurityPolicyModelHelper.getListModelForHeader(h);
            if (header == null) continue;
            existing = SecurityPolicyModelHelper.targetExists(rows, header);
            if (existing != null) {
                existing.set(1, Boolean.TRUE);
                continue;
            }
            columns = new Vector<Object>();
            columns.add(0, header);
            columns.add(1, Boolean.TRUE);
            columns.add(2, Boolean.FALSE);
            columns.add(3, Boolean.FALSE);
            rows.add(columns);
        }
        for (XPath x : xpaths) {
            MessageElement e = SecurityPolicyModelHelper.getListModelForXPath(x);
            if (e == null) continue;
            existing = SecurityPolicyModelHelper.targetExists(rows, e);
            if (existing != null) {
                existing.set(1, Boolean.TRUE);
                continue;
            }
            columns = new Vector();
            columns.add(0, e);
            columns.add(1, Boolean.TRUE);
            columns.add(2, Boolean.FALSE);
            columns.add(3, Boolean.FALSE);
            rows.add(columns);
        }
        RequiredElements requiredElements = (RequiredElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, RequiredElements.class, false);
        if (requiredElements != null) {
            xpaths = requiredElements.getExtensibilityElements(XPath.class);
        }
        for (XPath x : xpaths) {
            MessageElement e = SecurityPolicyModelHelper.getListModelForXPath(x);
            if (e == null) continue;
            Vector existing3 = SecurityPolicyModelHelper.targetExists(rows, e);
            if (existing3 != null) {
                existing3.set(3, Boolean.TRUE);
                continue;
            }
            Vector<Object> columns5 = new Vector<Object>();
            columns5.add(0, e);
            columns5.add(1, Boolean.FALSE);
            columns5.add(2, Boolean.FALSE);
            columns5.add(3, Boolean.TRUE);
            rows.add(columns5);
        }
        return rows;
    }

    public static Vector targetExists(Vector<Vector> rows, TargetElement e) {
        for (Vector row : rows) {
            TargetElement te = (TargetElement)row.get(0);
            if (!te.equals(e)) continue;
            return row;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargets(WSDLComponent comp, Vector<Vector> targetModel) {
        if (comp == null) {
            return;
        }
        WSDLModel model = comp.getModel();
        Policy p = null;
        p = comp instanceof Policy ? (Policy)comp : PolicyModelHelper.getPolicyForElement(comp);
        EncryptedParts encryptedParts = (EncryptedParts)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, EncryptedParts.class, false);
        SignedParts signedParts = (SignedParts)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, SignedParts.class, false);
        EncryptedElements encryptedElements = (EncryptedElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, EncryptedElements.class, false);
        SignedElements signedElements = (SignedElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, SignedElements.class, false);
        RequiredElements requiredElements = (RequiredElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, RequiredElements.class, false);
        WSDLComponentFactory wcf = model.getFactory();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            Object topLevel = null;
            if (encryptedParts != null) {
                topLevel = (WSDLComponent)encryptedParts.getParent();
                topLevel.removeExtensibilityElement((ExtensibilityElement)encryptedParts);
                encryptedParts = null;
            }
            if (signedParts != null) {
                topLevel = (WSDLComponent)signedParts.getParent();
                topLevel.removeExtensibilityElement((ExtensibilityElement)signedParts);
                signedParts = null;
            }
            if (encryptedElements != null) {
                topLevel = (WSDLComponent)encryptedElements.getParent();
                topLevel.removeExtensibilityElement((ExtensibilityElement)encryptedElements);
                encryptedElements = null;
            }
            if (signedElements != null) {
                topLevel = (WSDLComponent)signedElements.getParent();
                topLevel.removeExtensibilityElement((ExtensibilityElement)signedElements);
                signedElements = null;
            }
            if (requiredElements != null) {
                topLevel = (WSDLComponent)requiredElements.getParent();
                topLevel.removeExtensibilityElement((ExtensibilityElement)requiredElements);
                requiredElements = null;
            }
            if (targetModel == null) {
                return;
            }
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            topLevel = p == null ? pmh.createPolicy(comp, true) : (!(comp instanceof Policy) ? pmh.createTopExactlyOneAll(p) : p);
            boolean streamingSecurity = true;
            for (Vector v : targetModel) {
                TargetElement te = (TargetElement)v.get(0);
                boolean encrypt = (Boolean)v.get(2);
                boolean sign = (Boolean)v.get(1);
                boolean require = (Boolean)v.get(3);
                if (te instanceof MessageHeader) {
                    if (encrypt) {
                        if (encryptedParts == null) {
                            encryptedParts = (EncryptedParts)pmh.createElement((WSDLComponent)topLevel, SecurityPolicyQName.ENCRYPTEDPARTS.getQName(this.configVersion), EncryptedParts.class, false);
                        }
                        this.addHeaderElementForListItem(te.toString(), (WSDLComponent)encryptedParts, wcf);
                    }
                    if (!sign) continue;
                    if (signedParts == null) {
                        signedParts = (SignedParts)pmh.createElement((WSDLComponent)topLevel, SecurityPolicyQName.SIGNEDPARTS.getQName(this.configVersion), SignedParts.class, false);
                    }
                    this.addHeaderElementForListItem(te.toString(), (WSDLComponent)signedParts, wcf);
                    continue;
                }
                if (te instanceof MessageElement) {
                    streamingSecurity = false;
                    if (encrypt) {
                        if (encryptedElements == null) {
                            encryptedElements = (EncryptedElements)pmh.createElement((WSDLComponent)topLevel, SecurityPolicyQName.ENCRYPTEDELEMENTS.getQName(this.configVersion), EncryptedElements.class, false);
                        }
                        this.addElementForListItem(te.toString(), (WSDLComponent)encryptedElements, wcf);
                    }
                    if (sign) {
                        if (signedElements == null) {
                            signedElements = (SignedElements)pmh.createElement((WSDLComponent)topLevel, SecurityPolicyQName.SIGNEDELEMENTS.getQName(this.configVersion), SignedElements.class, false);
                        }
                        this.addElementForListItem(te.toString(), (WSDLComponent)signedElements, wcf);
                    }
                    if (!require) continue;
                    if (requiredElements == null) {
                        requiredElements = (RequiredElements)pmh.createElement((WSDLComponent)topLevel, SecurityPolicyQName.REQUIREDELEMENTS.getQName(this.configVersion), RequiredElements.class, false);
                    }
                    this.addElementForListItem(te.toString(), (WSDLComponent)requiredElements, wcf);
                    continue;
                }
                if (te instanceof MessageBody) {
                    if (encrypt) {
                        if (encryptedParts == null) {
                            encryptedParts = (EncryptedParts)pmh.createElement((WSDLComponent)topLevel, SecurityPolicyQName.ENCRYPTEDPARTS.getQName(this.configVersion), EncryptedParts.class, false);
                        }
                        this.addBody((WSDLComponent)encryptedParts, wcf);
                    }
                    if (!sign) continue;
                    if (signedParts == null) {
                        signedParts = (SignedParts)pmh.createElement((WSDLComponent)topLevel, SecurityPolicyQName.SIGNEDPARTS.getQName(this.configVersion), SignedParts.class, false);
                    }
                    this.addBody((WSDLComponent)signedParts, wcf);
                    continue;
                }
                if (!(te instanceof MessageAttachments)) continue;
                if (encrypt) {
                    if (encryptedParts == null) {
                        encryptedParts = (EncryptedParts)pmh.createElement((WSDLComponent)topLevel, SecurityPolicyQName.ENCRYPTEDPARTS.getQName(this.configVersion), EncryptedParts.class, false);
                    }
                    this.addAttachments((WSDLComponent)encryptedParts, wcf);
                }
                if (!sign) continue;
                if (signedParts == null) {
                    signedParts = (SignedParts)pmh.createElement((WSDLComponent)topLevel, SecurityPolicyQName.SIGNEDPARTS.getQName(this.configVersion), SignedParts.class, false);
                }
                this.addAttachments((WSDLComponent)signedParts, wcf);
            }
            if (comp instanceof BindingInput || comp instanceof BindingOutput || comp instanceof BindingFault) {
                Binding b = (Binding)((WSDLComponent)comp.getParent()).getParent();
                ProprietarySecurityPolicyModelHelper.setStreamingSecurity(b, streamingSecurity);
            }
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }

    private static MessageHeader getListModelForHeader(Header h) {
        String name = h.getName();
        if ("To".equals(name)) {
            return new MessageHeader(MessageHeader.ADDRESSING_TO);
        }
        if ("From".equals(name)) {
            return new MessageHeader(MessageHeader.ADDRESSING_FROM);
        }
        if ("FaultTo".equals(name)) {
            return new MessageHeader(MessageHeader.ADDRESSING_FAULTTO);
        }
        if ("ReplyTo".equals(name)) {
            return new MessageHeader(MessageHeader.ADDRESSING_REPLYTO);
        }
        if ("MessageID".equals(name)) {
            return new MessageHeader(MessageHeader.ADDRESSING_MESSAGEID);
        }
        if ("RelatesTo".equals(name)) {
            return new MessageHeader(MessageHeader.ADDRESSING_RELATESTO);
        }
        if ("Action".equals(name)) {
            return new MessageHeader(MessageHeader.ADDRESSING_ACTION);
        }
        if ("AckRequested".equals(name)) {
            return new MessageHeader(MessageHeader.RM_ACKREQUESTED);
        }
        if ("SequenceAcknowledgement".equals(name)) {
            return new MessageHeader(MessageHeader.RM_SEQUENCEACK);
        }
        if ("Sequence".equals(name)) {
            return new MessageHeader(MessageHeader.RM_SEQUENCE);
        }
        if ("CreateSequence".equals(name)) {
            return new MessageHeader(MessageHeader.RM_CREATESEQUENCE);
        }
        return null;
    }

    private static MessageElement getListModelForXPath(XPath x) {
        String xpath = x.getXPath();
        return new MessageElement(xpath);
    }

    private ExtensibilityElement addHeaderElementForListItem(String item, WSDLComponent c, WSDLComponentFactory wcf) {
        Header h = (Header)wcf.create(c, SecurityPolicyQName.HEADER.getQName(this.configVersion));
        if (MessageHeader.ADDRESSING_TO.equals(item)) {
            h.setName("To");
            h.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_FROM.equals(item)) {
            h.setName("From");
            h.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_FAULTTO.equals(item)) {
            h.setName("FaultTo");
            h.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_REPLYTO.equals(item)) {
            h.setName("ReplyTo");
            h.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_MESSAGEID.equals(item)) {
            h.setName("MessageID");
            h.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_RELATESTO.equals(item)) {
            h.setName("RelatesTo");
            h.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_ACTION.equals(item)) {
            h.setName("Action");
            h.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        String rmNspace = RMQName.getHeaderNamespaceUri((ConfigVersion)this.configVersion);
        if (MessageHeader.RM_ACKREQUESTED.equals(item)) {
            h.setName("AckRequested");
            h.setNamespace(rmNspace);
        }
        if (MessageHeader.RM_SEQUENCEACK.equals(item)) {
            h.setName("SequenceAcknowledgement");
            h.setNamespace(rmNspace);
        }
        if (MessageHeader.RM_SEQUENCE.equals(item)) {
            h.setName("Sequence");
            h.setNamespace(rmNspace);
        }
        if (MessageHeader.RM_CREATESEQUENCE.equals(item)) {
            h.setName("CreateSequence");
            h.setNamespace(rmNspace);
        }
        if (h != null) {
            c.addExtensibilityElement((ExtensibilityElement)h);
        }
        return h;
    }

    private ExtensibilityElement addElementForListItem(String item, WSDLComponent c, WSDLComponentFactory wcf) {
        XPath x = null;
        x = (XPath)wcf.create(c, SecurityPolicyQName.XPATH.getQName(this.configVersion));
        if (x != null) {
            c.addExtensibilityElement((ExtensibilityElement)x);
            x.setXPath(item);
        }
        return x;
    }

    private ExtensibilityElement addBody(WSDLComponent c, WSDLComponentFactory wcf) {
        Body b = null;
        b = (Body)wcf.create(c, SecurityPolicyQName.BODY.getQName(this.configVersion));
        c.addExtensibilityElement((ExtensibilityElement)b);
        return b;
    }

    private ExtensibilityElement addAttachments(WSDLComponent c, WSDLComponentFactory wcf) {
        Attachments a = null;
        a = (Attachments)wcf.create(c, SecurityPolicyQName.ATTACHMENTS.getQName(this.configVersion));
        c.addExtensibilityElement((ExtensibilityElement)a);
        return a;
    }

    public static ExtensibilityElement getSecurityBindingTypeElement(WSDLComponent c) {
        assert (c != null);
        Object p = c;
        if (c instanceof Binding || c instanceof BindingOperation || c instanceof BindingInput || c instanceof BindingOutput || c instanceof BindingFault) {
            p = PolicyModelHelper.getPolicyForElement(c);
        } else if (c instanceof BootstrapPolicy) {
            p = PolicyModelHelper.getTopLevelElement(c, Policy.class, false);
        }
        Object ee = PolicyModelHelper.getTopLevelElement(p, SymmetricBinding.class, false);
        if (ee != null) {
            return ee;
        }
        ee = (AsymmetricBinding)PolicyModelHelper.getTopLevelElement(p, AsymmetricBinding.class, false);
        if (ee != null) {
            return ee;
        }
        ee = (TransportBinding)PolicyModelHelper.getTopLevelElement(p, TransportBinding.class, false);
        if (ee != null) {
            return ee;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WSDLComponent setSecurityBindingType(WSDLComponent c, String bindingType) {
        assert (c != null);
        WSDLModel model = c.getModel();
        SymmetricBinding secBindingType = null;
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
        All a = pmh.createPolicy(c, true);
        try {
            SymmetricBinding sb = (SymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)a, SymmetricBinding.class, false);
            AsymmetricBinding ab = (AsymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)a, AsymmetricBinding.class, false);
            TransportBinding tb = (TransportBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)a, TransportBinding.class, false);
            if (sb != null) {
                ((WSDLComponent)sb.getParent()).removeExtensibilityElement((ExtensibilityElement)sb);
            }
            if (ab != null) {
                ((WSDLComponent)ab.getParent()).removeExtensibilityElement((ExtensibilityElement)ab);
            }
            if (tb != null) {
                ((WSDLComponent)tb.getParent()).removeExtensibilityElement((ExtensibilityElement)tb);
            }
            if (ComboConstants.SYMMETRIC.equals(bindingType)) {
                secBindingType = sb = (SymmetricBinding)pmh.createElement((WSDLComponent)a, SecurityPolicyQName.SYMMETRICBINDING.getQName(this.configVersion), SymmetricBinding.class, false);
            }
            if (ComboConstants.ASYMMETRIC.equals(bindingType)) {
                ab = (AsymmetricBinding)pmh.createElement((WSDLComponent)a, SecurityPolicyQName.ASYMMETRICBINDING.getQName(this.configVersion), AsymmetricBinding.class, false);
                secBindingType = ab;
            }
            if (ComboConstants.TRANSPORT.equals(bindingType)) {
                tb = (TransportBinding)pmh.createElement((WSDLComponent)a, SecurityPolicyQName.TRANSPORTBINDING.getQName(this.configVersion), TransportBinding.class, false);
                secBindingType = tb;
            }
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
        return secBindingType;
    }

    public void setDefaultTargets(WSDLComponent c, boolean headers, boolean rm) {
        Vector<Vector> targets = new Vector<Vector>();
        Vector<Object> row = new Vector<Object>();
        MessageBody body = new MessageBody();
        row.add(0, body);
        row.add(1, Boolean.TRUE);
        row.add(2, Boolean.TRUE);
        row.add(3, Boolean.FALSE);
        targets.add(row);
        if (headers) {
            MessageHeader h;
            for (String s : MessageHeader.ADDRESSING_HEADERS) {
                row = new Vector();
                h = new MessageHeader(s);
                row.add(0, h);
                row.add(1, Boolean.TRUE);
                row.add(2, Boolean.FALSE);
                row.add(3, Boolean.FALSE);
                targets.add(row);
            }
            for (String s : MessageHeader.RM_HEADERS) {
                row = new Vector();
                h = new MessageHeader(s);
                row.add(0, h);
                row.add(1, Boolean.TRUE);
                row.add(2, Boolean.FALSE);
                row.add(3, Boolean.FALSE);
                targets.add(row);
            }
        }
        this.setTargets(c, targets);
    }

    private void removeTargets(WSDLComponent c) {
        this.setTargets(c, null);
    }

    public static String getMessageLayout(WSDLComponent comp) {
        WSDLComponent layout = SecurityPolicyModelHelper.getMessageLayoutElement(comp);
        if (layout != null) {
            if (layout instanceof Strict) {
                return ComboConstants.STRICT;
            }
            if (layout instanceof Lax) {
                return ComboConstants.LAX;
            }
            if (layout instanceof LaxTsFirst) {
                return ComboConstants.LAXTSFIRST;
            }
            if (layout instanceof LaxTsLast) {
                return ComboConstants.LAXTSLAST;
            }
        }
        return null;
    }

    private static WSDLComponent getMessageLayoutElement(WSDLComponent comp) {
        List elements;
        if (comp instanceof Binding || comp instanceof BindingOperation) {
            comp = SecurityPolicyModelHelper.getSecurityBindingTypeElement(comp);
        }
        if (comp == null) {
            return null;
        }
        Policy p = (Policy)PolicyModelHelper.getTopLevelElement(comp, Policy.class, false);
        Layout l = (Layout)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, Layout.class, false);
        if ((p = (Policy)PolicyModelHelper.getTopLevelElement((WSDLComponent)l, Policy.class, false)) != null && (elements = p.getExtensibilityElements()) != null && !elements.isEmpty()) {
            ExtensibilityElement e = (ExtensibilityElement)elements.get(0);
            return e;
        }
        return null;
    }

    public static boolean isEncryptBeforeSigning(WSDLComponent c) {
        ExtensibilityElement e = SecurityPolicyModelHelper.getSecurityBindingTypeElement(c);
        if (e != null) {
            return SecurityPolicyModelHelper.isAttributeEnabled(e, EncryptBeforeSigning.class);
        }
        return false;
    }

    public static boolean isEncryptSignature(WSDLComponent c) {
        ExtensibilityElement e = SecurityPolicyModelHelper.getSecurityBindingTypeElement(c);
        if (e != null) {
            return SecurityPolicyModelHelper.isAttributeEnabled(e, EncryptSignature.class);
        }
        return false;
    }

    static boolean isSignEntireHeadersAndBody(WSDLComponent c) {
        ExtensibilityElement e = SecurityPolicyModelHelper.getSecurityBindingTypeElement(c);
        if (e != null) {
            return SecurityPolicyModelHelper.isAttributeEnabled(e, OnlySignEntireHeadersAndBody.class);
        }
        return false;
    }

    public static boolean isProtectTokens(WSDLComponent c) {
        ExtensibilityElement e = SecurityPolicyModelHelper.getSecurityBindingTypeElement(c);
        if (e != null) {
            return SecurityPolicyModelHelper.isAttributeEnabled(e, ProtectTokens.class);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayout(WSDLComponent c, String msgLayout) {
        WSDLModel model = c.getModel();
        WSDLComponentFactory wcf = model.getFactory();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            QName qnameToCreate = null;
            if (ComboConstants.STRICT.equals(msgLayout)) {
                qnameToCreate = SecurityPolicyQName.STRICT.getQName(this.configVersion);
            } else if (ComboConstants.LAX.equals(msgLayout)) {
                qnameToCreate = SecurityPolicyQName.LAX.getQName(this.configVersion);
            } else if (ComboConstants.LAXTSFIRST.equals(msgLayout)) {
                qnameToCreate = SecurityPolicyQName.LAXTSFIRST.getQName(this.configVersion);
            } else if (ComboConstants.LAXTSLAST.equals(msgLayout)) {
                qnameToCreate = SecurityPolicyQName.LAXTSLAST.getQName(this.configVersion);
            }
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            Layout layout = (Layout)pmh.createElement(c, SecurityPolicyQName.LAYOUT.getQName(this.configVersion), Layout.class, true);
            List policies = layout.getExtensibilityElements(Policy.class);
            if (policies != null && !policies.isEmpty()) {
                for (Policy pol : policies) {
                    layout.removeExtensibilityElement((ExtensibilityElement)pol);
                }
            }
            Policy p = (Policy)pmh.createElement((WSDLComponent)layout, PolicyQName.POLICY.getQName(this.configVersion), Policy.class, false);
            ExtensibilityElement e = (ExtensibilityElement)wcf.create((WSDLComponent)p, qnameToCreate);
            p.addExtensibilityElement(e);
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }
}

