/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Collection;
import javax.lang.model.element.Element;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.beans.beaninfo.BIDataLoader;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandler;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandlerFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;

public final class BIGuardedBlockHandlerFactory
implements GuardedBlockHandlerFactory {
    public GuardedBlockHandler createInstance(AbstractRefactoring abstractRefactoring) {
        return new BIGuardedBlockHandler();
    }

    private static final class BIGuardedBlockHandler
    implements GuardedBlockHandler {
        private BIGuardedBlockHandler() {
        }

        public Problem handleChange(RefactoringElementImplementation refactoringElementImplementation, Collection<RefactoringElementImplementation> collection, Collection<Transaction> collection2) {
            ModificationResult.Difference difference;
            DiffElement diffElement;
            FileObject fileObject;
            if (refactoringElementImplementation instanceof DiffElement && BIDataLoader.isBeanInfo(fileObject = (diffElement = (DiffElement)refactoringElementImplementation).getParentFile()) && this.checkChange(fileObject, diffElement.getPosition()) && (difference = (ModificationResult.Difference)diffElement.getLookup().lookup(ModificationResult.Difference.class)) != null) {
                diffElement.setEnabled(true);
                difference.setCommitToGuards(true);
                collection.add(refactoringElementImplementation);
            }
            return null;
        }

        private boolean checkChange(FileObject fileObject, final PositionBounds positionBounds) {
            final boolean[] blArray = new boolean[]{false};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.RESOLVED);
                            blArray[0] = BIGuardedBlockHandler.this.checkChange(compilationController, positionBounds);
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return blArray[0];
        }

        public void run(CompilationController compilationController) throws Exception {
        }

        private boolean checkChange(CompilationController compilationController, PositionBounds positionBounds) throws IOException, BadLocationException {
            int n = positionBounds.getBegin().getOffset();
            Trees trees = compilationController.getTrees();
            TreePath treePath = compilationController.getTreeUtilities().pathFor(n + 1);
            if (treePath == null) {
                return false;
            }
            Element element = trees.getElement(treePath);
            if (element == null) {
                return false;
            }
            TreePath treePath2 = trees.getPath(element);
            if (treePath2 != null) {
                SourcePositions sourcePositions = trees.getSourcePositions();
                long l = sourcePositions.getStartPosition(treePath2.getCompilationUnit(), treePath2.getLeaf());
                FileObject fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo());
                Document document = compilationController.getDocument();
                GuardedSectionManager guardedSectionManager = GuardedSectionManager.getInstance((StyledDocument)((StyledDocument)document));
                return fileObject != compilationController.getFileObject() || guardedSectionManager != null && !this.isGuarded(guardedSectionManager, document.createPosition((int)l));
            }
            return true;
        }

        private boolean isGuarded(GuardedSectionManager guardedSectionManager, Position position) {
            for (GuardedSection guardedSection : guardedSectionManager.getGuardedSections()) {
                if (!guardedSection.contains(position, true)) continue;
                return true;
            }
            return false;
        }
    }
}

