/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.collections;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Stack;

public class StringStack
implements Serializable {
    private Stack stack = new Stack();

    public StringStack add(String string) {
        if (string != null && !this.contains(string)) {
            this.stack.push(string);
        }
        return this;
    }

    public StringStack addAll(StringStack stringStack) {
        Iterator iterator = stringStack.stack.iterator();
        while (iterator.hasNext()) {
            this.add((String)iterator.next());
        }
        return this;
    }

    public void clear() {
        this.stack.clear();
    }

    public boolean contains(String string) {
        return this.stack.search(string) != -1;
    }

    public final boolean empty() {
        return this.stack.empty();
    }

    public String get(int n) {
        return (String)this.stack.elementAt(n);
    }

    public final int size() {
        return this.stack.size();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2;
        if (this.size() > 0) {
            if (string == null) {
                string = "";
            }
            int n = 0;
            for (int i = 0; i < this.stack.size(); ++i) {
                n += this.get(i).length();
            }
            StringBuffer stringBuffer = new StringBuffer(n += (this.stack.size() - 1) * string.length()).append(this.get(0));
            for (int i = 1; i < this.stack.size(); ++i) {
                stringBuffer.append(string).append(this.get(i));
            }
            string2 = stringBuffer.toString();
        } else {
            string2 = "";
        }
        return string2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object == null || !(object instanceof StringStack)) {
            bl = false;
        } else if (object == this) {
            bl = true;
        } else if (this.toString().equals(object.toString())) {
            bl = true;
        }
        return bl;
    }

    public String[] toStringArray() {
        String[] stringArray = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            stringArray[i] = this.get(i);
        }
        return stringArray;
    }
}

