/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.MenuRenderer;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

public class SelectManyCheckboxListRenderer
extends MenuRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String alignStr = null;
        Object borderObj = null;
        boolean alignVertical = false;
        int border = 0;
        alignStr = (String)component.getAttributes().get("layout");
        if (null != alignStr) {
            alignVertical = alignStr.equalsIgnoreCase("pageDirection");
        }
        Object v = component.getAttributes().get("border");
        borderObj = v;
        if (null != v) {
            border = borderObj;
        }
        this.renderBeginText(component, border, alignVertical, context, true);
        Iterator<SelectItem> items = RenderKitUtils.getSelectItems(context, component);
        SelectItem curItem = null;
        int idx = -1;
        while (items.hasNext()) {
            curItem = items.next();
            ++idx;
            if (curItem instanceof SelectItemGroup) {
                if (curItem.getLabel() != null) {
                    if (alignVertical) {
                        writer.startElement("tr", component);
                    }
                    writer.startElement("td", component);
                    writer.writeText((Object)curItem.getLabel(), component, "label");
                    writer.endElement("td");
                    if (alignVertical) {
                        writer.endElement("tr");
                    }
                }
                if (alignVertical) {
                    writer.startElement("tr", component);
                }
                writer.startElement("td", component);
                writer.writeText((Object)"\n", component, null);
                this.renderBeginText(component, 0, alignVertical, context, false);
                SelectItem[] itemsArray = ((SelectItemGroup)curItem).getSelectItems();
                for (int i = 0; i < itemsArray.length; ++i) {
                    this.renderOption(context, component, itemsArray[i], alignVertical, i);
                }
                this.renderEndText(component, alignVertical, context, false);
                writer.endElement("td");
                if (!alignVertical) continue;
                writer.endElement("tr");
                writer.writeText((Object)"\n", component, null);
                continue;
            }
            this.renderOption(context, component, curItem, alignVertical, idx);
        }
        this.renderEndText(component, alignVertical, context, true);
    }

    protected void renderBeginText(UIComponent component, int border, boolean alignVertical, FacesContext context, boolean outerTable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("table", component);
        if (border != Integer.MIN_VALUE) {
            writer.writeAttribute("border", (Object)border, "border");
        }
        if (outerTable) {
            if (this.shouldWriteIdAttribute(component)) {
                this.writeIdAttributeIfNecessary(context, writer, component);
            }
            String styleClass = (String)component.getAttributes().get("styleClass");
            String style = (String)component.getAttributes().get("style");
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, "class");
            }
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
        }
        writer.writeText((Object)"\n", component, null);
        if (!alignVertical) {
            writer.writeText((Object)"\t", component, null);
            writer.startElement("tr", component);
            writer.writeText((Object)"\n", component, null);
        }
    }

    protected void renderEndText(UIComponent component, boolean alignVertical, FacesContext context, boolean outerTable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (!alignVertical) {
            writer.writeText((Object)"\t", component, null);
            writer.endElement("tr");
            writer.writeText((Object)"\n", component, null);
        }
        writer.endElement("table");
    }

    protected void renderOption(FacesContext context, UIComponent component, SelectItem curItem, boolean alignVertical, int itemNumber) throws IOException {
        String itemLabel;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String labelClass = null;
        boolean componentDisabled = Util.componentIsDisabled(component);
        labelClass = componentDisabled || curItem.isDisabled() ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
        if (alignVertical) {
            writer.writeText((Object)"\t", component, null);
            writer.startElement("tr", component);
            writer.writeText((Object)"\n", component, null);
        }
        writer.startElement("td", component);
        writer.writeText((Object)"\n", component, null);
        writer.startElement("input", component);
        writer.writeAttribute("name", (Object)component.getClientId(context), "clientId");
        String idString = component.getClientId(context) + ':' + Integer.toString(itemNumber);
        writer.writeAttribute("id", (Object)idString, "id");
        String valueString = this.getFormattedValue(context, component, curItem.getValue());
        writer.writeAttribute("value", (Object)valueString, "value");
        writer.writeAttribute("type", (Object)"checkbox", null);
        Object[] submittedValues = this.getSubmittedSelectedValues(context, component);
        Class type = String.class;
        Object valuesArray = null;
        Object itemValue = null;
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = valueString;
        } else {
            valuesArray = this.getCurrentSelectedValues(context, component);
            itemValue = curItem.getValue();
        }
        if (valuesArray != null) {
            type = valuesArray.getClass().getComponentType();
        }
        Map requestMap = context.getExternalContext().getRequestMap();
        requestMap.put("com.sun.faces.ComponentForValue", component);
        Object newValue = context.getApplication().getExpressionFactory().coerceToType(itemValue, type);
        boolean isSelected = this.isSelected(newValue, valuesArray);
        if (isSelected) {
            writer.writeAttribute(this.getSelectedTextString(), (Object)Boolean.TRUE, null);
        }
        if (!Util.componentIsDisabled(component) && curItem.isDisabled()) {
            writer.writeAttribute("disabled", (Object)true, "disabled");
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component, new String[]{"border", "style"});
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        writer.endElement("input");
        writer.startElement("label", component);
        writer.writeAttribute("for", (Object)idString, "for");
        if (labelClass != null) {
            writer.writeAttribute("class", (Object)labelClass, "labelClass");
        }
        if ((itemLabel = curItem.getLabel()) != null) {
            writer.writeText((Object)" ", component, null);
            if (!curItem.isEscape()) {
                writer.write(itemLabel);
            } else {
                writer.writeText((Object)itemLabel, component, "label");
            }
        }
        writer.endElement("label");
        writer.endElement("td");
        writer.writeText((Object)"\n", component, null);
        if (alignVertical) {
            writer.writeText((Object)"\t", component, null);
            writer.endElement("tr");
            writer.writeText((Object)"\n", component, null);
        }
    }

    String getSelectedTextString() {
        return "checked";
    }
}

