/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.spi.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.ModelRunConfig;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Writer;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public abstract class AbstractMavenActionsProvider
implements MavenActionsProvider {
    protected ActionToGoalMapping originalMappings;
    protected NetbeansBuildActionXpp3Reader reader = new NetbeansBuildActionXpp3Reader();
    private NetbeansBuildActionXpp3Writer writer = new NetbeansBuildActionXpp3Writer();

    protected static FileObject[] extractFileObjectsfromLookup(Lookup lookup) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (DataObject d : lookup.lookup(new Lookup.Template(DataObject.class)).allInstances()) {
            FileObject f = d.getPrimaryFile();
            files.add(f);
        }
        Collection methods = lookup.lookupAll(SingleMethod.class);
        if (methods.size() == 1) {
            SingleMethod method = (SingleMethod)methods.iterator().next();
            files.add(method.getFile());
        }
        return files.toArray(new FileObject[files.size()]);
    }

    @Override
    public boolean isActionEnable(String action, Project project, Lookup lookup) {
        ActionToGoalMapping rawMappings = this.getRawMappings();
        Iterator<NetbeansActionMapping> it = rawMappings.getActions().iterator();
        NbMavenProject mp = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        String prjPack = mp.getPackagingType();
        while (it.hasNext()) {
            NetbeansActionMapping elem = it.next();
            if (!action.equals(elem.getActionName()) || !elem.getPackagings().isEmpty() && !elem.getPackagings().contains(prjPack.trim()) && !elem.getPackagings().contains("*")) continue;
            return true;
        }
        return false;
    }

    @Override
    public final RunConfig createConfigForDefaultAction(String actionName, Project project, Lookup lookup) {
        FileObject[] fos = AbstractMavenActionsProvider.extractFileObjectsfromLookup(lookup);
        HashMap<String, String> replaceMap = (HashMap<String, String>)lookup.lookup(Map.class);
        if (replaceMap == null) {
            replaceMap = new HashMap<String, String>();
            Logger.getLogger(AbstractMavenActionsProvider.class.getName()).log(Level.FINE, "Missing replace tokens map when executing maven build. Could lead to problems with execution. See issue #159698 for details.", new Exception());
        }
        FileObject fo = null;
        if (fos.length > 0) {
            fo = fos[0];
        }
        return this.mapGoalsToAction(project, actionName, replaceMap, fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionToGoalMapping getRawMappings() {
        if (this.originalMappings == null || this.reloadStream()) {
            InputStream in = this.getActionDefinitionStream();
            if (in == null) {
                this.originalMappings = new ActionToGoalMapping();
            } else {
                InputStreamReader rdr = null;
                try {
                    rdr = new InputStreamReader(in);
                    this.originalMappings = this.reader.read(rdr);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    this.originalMappings = new ActionToGoalMapping();
                }
                catch (XmlPullParserException ex) {
                    ex.printStackTrace();
                    this.originalMappings = new ActionToGoalMapping();
                }
                finally {
                    if (rdr != null) {
                        try {
                            ((Reader)rdr).close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
        return this.originalMappings;
    }

    public String getRawMappingsAsString() {
        StringWriter str = new StringWriter();
        try {
            this.writer.write(str, this.getRawMappings());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return str.toString();
    }

    @Override
    public Set<String> getSupportedDefaultActions() {
        HashSet<String> toRet = new HashSet<String>();
        ActionToGoalMapping raw = this.getRawMappings();
        for (NetbeansActionMapping obj : raw.getActions()) {
            NetbeansActionMapping nb = obj;
            String name = nb.getActionName();
            if (name == null || name.startsWith("CUSTOM-")) continue;
            toRet.add(name);
        }
        return toRet;
    }

    protected boolean reloadStream() {
        return false;
    }

    @Override
    public NetbeansActionMapping getMappingForAction(String actionName, Project project) {
        NetbeansActionMapping action = null;
        try {
            Reader read = this.performDynamicSubstitutions(Collections.EMPTY_MAP, this.getRawMappingsAsString());
            ActionToGoalMapping mapping = this.reader.read(read);
            Iterator<NetbeansActionMapping> it = mapping.getActions().iterator();
            NbMavenProject mp = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            String prjPack = mp.getPackagingType();
            while (it.hasNext()) {
                NetbeansActionMapping elem = it.next();
                if (!actionName.equals(elem.getActionName()) || !elem.getPackagings().isEmpty() && !elem.getPackagings().contains(prjPack.trim()) && !elem.getPackagings().contains("*")) continue;
                action = elem;
                break;
            }
        }
        catch (XmlPullParserException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return action;
    }

    protected abstract InputStream getActionDefinitionStream();

    private RunConfig mapGoalsToAction(Project project, String actionName, Map<String, String> replaceMap, FileObject selectedFile) {
        try {
            Reader read = this.performDynamicSubstitutions(replaceMap, this.getRawMappingsAsString());
            ActionToGoalMapping mapping = this.reader.read(read);
            Iterator<NetbeansActionMapping> it = mapping.getActions().iterator();
            NetbeansActionMapping action = null;
            NbMavenProject mp = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            String prjPack = mp.getPackagingType();
            while (it.hasNext()) {
                NetbeansActionMapping elem = it.next();
                if (!actionName.equals(elem.getActionName()) || !elem.getPackagings().contains(prjPack.trim()) && !elem.getPackagings().contains("*") && elem.getPackagings().size() != 0) continue;
                action = elem;
                break;
            }
            if (action != null) {
                ModelRunConfig mrc = new ModelRunConfig(project, action, actionName, selectedFile);
                if (replaceMap.containsKey("nb.single.run.methodName")) {
                    mrc.setProperty("nb.single.run.methodName", replaceMap.get("nb.single.run.methodName"));
                }
                return mrc;
            }
        }
        catch (XmlPullParserException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected Reader performDynamicSubstitutions(Map replaceMap, String in) throws IOException {
        StringBuffer buf = new StringBuffer(in);
        for (Map.Entry elem : replaceMap.entrySet()) {
            String replaceItem = "${" + elem.getKey() + "}";
            int index = buf.indexOf(replaceItem);
            while (index > -1) {
                String newItem = (String)elem.getValue();
                if (newItem == null) {
                    // empty if block
                }
                newItem = newItem == null ? "" : newItem;
                buf.replace(index, index + replaceItem.length(), newItem);
                index = buf.indexOf(replaceItem);
            }
        }
        return new StringReader(buf.toString());
    }
}

