/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.util.Collection;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenSharabilityQueryImpl
implements SharabilityQueryImplementation {
    private final NbMavenProjectImpl project;

    public MavenSharabilityQueryImpl(NbMavenProjectImpl proj) {
        this.project = proj;
    }

    private Boolean checkShare(File file) {
        File target;
        MavenProject proj;
        Build build;
        M2ConfigProvider configs;
        File basedir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        if (!file.getAbsolutePath().startsWith(basedir.getAbsolutePath())) {
            return null;
        }
        if (basedir.equals(file.getParentFile()) && "nbproject".equals(file.getName())) {
            return false;
        }
        if (file.equals(new File(basedir, "profiles.xml"))) {
            return false;
        }
        if (file.getName().startsWith("nbactions") && file.getParentFile().equals(basedir) && (configs = (M2ConfigProvider)this.project.getLookup().lookup(M2ConfigProvider.class)) != null) {
            Collection<M2Configuration> col = configs.getNonSharedConfigurations();
            for (M2Configuration conf : col) {
                if (!file.getName().equals(M2Configuration.getFileNameExt(conf.getId()))) continue;
                return false;
            }
        }
        if ((build = (proj = this.project.getOriginalMavenProject()).getBuild()) != null && build.getDirectory() != null && ((target = new File(build.getDirectory())).equals(file) || file.getAbsolutePath().startsWith(target.getAbsolutePath()))) {
            return false;
        }
        return true;
    }

    public int getSharability(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null && fo.equals(this.project.getProjectDirectory())) {
            return 3;
        }
        Boolean check = this.checkShare(file);
        if (check == null) {
            return 0;
        }
        if (Boolean.TRUE.equals(check)) {
            if (file.isDirectory()) {
                return 3;
            }
            return 1;
        }
        return 2;
    }
}

