/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.options.MavenSettings;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class BeanRunConfig
implements RunConfig {
    private File executionDirectory;
    private WeakReference<Project> project;
    private FileObject projectDirectory;
    private List<String> goals;
    private String executionName;
    private Properties properties;
    private boolean showDebug = MavenSettings.getDefault().isShowDebug();
    private boolean showError = MavenSettings.getDefault().isShowErrors();
    private Boolean offline = MavenSettings.getDefault().isOffline();
    private boolean updateSnapshots = MavenSettings.getDefault().isUpdateSnapshots();
    private boolean interactive = MavenSettings.getDefault().isInteractive();
    private List<String> activate;
    private boolean recursive = true;
    private String taskName;
    private RunConfig parent;
    private String actionName;
    private FileObject selectedFO;
    private MavenProject mp;
    private RunConfig preexecution;
    private String preactionname;
    private RunConfig.ReactorStyle reactor = RunConfig.ReactorStyle.NONE;

    public BeanRunConfig() {
    }

    public BeanRunConfig(RunConfig parent) {
        this.parent = parent;
        this.setRecursive(parent.isRecursive());
        this.setInteractive(parent.isInteractive());
        this.setOffline(parent.isOffline());
        this.setShowDebug(parent.isShowDebug());
        this.setShowError(parent.isShowError());
        this.setUpdateSnapshots(parent.isUpdateSnapshots());
        this.setReactorStyle(parent.getReactorStyle());
    }

    @Override
    public final File getExecutionDirectory() {
        if (this.parent != null && this.executionDirectory == null) {
            return this.parent.getExecutionDirectory();
        }
        return this.executionDirectory;
    }

    @Override
    public final void setExecutionDirectory(File executionDirectory) {
        this.executionDirectory = executionDirectory;
    }

    @Override
    public final Project getProject() {
        if (this.parent != null && this.project == null) {
            return this.parent.getProject();
        }
        if (this.project != null) {
            Project prj = (Project)this.project.get();
            if (prj == null && this.projectDirectory.isValid()) {
                try {
                    prj = ProjectManager.getDefault().findProject(this.projectDirectory);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return prj;
        }
        return null;
    }

    @Override
    public final synchronized MavenProject getMavenProject() {
        if (this.mp != null) {
            return this.mp;
        }
        Project prj = this.getProject();
        if (prj != null) {
            NbMavenProjectImpl impl = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
            ArrayList<String> profiles = new ArrayList<String>();
            profiles.addAll(impl.getCurrentActiveProfiles());
            if (this.getActivatedProfiles() != null) {
                profiles.addAll(this.getActivatedProfiles());
            }
            Properties props = new Properties();
            if (this.getProperties() != null) {
                props.putAll((Map<?, ?>)this.getProperties());
            }
            this.mp = impl.loadMavenProject(EmbedderFactory.createProjectLikeEmbedder(), profiles, props);
        }
        return this.mp;
    }

    public final synchronized void setProject(Project project) {
        if (project != null) {
            this.project = new WeakReference<Project>(project);
            this.projectDirectory = project.getProjectDirectory();
        } else {
            this.project = null;
            this.projectDirectory = null;
        }
        this.mp = null;
    }

    @Override
    public final List<String> getGoals() {
        if (this.parent != null && this.goals == null) {
            return this.parent.getGoals();
        }
        return this.goals;
    }

    public final void setGoals(List<String> goals) {
        this.goals = goals;
    }

    @Override
    public final String getExecutionName() {
        if (this.parent != null && this.executionName == null) {
            return this.parent.getExecutionName();
        }
        return this.executionName;
    }

    public final void setExecutionName(String executionName) {
        this.executionName = executionName;
    }

    @Override
    public final Properties getProperties() {
        if (this.parent != null && this.properties == null) {
            return this.parent.getProperties();
        }
        Properties newProperties = new Properties();
        if (this.properties != null) {
            newProperties.putAll((Map<?, ?>)this.properties);
        }
        return newProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String removeProperty(String key) {
        if (this.properties == null) {
            this.properties = new Properties();
            if (this.parent != null) {
                this.properties.putAll((Map<?, ?>)this.parent.getProperties());
            }
        }
        String toRet = (String)this.properties.remove(key);
        BeanRunConfig beanRunConfig = this;
        synchronized (beanRunConfig) {
            this.mp = null;
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
            if (this.parent != null) {
                this.properties.putAll((Map<?, ?>)this.parent.getProperties());
            }
        }
        String toRet = (String)this.properties.setProperty(key, value);
        BeanRunConfig beanRunConfig = this;
        synchronized (beanRunConfig) {
            this.mp = null;
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setProperties(Properties props) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)props);
        BeanRunConfig beanRunConfig = this;
        synchronized (beanRunConfig) {
            this.mp = null;
        }
    }

    @Override
    public final boolean isShowDebug() {
        return this.showDebug;
    }

    public final void setShowDebug(boolean showDebug) {
        this.showDebug = showDebug;
    }

    @Override
    public final boolean isShowError() {
        return this.showError;
    }

    public final void setShowError(boolean showError) {
        this.showError = showError;
    }

    @Override
    public final Boolean isOffline() {
        return this.offline;
    }

    @Override
    public final void setOffline(Boolean offline) {
        this.offline = offline;
    }

    @Override
    public final List<String> getActivatedProfiles() {
        if (this.parent != null && this.activate == null) {
            return this.parent.getActivatedProfiles();
        }
        if (this.activate != null) {
            return Collections.unmodifiableList(this.activate);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setActivatedProfiles(List<String> activeteProfiles) {
        this.activate = new ArrayList<String>();
        this.activate.addAll(activeteProfiles);
        BeanRunConfig beanRunConfig = this;
        synchronized (beanRunConfig) {
            this.mp = null;
        }
    }

    @Override
    public final boolean isRecursive() {
        return this.recursive;
    }

    public final void setRecursive(boolean rec) {
        this.recursive = rec;
    }

    @Override
    public final boolean isUpdateSnapshots() {
        return this.updateSnapshots;
    }

    public final void setUpdateSnapshots(boolean set) {
        this.updateSnapshots = set;
    }

    @Override
    public final String getTaskDisplayName() {
        if (this.parent != null && this.taskName == null) {
            return this.parent.getTaskDisplayName();
        }
        return this.taskName;
    }

    public final void setTaskDisplayName(String name) {
        this.taskName = name;
    }

    @Override
    public final boolean isInteractive() {
        return this.interactive;
    }

    public final void setInteractive(boolean ia) {
        this.interactive = ia;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    @Override
    public String getActionName() {
        if (this.parent != null && this.actionName == null) {
            return this.parent.getActionName();
        }
        return this.actionName;
    }

    @Override
    public FileObject getSelectedFileObject() {
        if (this.parent != null && this.selectedFO == null) {
            return this.parent.getSelectedFileObject();
        }
        return this.selectedFO;
    }

    public void setFileObject(FileObject selectedFile) {
        this.selectedFO = selectedFile;
    }

    @Override
    public RunConfig getPreExecution() {
        if (this.parent != null && this.preexecution == null) {
            return this.parent.getPreExecution();
        }
        return this.preexecution;
    }

    public void setPreExecution(RunConfig config) {
        this.preexecution = config;
    }

    public void setPreExecutionActionName(String preactionname) {
        this.preactionname = preactionname;
    }

    public String getPreExecutionActionName() {
        return this.preactionname;
    }

    @Override
    public RunConfig.ReactorStyle getReactorStyle() {
        return this.reactor;
    }

    public void setReactorStyle(RunConfig.ReactorStyle style) {
        this.reactor = style;
    }
}

