/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.classpath.EndorsedClassPathImpl;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.util.WeakListeners;

public final class BootClassPathImpl
implements ClassPathImplementation,
PropertyChangeListener {
    private List<? extends PathResourceImplementation> resourcesCache;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final NbMavenProjectImpl project;
    private String lastHintValue = null;
    private boolean activePlatformValid = true;
    private JavaPlatformManager platformManager;
    private final EndorsedClassPathImpl ecpImpl;
    final Object LOCK = new Object();

    BootClassPathImpl(NbMavenProjectImpl project, EndorsedClassPathImpl ecpImpl) {
        this.project = project;
        this.ecpImpl = ecpImpl;
        ecpImpl.setBCP(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends PathResourceImplementation> getResources() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.resourcesCache == null) {
                ArrayList<Object> result = new ArrayList<Object>();
                result.addAll(this.ecpImpl.getResources());
                JavaPlatform jp = this.findActivePlatform();
                if (jp != null) {
                    ClassPath cp = jp.getBootstrapLibraries();
                    List entries = cp.entries();
                    for (ClassPath.Entry entry : entries) {
                        result.add(ClassPathSupport.createResource((URL)entry.getURL()));
                    }
                }
                this.resourcesCache = Collections.unmodifiableList(result);
            }
            return this.resourcesCache;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaPlatform findActivePlatform() {
        Object object = this.LOCK;
        synchronized (object) {
            String val;
            this.activePlatformValid = true;
            if (this.platformManager == null) {
                this.platformManager = JavaPlatformManager.getDefault();
                this.platformManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.platformManager));
                NbMavenProject watch = this.project.getProjectWatcher();
                watch.addPropertyChangeListener(this);
            }
            this.lastHintValue = val = this.project.getAuxProps().get("netbeans.hint.jdkPlatform", true);
            JavaPlatform plat = BootClassPathImpl.getActivePlatform(val);
            if (plat == null) {
                Logger.getLogger(BootClassPathImpl.class.getName()).fine("Cannot find java platform with id of '" + val + "'");
                plat = this.platformManager.getDefaultPlatform();
                this.activePlatformValid = false;
            }
            return plat;
        }
    }

    public static JavaPlatform getActivePlatform(String activePlatformId) {
        JavaPlatformManager pm = JavaPlatformManager.getDefault();
        if (activePlatformId == null) {
            return pm.getDefaultPlatform();
        }
        JavaPlatform[] installedPlatforms = pm.getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < installedPlatforms.length; ++i) {
            String antName = (String)installedPlatforms[i].getProperties().get("platform.ant.name");
            if (antName == null || !antName.equals(activePlatformId)) continue;
            return installedPlatforms[i];
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String newVal = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.jdkPlatform", true);
        if (evt.getSource() == this.project && evt.getPropertyName().equals("MavenProject")) {
            if (this.ecpImpl.resetCache()) {
                this.resetCache();
            } else if (newVal == null && this.lastHintValue != null || newVal != null && !newVal.equals(this.lastHintValue)) {
                this.resetCache();
            }
        } else if (evt.getSource() == this.platformManager && "installedPlatforms".equals(evt.getPropertyName()) && this.lastHintValue != null) {
            this.lastHintValue = newVal;
            if (this.activePlatformValid) {
                if (BootClassPathImpl.getActivePlatform(this.lastHintValue) == null) {
                    this.resetCache();
                }
            } else if (BootClassPathImpl.getActivePlatform(this.lastHintValue) != null) {
                this.resetCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache() {
        Object object = this.LOCK;
        synchronized (object) {
            this.resourcesCache = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }
}

