/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyManagement;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMComponentFactory;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.maven.model.pom.Repository;
import org.netbeans.modules.maven.options.MavenVersionSettings;
import org.openide.filesystems.FileObject;

public final class ModelUtils {
    private static Pattern DEFAULT = Pattern.compile("(.+)[/]{1}(.+)[/]{1}(.+)[/]{1}(.+)\\.pom");
    private static Pattern LEGACY = Pattern.compile("(.+)[/]{1}poms[/]{1}([a-zA-Z0-9_]+[a-zA-Z\\-_]+)[\\-]{1}([0-9]{1}.+)\\.pom");

    public static void addDependency(FileObject pom, final String group, final String artifact, final String version, final String type, final String scope, final String classifier, final boolean acceptNull) {
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){
            private static final String BUNDLE_TYPE = "bundle";

            public void performOperation(POMModel model) {
                Dependency dep = ModelUtils.checkModelDependency(model, group, artifact, true);
                dep.setVersion(version);
                if (acceptNull || scope != null) {
                    dep.setScope(scope);
                }
                if (acceptNull || type != null && !BUNDLE_TYPE.equals(type)) {
                    dep.setType(type);
                }
                if (acceptNull || classifier != null) {
                    dep.setClassifier(classifier);
                }
            }
        };
        Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
    }

    public static Dependency checkModelDependency(POMModel pom, String groupId, String artifactId, boolean add) {
        DependencyManagement mng;
        Project mdl = pom.getProject();
        Dependency ret = mdl.findDependencyById(groupId, artifactId, null);
        Dependency managed = null;
        if ((ret == null || ret.getVersion() == null) && (mng = mdl.getDependencyManagement()) != null) {
            managed = mng.findDependencyById(groupId, artifactId, null);
        }
        if (add && ret == null) {
            ret = mdl.getModel().getFactory().createDependency();
            ret.setGroupId(groupId);
            ret.setArtifactId(artifactId);
            mdl.addDependency(ret);
        }
        return managed == null ? ret : managed;
    }

    public static boolean hasModelDependency(POMModel mdl, String groupid, String artifactid) {
        return ModelUtils.checkModelDependency(mdl, groupid, artifactid, false) != null;
    }

    public static Repository addModelRepository(MavenProject project, POMModel mdl, String url) {
        if (url.contains("http://repo1.maven.org/maven2")) {
            return null;
        }
        List repos = mdl.getProject().getRepositories();
        if (repos != null) {
            for (Repository r : repos) {
                if (!url.equals(r.getUrl())) continue;
                return null;
            }
        }
        List reps = project.getRepositories();
        org.apache.maven.model.Repository prjret = null;
        Repository ret = null;
        if (reps != null) {
            for (org.apache.maven.model.Repository re : reps) {
                if (!url.equals(re.getUrl())) continue;
                prjret = re;
                break;
            }
        }
        if (prjret == null) {
            ret = mdl.getFactory().createRepository();
            ret.setUrl(url);
            ret.setId(url);
            mdl.getProject().addRepository(ret);
        }
        return ret;
    }

    public static void checkSourceLevel(ModelHandle handle, String sourceLevel) {
        Plugin plugin;
        String source = PluginPropertyUtils.getPluginProperty(handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", "source", "compile");
        if (source != null && source.contains(sourceLevel)) {
            return;
        }
        POMModel mdl = handle.getPOMModel();
        Plugin old = null;
        Build bld = mdl.getProject().getBuild();
        if (bld != null) {
            old = bld.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin");
        } else {
            mdl.getProject().setBuild(mdl.getFactory().createBuild());
        }
        if (old != null) {
            plugin = old;
        } else {
            plugin = mdl.getFactory().createPlugin();
            plugin.setGroupId("org.apache.maven.plugins");
            plugin.setArtifactId("maven-compiler-plugin");
            plugin.setVersion(MavenVersionSettings.getDefault().getVersion("maven-compiler-plugin"));
            mdl.getProject().getBuild().addPlugin(plugin);
        }
        Configuration conf = plugin.getConfiguration();
        if (conf == null) {
            conf = mdl.getFactory().createConfiguration();
            plugin.setConfiguration(conf);
        }
        conf.setSimpleParameter("source", sourceLevel);
        conf.setSimpleParameter("target", sourceLevel);
        handle.markAsModified(handle.getPOMModel());
    }

    public static void checkEncoding(ModelHandle handle, String enc) {
        boolean updateResources;
        boolean updateCompiler;
        String source = handle.getProject().getProperties().getProperty("project.build.sourceEncoding");
        if (source != null && source.contains(enc)) {
            return;
        }
        Properties props = handle.getPOMModel().getProject().getProperties();
        if (props == null) {
            props = handle.getPOMModel().getFactory().createProperties();
            handle.getPOMModel().getProject().setProperties(props);
            handle.markAsModified(handle.getPOMModel());
        }
        props.setProperty("project.build.sourceEncoding", enc);
        boolean createPlugins = source == null;
        POMModel model = handle.getPOMModel();
        POMComponentFactory fact = model.getFactory();
        Build bld = handle.getPOMModel().getProject().getBuild();
        if (bld == null) {
            if (createPlugins) {
                bld = fact.createBuild();
                model.getProject().setBuild(bld);
            } else {
                return;
            }
        }
        Plugin plugin = bld.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin");
        Plugin plugin2 = bld.findPluginById("org.apache.maven.plugins", "maven-resources-plugin");
        String compilesource = PluginPropertyUtils.getPluginProperty(handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", "encoding", null);
        String resourcesource = PluginPropertyUtils.getPluginProperty(handle.getProject(), "org.apache.maven.plugins", "maven-resources-plugin", "encoding", null);
        boolean bl = updateCompiler = createPlugins || compilesource != null;
        if (plugin == null && updateCompiler) {
            plugin = fact.createPlugin();
            plugin.setGroupId("org.apache.maven.plugins");
            plugin.setArtifactId("maven-compiler-plugin");
            plugin.setVersion(MavenVersionSettings.getDefault().getVersion("maven-compiler-plugin"));
            bld.addPlugin(plugin);
        }
        if (plugin != null) {
            Configuration conf = plugin.getConfiguration();
            if (conf == null && updateCompiler) {
                conf = fact.createConfiguration();
                plugin.setConfiguration(conf);
            }
            if (conf != null && updateCompiler) {
                conf.setSimpleParameter("encoding", "${project.build.sourceEncoding}");
            }
        }
        boolean bl2 = updateResources = createPlugins || resourcesource != null;
        if (plugin2 == null && updateResources) {
            plugin2 = fact.createPlugin();
            plugin2.setGroupId("org.apache.maven.plugins");
            plugin2.setArtifactId("maven-resources-plugin");
            plugin2.setVersion(MavenVersionSettings.getDefault().getVersion("maven-resources-plugin"));
            bld.addPlugin(plugin2);
        }
        if (plugin2 != null) {
            Configuration conf = plugin2.getConfiguration();
            if (conf == null && updateResources) {
                conf = fact.createConfiguration();
                plugin2.setConfiguration(conf);
            }
            if (conf != null && updateResources) {
                conf.setSimpleParameter("encoding", "${project.build.sourceEncoding}");
            }
        }
    }

    public static POMExtensibilityElement getOrCreateChild(POMComponent parent, String localQName, POMModel pomModel) {
        POMExtensibilityElement result = null;
        for (POMExtensibilityElement el : parent.getExtensibilityElements()) {
            if (!localQName.equals(el.getQName().getLocalPart())) continue;
            result = el;
            break;
        }
        if (result == null) {
            result = pomModel.getFactory().createPOMExtensibilityElement(new QName(localQName));
            parent.addExtensibilityElement(result);
        }
        return result;
    }

    public static LibraryDescriptor checkLibrary(URL pom, Set<String> knownRepositories) {
        String path = pom.getPath();
        Matcher match = LEGACY.matcher(path);
        boolean def = false;
        if (!match.matches()) {
            match = DEFAULT.matcher(path);
            def = true;
        }
        if (match.matches()) {
            String classifier = pom.getRef();
            String repoType = def ? "default" : "legacy";
            String repoRoot = pom.getProtocol() + "://" + pom.getHost() + (pom.getPort() != -1 ? ":" + pom.getPort() : "");
            String groupId = match.group(1);
            String artifactId = match.group(2);
            String version = match.group(3);
            for (String repoString : knownRepositories) {
                try {
                    URL repo = new URL(repoString);
                    String root = repo.getProtocol() + "://" + repo.getHost() + (repo.getPort() != -1 ? ":" + repo.getPort() : "");
                    if (!root.equals(repoRoot) || !groupId.startsWith(repo.getPath())) continue;
                    repoRoot = repoRoot + repo.getPath();
                    groupId = groupId.substring(repo.getPath().length());
                    break;
                }
                catch (MalformedURLException ex) {
                }
            }
            if (groupId.startsWith("/")) {
                groupId = groupId.substring(1);
            }
            if (groupId.startsWith("maven/")) {
                repoRoot = repoRoot + "/maven";
                groupId = groupId.substring("maven/".length());
            }
            if (groupId.startsWith("maven2/")) {
                repoRoot = repoRoot + "/maven2";
                groupId = groupId.substring("maven2/".length());
            }
            if (groupId.startsWith("mirror/eclipse/rt/eclipselink/maven.repo/")) {
                repoRoot = repoRoot + "/mirror/eclipse/rt/eclipselink/maven.repo";
                groupId = groupId.substring("mirror/eclipse/rt/eclipselink/maven.repo/".length());
            }
            groupId = groupId.replace('/', '.');
            return new LibraryDescriptor(repoType, repoRoot, groupId, artifactId, version, classifier);
        }
        return null;
    }

    public static class LibraryDescriptor {
        private String repoType;
        private String repoRoot;
        private String groupId;
        private String artifactId;
        private String version;
        private String classifier;

        LibraryDescriptor(String repoType, String repoRoot, String groupId, String artifactId, String version, String classifier) {
            this.repoType = repoType;
            this.repoRoot = repoRoot;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.classifier = classifier;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getRepoRoot() {
            return this.repoRoot;
        }

        public String getRepoType() {
            return this.repoType;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

