/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import hidden.org.codehaus.plexus.util.IOUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.model.Model;
import org.apache.maven.profiles.Profile;
import org.apache.maven.profiles.ProfilesRoot;
import org.apache.maven.profiles.io.xpp3.ProfilesXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.build.model.ModelLineage;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenSettingsSingleton;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.profile.ProfilesModel;
import org.netbeans.modules.maven.model.profile.ProfilesModelFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectProfileHandlerImpl
implements ProjectProfileHandler {
    private static final String PROFILES = "profiles";
    private static final String ACTIVEPROFILES = "activeProfiles";
    private static final String SEPERATOR = " ";
    private static final String NAMESPACE = null;
    private List<String> privateProfiles = new ArrayList<String>();
    private List<String> sharedProfiles = new ArrayList<String>();
    private AuxiliaryConfiguration ac;
    private final NbMavenProjectImpl nmp;
    private ModelLineage lineage;
    private boolean haveTried = false;

    ProjectProfileHandlerImpl(NbMavenProjectImpl nmp, AuxiliaryConfiguration ac) {
        this.nmp = nmp;
        this.ac = ac;
        this.privateProfiles.addAll(this.retrieveActiveProfiles(ac, false));
        this.sharedProfiles.addAll(this.retrieveActiveProfiles(ac, true));
    }

    synchronized void clearLineageCache() {
        this.lineage = null;
        this.haveTried = false;
    }

    synchronized ModelLineage getLineage() {
        if (this.lineage == null && !this.haveTried) {
            try {
                this.lineage = EmbedderFactory.createModelLineage((File)this.nmp.getPOMFile(), (MavenEmbedder)this.nmp.getEmbedder(), (boolean)true);
            }
            catch (ProjectBuildingException ex) {
                Logger.getLogger(ProjectProfileHandlerImpl.class.getName()).log(Level.FINE, "Error reading model lineage", ex);
                this.haveTried = true;
            }
        }
        return this.lineage;
    }

    @Override
    public List<String> getAllProfiles() {
        HashSet<String> profileIds = new HashSet<String>();
        this.extractProfiles(profileIds);
        profileIds.addAll(MavenSettingsSingleton.getInstance().createUserSettingsModel().getProfilesAsMap().keySet());
        return new ArrayList<String>(profileIds);
    }

    @Override
    public List<String> getActiveProfiles(boolean shared) {
        return new ArrayList<String>(shared ? this.sharedProfiles : this.privateProfiles);
    }

    @Override
    public List<String> getMergedActiveProfiles(boolean shared) {
        FileObject profilesFo;
        HashSet<String> profileIds = new HashSet<String>();
        MavenProject mavenProject = this.nmp.getOriginalMavenProject();
        List profiles = mavenProject.getActiveProfiles();
        for (org.apache.maven.model.Profile profile : profiles) {
            profileIds.add(profile.getId());
        }
        List profileStrings = MavenSettingsSingleton.getInstance().createUserSettingsModel().getActiveProfiles();
        for (String profile : profileStrings) {
            profileIds.add(profile);
        }
        File basedir = FileUtil.normalizeFile((File)mavenProject.getBasedir());
        FileObject fileObject = FileUtil.toFileObject((File)basedir);
        if (fileObject != null && (profilesFo = fileObject.getFileObject("profiles.xml")) != null) {
            List actProfs;
            ModelSource ms = Utilities.createModelSource((FileObject)profilesFo);
            ProfilesModel pm = ProfilesModelFactory.getDefault().getModel(ms);
            if (Model.State.VALID.equals((Object)pm.getState()) && (actProfs = pm.getProfilesRoot().getActiveProfiles()) != null) {
                profileIds.addAll(actProfs);
            }
        }
        profileIds.addAll(this.getActiveProfiles(shared));
        return new ArrayList<String>(profileIds);
    }

    @Override
    public void disableProfile(String id, boolean shared) {
        String activeProfiles;
        Element element = this.ac.getConfigurationFragment(PROFILES, NAMESPACE, shared);
        if (element == null) {
            String root = "project-private";
            Document doc = XMLUtil.createDocument((String)root, (String)NAMESPACE, null, null);
            element = doc.createElementNS(NAMESPACE, PROFILES);
        }
        if ((activeProfiles = element.getAttributeNS(NAMESPACE, ACTIVEPROFILES)) != null && activeProfiles.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(activeProfiles, SEPERATOR);
            HashSet<String> set = new HashSet<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                set.add(tokenizer.nextToken());
            }
            set.remove(id);
            StringBuffer buffer = new StringBuffer();
            for (String profle : set) {
                buffer.append(profle).append(SEPERATOR);
            }
            element.setAttributeNS(NAMESPACE, ACTIVEPROFILES, buffer.toString().trim());
        }
        this.ac.putConfigurationFragment(element, shared);
        if (shared) {
            this.sharedProfiles.remove(id);
        } else {
            this.privateProfiles.remove(id);
        }
    }

    @Override
    public void enableProfile(String id, boolean shared) {
        Element element = this.ac.getConfigurationFragment(PROFILES, NAMESPACE, shared);
        if (element == null) {
            String root = "project-private";
            Document doc = XMLUtil.createDocument((String)root, (String)NAMESPACE, null, null);
            element = doc.createElementNS(NAMESPACE, PROFILES);
        }
        String activeProfiles = element.getAttributeNS(NAMESPACE, ACTIVEPROFILES);
        element.setAttributeNS(NAMESPACE, ACTIVEPROFILES, activeProfiles + SEPERATOR + id);
        this.ac.putConfigurationFragment(element, shared);
        if (shared) {
            if (!this.sharedProfiles.contains(id)) {
                this.sharedProfiles.add(id);
            }
        } else if (!this.privateProfiles.contains(id)) {
            this.privateProfiles.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractProfiles(Set<String> profileIds) {
        FileObject profiles;
        this.extractProfilesFromModelLineage(profileIds);
        File basedir = FileUtil.normalizeFile((File)this.nmp.getPOMFile().getParentFile());
        FileObject fileObject = FileUtil.toFileObject((File)basedir);
        if (fileObject != null && (profiles = fileObject.getFileObject("profiles.xml")) != null) {
            ProfilesXpp3Reader reader = new ProfilesXpp3Reader();
            InputStream in = null;
            try {
                in = profiles.getInputStream();
                ProfilesRoot root = reader.read(in);
                List profs = root.getProfiles();
                for (Profile prf : profs) {
                    profileIds.add(prf.getId());
                }
            }
            catch (Exception e) {
                Logger.getLogger(ProjectProfileHandlerImpl.class.getName()).log(Level.FINE, "Error while retrieving profiles from profiles.xml file. Ignore.", e);
            }
            finally {
                IOUtil.close((InputStream)in);
            }
        }
    }

    private void extractProfilesFromModelLineage(Set<String> profileIds) {
        ModelLineage lin = this.getLineage();
        if (lin == null) {
            return;
        }
        Iterator it = lin.modelIterator();
        while (it.hasNext()) {
            Model mdl = (Model)it.next();
            List mdlProfiles = mdl.getProfiles();
            if (mdlProfiles == null) continue;
            for (org.apache.maven.model.Profile prf : mdlProfiles) {
                profileIds.add(prf.getId());
            }
        }
    }

    private List<String> retrieveActiveProfiles(AuxiliaryConfiguration ac, boolean shared) {
        String activeProfiles;
        HashSet<String> prifileides = new HashSet<String>();
        Element element = ac.getConfigurationFragment(PROFILES, NAMESPACE, shared);
        if (element != null && (activeProfiles = element.getAttributeNS(NAMESPACE, ACTIVEPROFILES)) != null && activeProfiles.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(activeProfiles, SEPERATOR);
            while (tokenizer.hasMoreTokens()) {
                prifileides.add(tokenizer.nextToken());
            }
        }
        return new ArrayList<String>(prifileides);
    }
}

