/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lexer.nbbridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Language;
import org.netbeans.lib.lexer.LanguageManager;
import org.netbeans.modules.lexer.nbbridge.LanguagesEmbeddingMap;
import org.netbeans.spi.editor.mimelookup.Class2LayerFolder;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.openide.filesystems.FileObject;

public class MimeLookupFolderInfo
implements Class2LayerFolder,
InstanceProvider {
    private static final Logger LOG = Logger.getLogger(MimeLookupFolderInfo.class.getName());

    public Class getClazz() {
        return LanguagesEmbeddingMap.class;
    }

    public String getLayerFolderName() {
        return "languagesEmbeddingMap";
    }

    public InstanceProvider getInstanceProvider() {
        return this;
    }

    public Object createInstance(List fileObjectList) {
        HashMap map = new HashMap();
        for (Object o : fileObjectList) {
            assert (o instanceof FileObject) : "fileObjectList should contain FileObjects and not " + o;
            FileObject f = (FileObject)o;
            try {
                Object[] info = this.parseFile(f);
                String mimeType = (String)info[0];
                int startSkipLength = (Integer)info[1];
                int endSkipLength = (Integer)info[2];
                if (this.isMimeTypeValid(mimeType)) {
                    Language language = LanguageManager.getInstance().findLanguage(mimeType);
                    if (language != null) {
                        map.put(f.getName(), LanguageEmbedding.create((Language)language, (int)startSkipLength, (int)endSkipLength));
                        continue;
                    }
                    LOG.warning("Can't find Language for mime type '" + mimeType + "', ignoring.");
                    continue;
                }
                LOG.log(Level.WARNING, "Ignoring invalid mime type '" + mimeType + "' from: " + f.getPath());
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, "Can't read language embedding definition from: " + f.getPath());
            }
        }
        return new LanguagesEmbeddingMap(map);
    }

    private boolean isMimeTypeValid(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        int slashIndex = mimeType.indexOf(47);
        if (slashIndex == -1) {
            return false;
        }
        return mimeType.indexOf(47, slashIndex + 1) == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] parseFile(FileObject f) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(f.getInputStream()));
        try {
            String line;
            while (null != (line = r.readLine())) {
                line.trim();
                if (line.length() == 0) continue;
                String[] parts = line.split(",");
                Object[] objectArray = new Object[]{parts[0], parts.length > 1 ? this.toInt(parts[1], "Ignoring invalid start-skip-length '{0}' in " + f.getPath()) : 0, parts.length > 2 ? this.toInt(parts[2], "Ignoring invalid end-skip-length '{0}' in " + f.getPath()) : 0};
                return objectArray;
            }
            Object[] objectArray = null;
            return objectArray;
        }
        finally {
            r.close();
        }
    }

    private int toInt(String s, String errorMsg) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            LOG.log(Level.WARNING, MessageFormat.format(errorMsg, s), e);
            return 0;
        }
    }
}

