/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.unit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.Strings;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.util.PersistenceProviderComboboxHelper;
import org.netbeans.modules.j2ee.persistence.util.SourceLevelChecker;
import org.netbeans.modules.j2ee.persistence.wizard.unit.JdbcListCellRenderer;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizard;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardDescriptor;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class PersistenceUnitWizardPanelJdbc
extends PersistenceUnitWizardPanel {
    private ButtonGroup buttonGroup1;
    private JLabel createPUWarningLabel;
    private JRadioButton ddlCreate;
    private JRadioButton ddlDropCreate;
    private JRadioButton ddlUnkown;
    private JLabel errorMessage;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox jdbcCombo;
    private JLabel jdbcLabel;
    private JComboBox libraryCombo;
    private JLabel libraryLabel;
    private ButtonGroup tableCreationButtonGroup;
    private JLabel unitNameLabel;
    private JTextField unitNameTextField;
    private JPanel warnPanel;

    public PersistenceUnitWizardPanelJdbc(Project project, ChangeListener changeListener, boolean bl) {
        this(project, changeListener, bl, PersistenceUnitWizardPanel.TableGeneration.CREATE);
    }

    public PersistenceUnitWizardPanelJdbc(Project project, ChangeListener changeListener, boolean bl, PersistenceUnitWizardPanel.TableGeneration tableGeneration) {
        super(project);
        this.initComponents();
        this.setTableGeneration(tableGeneration);
        PersistenceProviderComboboxHelper persistenceProviderComboboxHelper = new PersistenceProviderComboboxHelper(project);
        persistenceProviderComboboxHelper.connect(this.libraryCombo);
        this.unitNameTextField.setText(this.getCandidateName());
        this.unitNameTextField.selectAll();
        this.unitNameTextField.setVisible(bl);
        this.unitNameLabel.setVisible(bl);
        DatabaseExplorerUIs.connect((JComboBox)this.jdbcCombo, (ConnectionManager)ConnectionManager.getDefault());
        this.jdbcCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PersistenceUnitWizardPanelJdbc.this.checkValidity();
            }
        });
        this.unitNameTextField.getDocument().addDocumentListener(new ValidationListener());
        this.errorMessage.setForeground(Color.RED);
        this.updateWarning();
    }

    private void setTableGeneration(PersistenceUnitWizardPanel.TableGeneration tableGeneration) {
        if (PersistenceUnitWizardPanel.TableGeneration.CREATE.equals((Object)tableGeneration)) {
            this.ddlCreate.setSelected(true);
        } else if (PersistenceUnitWizardPanel.TableGeneration.DROP_CREATE.equals((Object)tableGeneration)) {
            this.ddlDropCreate.setSelected(true);
        } else {
            this.ddlUnkown.setSelected(true);
        }
    }

    private void checkValidity() {
        if (this.isValidPanel()) {
            this.firePropertyChange("PersistenceUnitWizardPanel_isValid", false, true);
        } else {
            this.firePropertyChange("PersistenceUnitWizardPanel_isValid", true, false);
        }
    }

    @Override
    public String getPersistenceUnitName() {
        return this.unitNameTextField.getText();
    }

    @Override
    public Provider getSelectedProvider() {
        return (Provider)this.libraryCombo.getSelectedItem();
    }

    public DatabaseConnection getPersistenceConnection() {
        return (DatabaseConnection)this.jdbcCombo.getSelectedItem();
    }

    @Override
    public void setPreselectedDB(String string) {
        boolean bl = false;
        for (int i = 0; i < this.jdbcCombo.getItemCount(); ++i) {
            DatabaseConnection databaseConnection;
            if (!(this.jdbcCombo.getItemAt(i) instanceof DatabaseConnection) || !(databaseConnection = (DatabaseConnection)this.jdbcCombo.getItemAt(i)).getDisplayName().equals(string) && !databaseConnection.toString().equals(string)) continue;
            bl = true;
            break;
        }
        this.jdbcCombo.setSelectedItem(ConnectionManager.getDefault().getConnection(string));
        this.jdbcCombo.setEnabled(!bl);
    }

    @Override
    public String getTableGeneration() {
        if (this.ddlCreate.isSelected()) {
            return "tableGenerationCreate";
        }
        if (this.ddlDropCreate.isSelected()) {
            return "tableGenerationDropCreate";
        }
        return "tableGenerationUnknown";
    }

    @Override
    public boolean isValidPanel() {
        if (!(this.libraryCombo.getSelectedItem() instanceof Provider)) {
            return false;
        }
        if (!(this.jdbcCombo.getSelectedItem() instanceof DatabaseConnection)) {
            return false;
        }
        try {
            if (!this.isNameValid()) {
                return false;
            }
        }
        catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
            this.setErrorMessage(NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_InvalidPersistenceXml", (Object)invalidPersistenceXmlException.getPath()));
            return false;
        }
        return true;
    }

    private boolean isNameValid() throws InvalidPersistenceXmlException {
        return Strings.isEmpty((String)this.getPersistenceUnitName()) ? false : this.isNameUnique();
    }

    @Override
    public void setErrorMessage(String string) {
        this.errorMessage.setText(string);
    }

    private void updateWarning() {
        Object object;
        Object object2 = this.libraryCombo.getSelectedItem();
        Provider provider = (Provider)(object2 instanceof Provider ? object2 : null);
        String string = null;
        if (provider != null && "2.0".equals(ProviderUtil.getVersion(provider)) && (object = SourceLevelChecker.getSourceLevel(this.project)) != null && !"1.6".equals(object) && !(Double.parseDouble((String)object) >= 1.6)) {
            string = NbBundle.getMessage(PersistenceUnitWizard.class, (String)"ERR_WrongSourceLevel", (Object)object);
        }
        object = null;
        if (string != null) {
            object = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/j2ee/persistence/ui/resources/warning.gif", (boolean)false);
        } else {
            string = "  ";
        }
        this.createPUWarningLabel.setIcon((Icon)object);
        this.createPUWarningLabel.setText(string);
        this.createPUWarningLabel.setToolTipText(string);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.tableCreationButtonGroup = new ButtonGroup();
        this.unitNameLabel = new JLabel();
        this.unitNameTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.ddlCreate = new JRadioButton();
        this.ddlDropCreate = new JRadioButton();
        this.ddlUnkown = new JRadioButton();
        this.libraryLabel = new JLabel();
        this.libraryCombo = new JComboBox();
        this.jdbcCombo = new JComboBox();
        this.jdbcLabel = new JLabel();
        this.warnPanel = new JPanel();
        this.errorMessage = new JLabel();
        this.createPUWarningLabel = new ShyLabel();
        this.setName(NbBundle.getMessage(PersistenceUnitWizardPanelJdbc.class, (String)"LBL_Step1"));
        this.unitNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("MN_UnitName").charAt(0));
        this.unitNameLabel.setLabelFor(this.unitNameTextField);
        this.unitNameLabel.setText(NbBundle.getMessage(PersistenceUnitWizardPanelJdbc.class, (String)"LBL_UnitName"));
        this.unitNameTextField.setColumns(40);
        this.unitNameTextField.setText("em");
        this.jLabel1.setText(NbBundle.getMessage(PersistenceUnitWizardPanelJdbc.class, (String)"LBL_SpecifyPersistenceProvider"));
        this.jLabel2.setText(NbBundle.getMessage(PersistenceUnitWizardPanelJdbc.class, (String)"LBL_TableGeneration"));
        this.tableCreationButtonGroup.add(this.ddlCreate);
        this.ddlCreate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_Create_mnem").charAt(0));
        this.ddlCreate.setSelected(true);
        this.ddlCreate.setText(NbBundle.getMessage(PersistenceUnitWizardPanelJdbc.class, (String)"LBL_Create"));
        this.ddlCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableCreationButtonGroup.add(this.ddlDropCreate);
        this.ddlDropCreate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_DropCreate_mnem").charAt(0));
        this.ddlDropCreate.setText(NbBundle.getMessage(PersistenceUnitWizardPanelJdbc.class, (String)"LBL_DropCreate"));
        this.ddlDropCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableCreationButtonGroup.add(this.ddlUnkown);
        this.ddlUnkown.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("CHB_None_mnem").charAt(0));
        this.ddlUnkown.setText(NbBundle.getMessage(PersistenceUnitWizardPanelJdbc.class, (String)"LBL_None"));
        this.ddlUnkown.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.libraryLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("MN_Library").charAt(0));
        this.libraryLabel.setLabelFor(this.libraryCombo);
        this.libraryLabel.setText(NbBundle.getMessage(PersistenceUnitWizardPanelJdbc.class, (String)"LBL_Library"));
        this.libraryCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PersistenceUnitWizardPanelJdbc.this.libraryComboItemStateChanged(itemEvent);
            }
        });
        this.libraryCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitWizardPanelJdbc.this.libraryComboActionPerformed(actionEvent);
            }
        });
        this.jdbcCombo.setRenderer(new JdbcListCellRenderer());
        this.jdbcLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("MN_JdbcConnection").charAt(0));
        this.jdbcLabel.setLabelFor(this.jdbcCombo);
        this.jdbcLabel.setText(NbBundle.getMessage(PersistenceUnitWizardPanelJdbc.class, (String)"LBL_JdbcConnection"));
        this.warnPanel.setLayout(new BorderLayout());
        this.errorMessage.setPreferredSize(new Dimension(0, 20));
        this.warnPanel.add((Component)this.errorMessage, "North");
        this.createPUWarningLabel.setText(" ");
        this.createPUWarningLabel.setPreferredSize(new Dimension(4, 20));
        this.warnPanel.add((Component)this.createPUWarningLabel, "Last");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.unitNameLabel).add((Component)this.libraryLabel).add((Component)this.jdbcLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.libraryCombo, 0, 372, Short.MAX_VALUE).add((Component)this.jdbcCombo, 0, 372, Short.MAX_VALUE).add((Component)this.unitNameTextField, -1, 372, Short.MAX_VALUE))).add((Component)this.jLabel1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.ddlCreate).addPreferredGap(0).add((Component)this.ddlDropCreate).addPreferredGap(0).add((Component)this.ddlUnkown)).add((Component)this.warnPanel, -1, 535, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.unitNameLabel).add((Component)this.unitNameTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.libraryLabel).add((Component)this.libraryCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jdbcLabel).add((Component)this.jdbcCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.ddlCreate).add((Component)this.ddlDropCreate).add((Component)this.ddlUnkown).add((Component)this.jLabel2)).addPreferredGap(0).add((Component)this.warnPanel, -1, -1, Short.MAX_VALUE).addContainerGap(112, Short.MAX_VALUE)));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle");
        this.unitNameLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_UnitName"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TableGeneration"));
        this.ddlCreate.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Create"));
        this.ddlDropCreate.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_DropCreate"));
        this.ddlUnkown.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_None"));
        this.libraryLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Library"));
        this.jdbcLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_JdbcConnection"));
    }

    private void libraryComboActionPerformed(ActionEvent actionEvent) {
        this.checkValidity();
    }

    private void libraryComboItemStateChanged(ItemEvent itemEvent) {
        this.updateWarning();
    }

    private static final class ShyLabel
    extends JLabel {
        private ShyLabel() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = 0;
            return dimension;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            dimension.width = 0;
            return dimension;
        }
    }

    private class ValidationListener
    implements DocumentListener {
        private ValidationListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            PersistenceUnitWizardPanelJdbc.this.checkValidity();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            PersistenceUnitWizardPanelJdbc.this.checkValidity();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            PersistenceUnitWizardPanelJdbc.this.checkValidity();
        }
    }
}

