/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.util.MetadataModelReadHelper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public class EntityClosure {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Set<Entity> availableEntityInstances = new HashSet<Entity>();
    private Set<String> availableEntities = new HashSet<String>();
    private Set<String> wantedEntities = new HashSet<String>();
    private Set<String> selectedEntities = new HashSet<String>();
    private Set<String> referencedEntities = new HashSet<String>();
    private boolean closureEnabled = true;
    private Project project;
    private final MetadataModelReadHelper<EntityMappingsMetadata, List<Entity>> readHelper;
    private final MetadataModel<EntityMappingsMetadata> model;

    public static EntityClosure create(EntityClassScope entityClassScope, Project project) {
        EntityClosure entityClosure = new EntityClosure(entityClassScope, project);
        entityClosure.initialize();
        return entityClosure;
    }

    public static ComboBoxModel getAsComboModel(EntityClosure entityClosure) {
        return new EntityClosureComboBoxModel(entityClosure);
    }

    private EntityClosure(EntityClassScope entityClassScope, Project project) {
        this.model = entityClassScope.getEntityMappingsModel(true);
        this.project = project;
        this.readHelper = MetadataModelReadHelper.create(this.model, new MetadataModelAction<EntityMappingsMetadata, List<Entity>>(){

            public List<Entity> run(EntityMappingsMetadata entityMappingsMetadata) {
                return Arrays.asList(entityMappingsMetadata.getRoot().getEntity());
            }
        });
    }

    private void initialize() {
        this.readHelper.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (EntityClosure.this.readHelper.getState() == MetadataModelReadHelper.State.FINISHED) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                EntityClosure.this.addAvaliableEntities(new HashSet<Entity>((Collection)EntityClosure.this.readHelper.getResult()));
                                EntityClosure.this.changeSupport.fireChange();
                            }
                            catch (ExecutionException executionException) {
                                Exceptions.printStackTrace((Throwable)executionException);
                            }
                        }
                    });
                }
            }
        });
        this.readHelper.start();
    }

    public void addAvaliableEntities(Set<Entity> set) {
        this.availableEntityInstances.addAll(set);
        for (Entity entity : set) {
            this.availableEntities.add(entity.getClass2());
        }
        this.availableEntities.removeAll(this.selectedEntities);
        this.changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public Set<String> getAvailableEntities() {
        return this.availableEntities;
    }

    public Set<Entity> getAvailableEntityInstances() {
        return this.availableEntityInstances;
    }

    public Set<String> getWantedEntities() {
        return this.wantedEntities;
    }

    public Set<String> getSelectedEntities() {
        return this.selectedEntities;
    }

    public void addEntities(Set<String> set) {
        if (this.isClosureEnabled()) {
            if (this.wantedEntities.addAll(set)) {
                try {
                    Set<String> set2 = this.getReferencedEntitiesTransitively(set);
                    HashSet<String> hashSet = new HashSet<String>(set);
                    hashSet.addAll(set2);
                    this.selectedEntities.addAll(hashSet);
                    this.referencedEntities.addAll(set2);
                    this.availableEntities.removeAll(hashSet);
                    this.changeSupport.fireChange();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        } else {
            this.wantedEntities.addAll(set);
            this.selectedEntities.addAll(set);
            this.availableEntities.removeAll(set);
            this.changeSupport.fireChange();
        }
    }

    public void removeEntities(Set<String> set) {
        if (this.isClosureEnabled()) {
            if (this.wantedEntities.removeAll(set)) {
                this.redoClosure();
                this.changeSupport.fireChange();
            }
        } else {
            this.wantedEntities.removeAll(set);
            this.selectedEntities.removeAll(set);
            this.availableEntities.addAll(set);
            this.changeSupport.fireChange();
        }
    }

    public void addAllEntities() {
        this.wantedEntities.addAll(this.availableEntities);
        if (this.isClosureEnabled()) {
            this.redoClosure();
            this.changeSupport.fireChange();
        } else {
            this.selectedEntities.addAll(this.wantedEntities);
            this.availableEntities.clear();
            this.changeSupport.fireChange();
        }
    }

    public void removeAllEntities() {
        this.availableEntities.addAll(this.selectedEntities);
        this.wantedEntities.clear();
        this.selectedEntities.clear();
        this.referencedEntities.clear();
        this.changeSupport.fireChange();
    }

    private Set<String> getReferencedEntitiesTransitively(Set<String> set) throws IOException {
        Queue<String> queue = new Queue<String>(set);
        HashSet<String> hashSet = new HashSet<String>();
        while (!queue.isEmpty()) {
            String string = queue.poll();
            Set<String> set2 = this.getReferencedEntities(string);
            for (String string2 : set2) {
                if (!string2.equals(string)) {
                    hashSet.add(string2);
                }
                queue.offer(string2);
            }
        }
        return hashSet;
    }

    private Set<String> getReferencedEntities(final String string) throws IOException {
        if (this.readHelper.getState() != MetadataModelReadHelper.State.FINISHED) {
            return Collections.emptySet();
        }
        JavaSource javaSource = (JavaSource)this.model.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, JavaSource>(){

            public JavaSource run(EntityMappingsMetadata entityMappingsMetadata) throws Exception {
                return entityMappingsMetadata.createJavaSource();
            }
        });
        final HashSet<String> hashSet = new HashSet<String>();
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws Exception {
                TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                for (Element element : typeElement.getEnclosedElements()) {
                    if (!ElementKind.METHOD.equals((Object)element.getKind()) && !ElementKind.FIELD.equals((Object)element.getKind())) continue;
                    String string2 = ((Object)element.asType()).toString();
                    if (!((List)EntityClosure.this.readHelper.getResult()).contains(string2)) continue;
                    hashSet.add(string2);
                }
            }
        }, true);
        return hashSet;
    }

    private void redoClosure() {
        HashSet<String> hashSet = new HashSet<String>(this.availableEntities);
        hashSet.addAll(this.selectedEntities);
        this.referencedEntities.clear();
        try {
            this.referencedEntities.addAll(this.getReferencedEntitiesTransitively(this.wantedEntities));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.selectedEntities.clear();
        this.selectedEntities.addAll(this.wantedEntities);
        this.selectedEntities.addAll(this.referencedEntities);
        this.availableEntities.clear();
        this.availableEntities.addAll(hashSet);
        this.availableEntities.removeAll(this.selectedEntities);
    }

    public boolean isClosureEnabled() {
        return this.closureEnabled;
    }

    public void setClosureEnabled(boolean bl) {
        if (this.closureEnabled == bl) {
            return;
        }
        this.closureEnabled = bl;
        if (bl) {
            this.redoClosure();
        } else {
            HashSet<String> hashSet = new HashSet<String>(this.availableEntities);
            hashSet.addAll(this.selectedEntities);
            this.referencedEntities.clear();
            this.selectedEntities.clear();
            this.selectedEntities.addAll(this.wantedEntities);
            this.availableEntities.clear();
            this.availableEntities.addAll(hashSet);
            this.availableEntities.removeAll(this.selectedEntities);
        }
        this.changeSupport.fireChange();
    }

    public boolean isModelReady() {
        return true;
    }

    void waitModelIsReady() {
        try {
            Future future = this.model.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Boolean>(){

                public Boolean run(EntityMappingsMetadata entityMappingsMetadata) throws Exception {
                    return true;
                }
            });
            future.get();
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException);
        }
        catch (MetadataModelException metadataModelException) {
            Exceptions.printStackTrace((Throwable)metadataModelException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private boolean isFieldAccess(final String string) throws MetadataModelException, IOException {
        Boolean bl = (Boolean)this.model.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Boolean>(){

            public Boolean run(EntityMappingsMetadata entityMappingsMetadata) throws Exception {
                for (Entity entity : entityMappingsMetadata.getRoot().getEntity()) {
                    if (!entity.getClass2().equals(string)) continue;
                    return entity.getAccess().equals("FIELD");
                }
                return false;
            }
        });
        return bl;
    }

    private static class EntityClosureComboBoxModel
    extends DefaultComboBoxModel
    implements ChangeListener {
        private EntityClosure entityClosure;
        private List<String> entities = new ArrayList<String>();

        EntityClosureComboBoxModel(EntityClosure entityClosure) {
            this.entityClosure = entityClosure;
            entityClosure.addChangeListener(this);
            this.refresh();
        }

        @Override
        public int getSize() {
            return this.entities.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.entities.get(n);
        }

        public List<String> getEntityClasses() {
            return this.entities;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.refresh();
        }

        private void refresh() {
            int n = this.getSize();
            this.entities = new ArrayList<String>(this.entityClosure.getAvailableEntities());
            Collections.sort(this.entities);
            this.fireContentsChanged(this, 0, Math.max(n, this.getSize()));
        }
    }

    static final class Queue<T> {
        private final List<T> queue;
        private final Set<T> contents;
        private int currentIndex;

        public Queue(Set<T> set) {
            assert (!set.contains(null));
            this.queue = new ArrayList<T>(set);
            this.contents = new HashSet<T>(set);
        }

        public void offer(T t) {
            assert (t != null);
            if (!this.contents.contains(t)) {
                this.contents.add(t);
                this.queue.add(t);
            }
        }

        public boolean isEmpty() {
            return this.currentIndex >= this.queue.size();
        }

        public T poll() {
            T t = null;
            if (!this.isEmpty()) {
                t = this.queue.get(this.currentIndex);
                ++this.currentIndex;
            }
            return t;
        }
    }
}

