/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.netbeans.modules.web.monitor.client.ParamEditor;
import org.openide.util.NbBundle;

public class NameValueCellEditor
extends DefaultCellEditor {
    private static final boolean debug = false;
    private static String editNameAndValueTitle;
    private static String editValueOnlyTitle;
    private JTable table;
    private Object[][] data;
    private boolean nameEditable;
    private int row;
    private int type;

    public static NameValueCellEditor createCellEditor(JTable table, Object[][] data, boolean nameEditable, int row, int type) {
        JButton b = new JButton(NbBundle.getMessage((Class)NameValueCellEditor.class, (String)"MON_Edit_dots"));
        if (type == 0) {
            b.setToolTipText(NbBundle.getMessage((Class)NameValueCellEditor.class, (String)"MON_DisplayValue"));
        } else {
            b.setToolTipText(NbBundle.getMessage((Class)NameValueCellEditor.class, (String)"MON_EditAttribute"));
        }
        final NameValueCellEditor ed = new NameValueCellEditor(b, table, data, nameEditable, row, type);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ed.showParamEditor();
            }
        });
        return ed;
    }

    public NameValueCellEditor(JButton b, JTable table, Object[][] data, boolean nameEditable, int row, int type) {
        super(new JCheckBox());
        this.editorComponent = b;
        this.setClickCountToStart(1);
        this.table = table;
        this.data = data;
        this.nameEditable = nameEditable;
        this.row = row;
        this.type = type;
    }

    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    public Object getCellEditorValue() {
        return NbBundle.getMessage((Class)NameValueCellEditor.class, (String)"MON_Edit_dots");
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ((JButton)this.editorComponent).setText(value.toString());
        return this.editorComponent;
    }

    public void showParamEditor() {
        int currentRow = this.table.getSelectedRow();
        TableModel model = this.table.getModel();
        String name = (String)model.getValueAt(currentRow, 0);
        String value = (String)model.getValueAt(currentRow, 1);
        ParamEditor.Condition condition = ParamEditor.Condition.NONE;
        ParamEditor.Editable editable = ParamEditor.Editable.BOTH;
        String title = null;
        if (this.type == 0) {
            editable = ParamEditor.Editable.NEITHER;
            title = NbBundle.getMessage((Class)NameValueCellEditor.class, (String)"MON_ParamValue");
        } else if (this.type == 3) {
            title = NbBundle.getMessage((Class)NameValueCellEditor.class, (String)"MON_Edit_header");
            condition = ParamEditor.Condition.HEADER;
        } else if (this.type == 4) {
            title = NbBundle.getMessage((Class)NameValueCellEditor.class, (String)"MON_Edit_param");
        } else if (this.type == 1) {
            editable = ParamEditor.Editable.VALUE;
            title = NbBundle.getMessage((Class)NameValueCellEditor.class, (String)"MON_Edit_request");
            condition = ParamEditor.Condition.VALUE;
        } else if (this.type == 5) {
            title = NbBundle.getMessage((Class)NameValueCellEditor.class, (String)"MON_Edit_cookie");
            condition = ParamEditor.Condition.COOKIE;
        } else if (this.type == 2) {
            title = NbBundle.getMessage((Class)NameValueCellEditor.class, (String)"MON_Edit_server");
            condition = ParamEditor.Condition.VALUE;
            editable = ParamEditor.Editable.VALUE;
        } else {
            title = NbBundle.getMessage((Class)NameValueCellEditor.class, (String)"MON_Edit_value");
        }
        ParamEditor pe = new ParamEditor(name, value, editable, condition, title);
        pe.showDialog();
        if (this.type > 0 && pe.getDialogOK()) {
            if (this.nameEditable) {
                model.setValueAt(pe.getName(), currentRow, 0);
            }
            model.setValueAt(pe.getValue(), currentRow, 1);
        }
    }
}

