/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.platform.installer;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.javacard.ri.platform.installer.PlatformInfo;
import org.netbeans.modules.javacard.ri.platform.installer.PlatformValidator;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PlatformPanel
extends JPanel
implements FocusListener,
DocumentListener {
    private final ChangeSupport supp = new ChangeSupport((Object)this);
    private final PlatformValidator validator;
    private FileObject baseDir;
    private JTextField displayNameField;
    private JLabel displayNameLabel;
    private JTextArea infoField;
    private JScrollPane infoPane;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JProgressBar jProgressBar1;
    private JTextField locationField;
    private JLabel problemLbl;
    private JLabel versionLabel;
    volatile boolean failed;
    PlatformInfo platformInfo;

    public PlatformPanel(FileObject fo) {
        this.baseDir = fo;
        this.validator = new PlatformValidatorImpl(fo);
        this.initComponents();
        this.displayNameField.addFocusListener(this);
        this.infoField.addFocusListener(this);
        this.displayNameField.setEnabled(false);
        this.displayNameField.getDocument().addDocumentListener(this);
        this.locationField.setText(this.baseDir == null ? "" : this.baseDir.getPath());
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.SettingUpJavaCardPlatform");
        this.infoField.getCaret().setVisible(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.baseDir != null) {
            if (!this.validator.hasRun()) {
                this.validatePlatform();
            }
        } else {
            this.enableControls(false);
            this.setProblem(NbBundle.getMessage(PlatformPanel.class, (String)"MSG_NO_EMULATOR", (Object)this.baseDir.toString()));
        }
    }

    public void removeChangeListener(ChangeListener arg0) {
        this.supp.removeChangeListener(arg0);
    }

    public void fireChange() {
        this.supp.fireChange();
    }

    public void addChangeListener(ChangeListener arg0) {
        this.supp.addChangeListener(arg0);
    }

    boolean isProblem() {
        return this.problemLbl.getText().trim().length() > 0;
    }

    void setDisplayName(String nm) {
        this.displayNameField.setText(nm);
    }

    void setProblem(String txt) {
        boolean wasProblem = this.isProblem();
        txt = txt == null ? "" : txt;
        this.problemLbl.setText(txt);
        if (wasProblem != this.isProblem()) {
            this.fireChange();
        }
    }

    void enableControls(boolean val) {
        for (Component c : this.getComponents()) {
            if (c == this.jProgressBar1 || c == this.infoField || c == this.problemLbl) continue;
            c.setEnabled(val);
        }
        this.change();
    }

    private void change() {
        String key = null;
        String name = this.displayNameField.getText().trim();
        if (this.validator.failed()) {
            String msg = this.validator.failMessage();
            if (msg != null) {
                this.setProblem(msg);
                return;
            }
            key = "MSG_BAD_PLATFORM";
        } else if (this.validator.isRunning()) {
            key = "MSG_LOADING";
        } else if (name.length() == 0) {
            key = "MSG_NO_NAME";
        } else if (name.contains("/") || name.contains("\\") || name.contains(":") || name.contains(";") || name.contains(File.separator) || name.contains(File.pathSeparator)) {
            key = "MSG_NO_SLASHES";
        } else if (this.platformFileExists(name)) {
            key = "MSG_PLATFORM_EXISTS";
        }
        String path = this.baseDir == null ? "" : this.baseDir.getPath();
        String msg = key == null ? null : NbBundle.getMessage(PlatformPanel.class, (String)key, (Object)path);
        this.setProblem(msg);
    }

    private boolean platformFileExists(String name) {
        String nm = name.replace(' ', '_') + "." + "jcplatform";
        FileObject platformsFolder = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
        FileObject platformFile = platformsFolder.getFileObject(nm);
        return nm != null && platformFile != null;
    }

    private void initComponents() {
        this.displayNameLabel = new JLabel();
        this.displayNameField = new JTextField();
        this.versionLabel = new JLabel();
        this.infoPane = new JScrollPane();
        this.infoField = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.problemLbl = new JLabel();
        this.jLabel1 = new JLabel();
        this.locationField = new JTextField();
        this.displayNameLabel.setDisplayedMnemonic('D');
        this.displayNameLabel.setLabelFor(this.displayNameField);
        this.displayNameLabel.setText(NbBundle.getMessage(PlatformPanel.class, (String)"PlatformPanel.displayNameLabel.text"));
        this.displayNameField.setText(NbBundle.getMessage(PlatformPanel.class, (String)"PlatformPanel.displayNameField.text"));
        this.displayNameField.setToolTipText(NbBundle.getMessage(PlatformPanel.class, (String)"PlatformPanel.displayNameField.toolTipText"));
        this.versionLabel.setDisplayedMnemonic('V');
        this.versionLabel.setLabelFor(this.infoField);
        this.versionLabel.setText(NbBundle.getMessage(PlatformPanel.class, (String)"PlatformPanel.versionLabel.text"));
        this.infoField.setBackground(UIManager.getDefaults().getColor("control"));
        this.infoField.setColumns(20);
        this.infoField.setEditable(false);
        this.infoField.setLineWrap(true);
        this.infoField.setRows(5);
        this.infoField.setWrapStyleWord(true);
        this.infoPane.setViewportView(this.infoField);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jProgressBar1.setIndeterminate(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 80;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jProgressBar1, gridBagConstraints);
        this.problemLbl.setForeground(UIManager.getDefaults().getColor("nb.errorForeground"));
        this.problemLbl.setText(NbBundle.getMessage(PlatformPanel.class, (String)"PlatformPanel.problemLbl.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 180;
        gridBagConstraints.ipady = 18;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.problemLbl, gridBagConstraints);
        this.jLabel1.setDisplayedMnemonic('L');
        this.jLabel1.setLabelFor(this.locationField);
        this.jLabel1.setText(NbBundle.getMessage(PlatformPanel.class, (String)"PlatformPanel.jLabel1.text"));
        this.locationField.setEditable(false);
        this.locationField.setText(NbBundle.getMessage(PlatformPanel.class, (String)"PlatformPanel.locationField.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.infoPane, -1, 461, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, 461, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.displayNameLabel).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.locationField, -1, 393, Short.MAX_VALUE).add((Component)this.displayNameField, -1, 393, Short.MAX_VALUE))).add(1, (Component)this.versionLabel)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.displayNameLabel).add((Component)this.displayNameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.locationField, -2, -1, -2)).addPreferredGap(1).add((Component)this.versionLabel).addPreferredGap(0).add((Component)this.infoPane, -1, 164, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addContainerGap()));
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getComponent() instanceof JTextComponent) {
            ((JTextComponent)e.getComponent()).selectAll();
        }
    }

    public String getDisplayName() {
        return this.displayNameField.getText();
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.displayNameField == e.getOppositeComponent()) {
            this.change();
        }
    }

    private void validatePlatform() {
        if (!this.validator.hasRun()) {
            this.jProgressBar1.setVisible(true);
            this.jProgressBar1.setIndeterminate(true);
            this.enableControls(false);
            this.validator.start();
            this.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.change();
        this.firePropertyChange("displayName", null, this.getDisplayName());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    PlatformInfo getPlatformInfo() {
        return this.platformInfo;
    }

    PlatformInfo getPlatformInfo(String out, EditableProperties props) {
        return new PlatformInfo(props);
    }

    private final class PlatformValidatorImpl
    extends PlatformValidator {
        PlatformValidatorImpl(FileObject baseDir) {
            super(baseDir);
        }

        @Override
        void onStart() {
            PlatformPanel.this.jProgressBar1.setVisible(true);
            PlatformPanel.this.jProgressBar1.setIndeterminate(true);
            PlatformPanel.this.enableControls(false);
            PlatformPanel.this.setProblem(NbBundle.getMessage(PlatformValidatorImpl.class, (String)"MSG_VALIDATING"));
            PlatformPanel.this.invalidate();
            PlatformPanel.this.revalidate();
            PlatformPanel.this.repaint();
        }

        @Override
        void onFail(Exception e) {
            assert (EventQueue.isDispatchThread());
            PlatformPanel.this.infoField.setText(this.getStandardOutput() + "\n" + this.getErrorOutput());
            PlatformPanel.this.setProblem(e.getMessage());
            this.failMessage = e.getLocalizedMessage();
            e.printStackTrace();
        }

        @Override
        void onSucceed(String stdout) {
            assert (!EventQueue.isDispatchThread());
            PlatformPanel.this.platformInfo = PlatformPanel.this.getPlatformInfo(stdout, this.getPlatformProps());
            PlatformPanel.this.fireChange();
        }

        @Override
        void onDone() {
            assert (EventQueue.isDispatchThread());
            PlatformPanel.this.enableControls(true);
            if (PlatformPanel.this.platformInfo != null) {
                PlatformPanel.this.displayNameField.setText(PlatformPanel.this.platformInfo.getName());
            }
            PlatformPanel.this.infoField.setText(this.getStandardOutput());
            PlatformPanel.this.jProgressBar1.setIndeterminate(false);
            PlatformPanel.this.jProgressBar1.setVisible(false);
            PlatformPanel.this.invalidate();
            PlatformPanel.this.revalidate();
            PlatformPanel.this.repaint();
            PlatformPanel.this.change();
        }
    }
}

