/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.elements;

import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.support.ElementGrip;
import org.netbeans.modules.cnd.refactoring.support.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class CsmRefactoringElementImpl
extends SimpleRefactoringElementImplementation {
    private final CsmReference elem;
    private final PositionBounds bounds;
    private final FileObject fo;
    private final String displayText;
    private final Object enclosing;

    public CsmRefactoringElementImpl(PositionBounds bounds, CsmReference elem, FileObject fo, String displayText) {
        this.elem = elem;
        this.bounds = bounds;
        this.fo = fo;
        assert (displayText != null);
        this.displayText = displayText;
        ElementGrip composite = ElementGripFactory.getDefault().putInComposite(fo, (CsmOffsetable)elem);
        if (composite == null) {
            composite = fo;
        }
        this.enclosing = composite;
    }

    public String getText() {
        return ((Object)this.elem.getText()).toString();
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this.elem, this.enclosing});
    }

    public FileObject getParentFile() {
        return this.fo;
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public static RefactoringElementImplementation create(CsmReference ref, boolean nameInBold) {
        CsmFile csmFile = ref.getContainingFile();
        FileObject fo = CsmUtilities.getFileObject((CsmFile)csmFile);
        PositionBounds bounds = CsmUtilities.createPositionBounds((CsmOffsetable)ref);
        String displayText = ((Object)CsmReferenceSupport.getContextLineHtml((CsmReference)ref, (boolean)nameInBold)).toString();
        return new CsmRefactoringElementImpl(bounds, ref, fo, displayText);
    }
}

