/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;

abstract class DeployData {
    private static final Logger LOG = Logger.getLogger(DeployData.class.getName());
    WebApp webApp = null;
    String className = null;
    boolean makeEntry = true;
    FileObject ddObject = null;

    DeployData() {
    }

    void setWebApp(FileObject fileObject) {
        LOG.finer("setWebApp()");
        this.ddObject = fileObject;
        if (fileObject == null) {
            this.webApp = null;
            return;
        }
        try {
            this.webApp = DDProvider.getDefault().getDDRoot(fileObject);
            LOG.finer("webApp = " + this.webApp);
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, "Couldn't get the web app!", iOException);
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "Couldn't get the web app!", exception);
        }
    }

    String getClassName() {
        if (this.className == null) {
            return "";
        }
        return this.className;
    }

    void setClassName(String string) {
        this.className = string;
    }

    boolean makeEntry() {
        return this.makeEntry;
    }

    void setMakeEntry(boolean bl) {
        this.makeEntry = bl;
    }

    void writeChanges() throws IOException {
        LOG.finer("writeChanges()");
        if (this.webApp == null) {
            return;
        }
        LOG.finer("now writing...");
        this.webApp.write(this.ddObject);
    }

    abstract boolean isValid();

    abstract void createDDEntries();

    abstract String getErrorMessage();

    public static FileObject getWebAppFor(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule == null) {
            return null;
        }
        return webModule.getDeploymentDescriptor();
    }

    public boolean hasDD() {
        return this.webApp != null;
    }
}

