/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspcompiler;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public final class JspAntLogger
extends AntLogger {
    private static final Pattern JSP_COMPILER_ERROR = Pattern.compile("(.*)(org.apache.jasper.JasperException: file:)(.*)");
    private static final Pattern FILE_PATTERN = Pattern.compile("([^\\(]*)\\(([0-9]+),([0-9]+)\\)");
    private static final String[] TASKS_OF_INTEREST = AntLogger.ALL_TASKS;
    private static final int[] LEVELS_OF_INTEREST = new int[]{2, 1, 0};
    private static final Logger ERR = Logger.getLogger(JspAntLogger.class.getName());
    private static final boolean LOGGABLE = ERR.isLoggable(Level.FINE);

    public boolean interestedInSession(AntSession antSession) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession antSession) {
        return true;
    }

    public String[] interestedInTargets(AntSession antSession) {
        return AntLogger.ALL_TARGETS;
    }

    public boolean interestedInScript(File file, AntSession antSession) {
        return true;
    }

    public String[] interestedInTasks(AntSession antSession) {
        return TASKS_OF_INTEREST;
    }

    public int[] interestedInLogLevels(AntSession antSession) {
        return LEVELS_OF_INTEREST;
    }

    public void messageLogged(AntEvent antEvent) {
        AntSession antSession = antEvent.getSession();
        int n = antEvent.getLogLevel();
        int n2 = antSession.getVerbosity();
        String string = antEvent.getMessage();
        assert (string != null);
        Matcher matcher = JSP_COMPILER_ERROR.matcher(string);
        if (matcher.matches()) {
            if (LOGGABLE) {
                ERR.log(Level.FINE, "matched line: " + string);
            }
            String string2 = string.substring(string.lastIndexOf(41) + 1);
            antSession.println(string.substring(0, string.indexOf("file:")) + string2, true, null);
            String string3 = string.substring(string.indexOf("file"), string.lastIndexOf(41) + 1);
            if (LOGGABLE) {
                ERR.log(Level.FINE, "file part: " + string3);
            }
            int n3 = 0;
            while (string3.indexOf("file:", n3) > -1) {
                File file;
                FileObject fileObject;
                FileObject fileObject2;
                Matcher matcher2;
                int n4;
                int n5 = string3.indexOf("file:", n3) + 5;
                n3 = n4 = string3.indexOf(41, n3) + 1;
                String string4 = string3.substring(n5, n4);
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "file: " + string4);
                }
                if (!(matcher2 = FILE_PATTERN.matcher(string4)).matches()) continue;
                String string5 = matcher2.group(1).trim();
                int n6 = Integer.parseInt(matcher2.group(2));
                int n7 = Integer.parseInt(matcher2.group(3)) + 1;
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "linking line: " + n6 + ", column: " + n7);
                }
                if ((fileObject2 = JspAntLogger.getResourceInSources(fileObject = FileUtil.toFileObject((File)(file = new File(string5))))) == null || n > n2 || antEvent.isConsumed()) continue;
                try {
                    antSession.println(string4, true, antSession.createStandardHyperlink(fileObject2.getURL(), string2, n6, n7, -1, -1));
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    assert (false) : fileStateInvalidException;
                }
            }
            antEvent.consume();
        }
    }

    private static FileObject getResourceInSources(FileObject fileObject) {
        FileObject fileObject2;
        if (fileObject == null) {
            return null;
        }
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule != null && (fileObject2 = JspAntLogger.guessWebModuleOutputRoot(webModule, fileObject)) != null) {
            String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
            return webModule.getDocumentBase().getFileObject(string);
        }
        return null;
    }

    private static FileObject guessWebModuleOutputRoot(WebModule webModule, FileObject fileObject) {
        for (FileObject fileObject2 = fileObject.getParent(); fileObject2 != null; fileObject2 = fileObject2.getParent()) {
            if (fileObject2.getFileObject("WEB-INF") == null) continue;
            return fileObject2;
        }
        return null;
    }
}

