/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.HashMap;
import java.util.List;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.SyntaxElement;

public class SyntaxParserContext
implements Cloneable {
    private CharSequence sourceText;
    private HashMap<String, Object> properties;
    private List<SyntaxElement> elements;
    private DTD dtd;

    public static SyntaxParserContext createContext(CharSequence sourceText) {
        return new SyntaxParserContext(sourceText);
    }

    private SyntaxParserContext(CharSequence sourceText) {
        this.sourceText = sourceText;
    }

    public synchronized SyntaxParserContext setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
        return this;
    }

    public synchronized Object getProperty(String name) {
        return this.properties.get(name);
    }

    public synchronized String getPropertyAsString(String name) {
        if (this.properties == null) {
            return null;
        }
        Object val = this.properties.get(name);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public synchronized boolean isPropertyEnabled(String name) {
        return Boolean.parseBoolean(this.getPropertyAsString(name));
    }

    protected SyntaxParserContext clone() {
        SyntaxParserContext neww = SyntaxParserContext.createContext(this.sourceText);
        neww.properties = this.properties == null ? null : (HashMap)this.properties.clone();
        neww.dtd = this.dtd;
        neww.elements = this.elements;
        return neww;
    }

    public CharSequence getSourceText() {
        return this.sourceText;
    }

    public SyntaxParserContext setDTD(DTD dtd) {
        this.dtd = dtd;
        return this;
    }

    public DTD getDTD() {
        return this.dtd;
    }

    List<SyntaxElement> getElements() {
        return this.elements;
    }

    SyntaxParserContext setElements(List<SyntaxElement> elements) {
        this.elements = elements;
        return this;
    }
}

