/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import org.netbeans.modules.vmd.midpnb.screen.display.TextRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;

class SVGListCellRenderer
extends TextRenderer {
    private float myX;
    private float myY;
    private float myHeight;
    private float myTextWidth = -1.0f;
    Document myDocument;
    SVGLocatableElement myBounds;
    SVGLocatableElement myContent;

    SVGListCellRenderer(Document document, float height, SVGLocatableElement hiddenText, SVGLocatableElement bounds, SVGLocatableElement content) {
        super(hiddenText);
        this.myDocument = document;
        this.myHeight = height;
        this.myBounds = bounds;
        this.myContent = content;
        this.initEmpiricalLetterWidth(hiddenText);
    }

    public void clearContent() {
        Element node = this.getContentElement().getFirstElementChild();
        while (node != null) {
            String display;
            Element next = null;
            if (node instanceof SVGElement) {
                next = ((SVGElement)node).getNextElementSibling();
            }
            if (!"text".equals(node.getLocalName())) {
                this.getContentElement().removeChild((Node)node);
            } else if (node instanceof SVGElement && !"none".equals(display = ((SVGElement)node).getTrait("display"))) {
                Element forRemove = node;
                this.getContentElement().removeChild((Node)forRemove);
            }
            node = next;
        }
    }

    public SVGLocatableElement getCellRendererComponent(Object value, int index) {
        SVGLocatableElement hiddenText = this.getHiddenTextElement();
        if (hiddenText == null) {
            throw new IllegalArgumentException("List argument doesn't contain hidden text for access to fontcharacteristics. Unable render any value.");
        }
        this.myX = hiddenText.getFloatTrait("x");
        this.myY = hiddenText.getFloatTrait("y");
        if (this.getBoundsElement().getBBox() != null && hiddenText.getBBox() != null && this.myTextWidth == -1.0f) {
            this.myTextWidth = this.getBoundsElement().getBBox().getWidth() + 0.5f - (hiddenText.getBBox().getX() - this.getBoundsElement().getBBox().getX()) * 2.0f;
        }
        SVGLocatableElement textElement = (SVGLocatableElement)this.myDocument.createElementNS("http://www.w3.org/2000/svg", "text");
        textElement.setFloatTrait("x", this.myX);
        textElement.setFloatTrait("y", this.myY + (float)index * this.myHeight);
        textElement.setFloatTrait("font-size", hiddenText.getFloatTrait("font-size"));
        textElement.setTrait("font-family", hiddenText.getTrait("font-family"));
        textElement.setTrait("visibility", "inherit");
        if (value == null) {
            textElement.setTrait("#text", "");
        } else if (this.myTextWidth == -1.0f) {
            textElement.setTrait("#text", value.toString());
        } else {
            String text = this.truncateToShownText(value.toString(), this.myTextWidth);
            textElement.setTrait("#text", text);
        }
        this.getContentElement().appendChild((Node)textElement);
        return textElement;
    }

    SVGLocatableElement getBoundsElement() {
        return this.myBounds;
    }

    SVGLocatableElement getContentElement() {
        return this.myContent;
    }
}

