/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.List;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.DirectedGraph;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.LayeredGraph;

public class BarycenterXCoordinateAssigner {
    public LayeredGraph assignCoordinates(LayeredGraph graph) {
        List<List<DirectedGraph.Vertex>> layers = graph.getLayers();
        int size = layers.size();
        int maxIteration = 1;
        for (int iteration = 0; iteration < maxIteration; ++iteration) {
            int i;
            for (i = 0; i < size - 1; ++i) {
                float[] lowerBarycenters = graph.computeLowerBarycenters(i);
                List<DirectedGraph.Vertex> lowerLayer = graph.getLayer(i + 1);
                int[] upPriorities = this.computeUpPriorities(lowerLayer);
                this.moveVertices(lowerLayer, lowerBarycenters, upPriorities);
            }
            for (i = size - 2; i >= 0; --i) {
                float[] upperBarycenters = graph.computeUpperBarycenters(i);
                List<DirectedGraph.Vertex> upperLayer = graph.getLayer(i);
                int[] downPriorities = this.computeDownPriorities(upperLayer);
                this.moveVertices(upperLayer, upperBarycenters, downPriorities);
            }
        }
        return graph;
    }

    private void moveVertices(List<DirectedGraph.Vertex> layer, float[] barycenters, int[] priorities) {
        int size = layer.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                DirectedGraph.Vertex kv;
                float khd;
                DirectedGraph.Vertex jv = layer.get(j);
                int jp = priorities[j];
                float jbc = barycenters[j];
                float jhd = jv.getX();
                if (!(jhd < jbc)) continue;
                int hpIndex = -1;
                for (int k = j + 1; k < size; ++k) {
                    DirectedGraph.Vertex kv2 = layer.get(k);
                    if (priorities[k] < jp) continue;
                    hpIndex = k;
                    break;
                }
                float nhd = jbc;
                float lastIndex = size;
                if (hpIndex != -1) {
                    lastIndex = hpIndex;
                    DirectedGraph.Vertex hv = layer.get(hpIndex);
                    float hhd = hv.getX();
                    float spacing = (hhd - jhd) / (float)(hpIndex - j);
                    if (!(spacing > 1.0f)) continue;
                    nhd = jhd + (spacing - 1.0f);
                    if (nhd > jbc) {
                        nhd = jbc;
                    }
                }
                if (nhd <= jhd) continue;
                jv.setX((int)nhd);
                float chd = nhd;
                int k = j + 1;
                while ((float)k < lastIndex && (khd = (float)(kv = layer.get(k)).getX()) <= chd + 1.0f) {
                    kv.setX((int)(chd += 1.0f));
                    ++k;
                }
            }
        }
    }

    private int[] computeUpPriorities(List<DirectedGraph.Vertex> layer) {
        DirectedGraph.Vertex v;
        int i;
        int size = layer.size();
        int[] upPriorities = new int[size];
        int maxUpPriority = -1;
        for (i = 0; i < size; ++i) {
            int upPriority;
            v = layer.get(i);
            if (v instanceof DirectedGraph.DummyVertex) continue;
            upPriorities[i] = upPriority = v.getUpperNeighbors().size();
            if (upPriority <= maxUpPriority) continue;
            maxUpPriority = upPriority;
        }
        ++maxUpPriority;
        for (i = 0; i < size; ++i) {
            v = layer.get(i);
            if (!(v instanceof DirectedGraph.DummyVertex)) continue;
            upPriorities[i] = maxUpPriority;
        }
        return upPriorities;
    }

    private int[] computeDownPriorities(List<DirectedGraph.Vertex> layer) {
        DirectedGraph.Vertex v;
        int i;
        int size = layer.size();
        int[] downPriorities = new int[size];
        int maxDownPriority = -1;
        for (i = 0; i < size; ++i) {
            int downPriority;
            v = layer.get(i);
            if (v instanceof DirectedGraph.DummyVertex) continue;
            downPriorities[i] = downPriority = v.getLowerNeighbors().size();
            if (downPriority <= maxDownPriority) continue;
            maxDownPriority = downPriority;
        }
        ++maxDownPriority;
        for (i = 0; i < size; ++i) {
            v = layer.get(i);
            if (!(v instanceof DirectedGraph.DummyVertex)) continue;
            downPriorities[i] = maxDownPriority;
        }
        return downPriorities;
    }
}

