/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.common.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.dd.api.common.EnvEntry;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.PortComponentRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceEnvRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.EnvEntryImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.MessageDestinationRefImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.ResourceEnvRefImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.ResourceImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.ResourceRefImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.SecurityRoleImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.ServiceRefImpl;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationScanner;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;

public class CommonAnnotationHelper {
    private static final Set<String> RESOURCE_REF_TYPES = new HashSet<String>(Arrays.asList("javax.sql.DataSource", "javax.jms.ConnectionFactory", "javax.jms.QueueConnectionFactory", "javax.jms.TopicConnectionFactory", "javax.mail.Session", "java.net.URL", "javax.resource.cci.ConnectionFactory", "org.omg.CORBA_2_3.ORB"));
    private static final Set<String> ENV_ENTRY_TYPES = new HashSet<String>(Arrays.asList("java.lang.String", "java.lang.Character", "java.lang.Integer", "java.lang.Boolean", "java.lang.Double", "java.lang.Byte", "java.lang.Short", "java.lang.Long", "java.lang.Float"));
    private static final Set<String> SERVICE_REF_TYPES = new HashSet<String>(Arrays.asList("javax.xml.rpc.Service", "javax.xml.ws.Service", "javax.jws.WebService"));
    private static final Set<String> MESSAGE_DESTINATION_TYPES = new HashSet<String>(Arrays.asList("javax.jms.Queue", "javax.jms.Topic"));

    private CommonAnnotationHelper() {
    }

    public static SecurityRole[] getSecurityRoles(AnnotationModelHelper annotationModelHelper) {
        final ArrayList arrayList = new ArrayList();
        final AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)annotationModelHelper);
        annotationParser.expectStringArray("value", new ArrayValueHandler(){

            public Object handleArray(List<AnnotationValue> list) {
                for (AnnotationValue annotationValue : list) {
                    String string = (String)annotationValue.getValue();
                    arrayList.add(new SecurityRoleImpl(string));
                }
                return null;
            }
        }, null);
        try {
            annotationModelHelper.getAnnotationScanner().findAnnotations("javax.annotation.security.DeclareRoles", AnnotationScanner.TYPE_KINDS, new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotationMirror) {
                    annotationParser.parse(annotationMirror);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return new SecurityRole[0];
        }
        return arrayList.toArray(new SecurityRole[arrayList.size()]);
    }

    public static ResourceRef[] getResourceRefs(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
        assert (annotationModelHelper != null);
        assert (typeElement != null);
        List<ResourceImpl> list = CommonAnnotationHelper.getResources(annotationModelHelper, typeElement);
        return CommonAnnotationHelper.getResourceRefs(list);
    }

    public static ResourceRef[] getResourceRefs(AnnotationModelHelper annotationModelHelper) {
        assert (annotationModelHelper != null);
        List<ResourceImpl> list = CommonAnnotationHelper.getResources(annotationModelHelper);
        return CommonAnnotationHelper.getResourceRefs(list);
    }

    public static ResourceEnvRef[] getResourceEnvRefs(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
        assert (annotationModelHelper != null);
        assert (typeElement != null);
        List<ResourceImpl> list = CommonAnnotationHelper.getResources(annotationModelHelper, typeElement);
        return CommonAnnotationHelper.getResourceEnvRefs(list);
    }

    public static ResourceEnvRef[] getResourceEnvRefs(AnnotationModelHelper annotationModelHelper) {
        assert (annotationModelHelper != null);
        List<ResourceImpl> list = CommonAnnotationHelper.getResources(annotationModelHelper);
        return CommonAnnotationHelper.getResourceEnvRefs(list);
    }

    public static EnvEntry[] getEnvEntries(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
        assert (annotationModelHelper != null);
        assert (typeElement != null);
        List<ResourceImpl> list = CommonAnnotationHelper.getResources(annotationModelHelper, typeElement);
        return CommonAnnotationHelper.getEnvEntries(list);
    }

    public static EnvEntry[] getEnvEntries(AnnotationModelHelper annotationModelHelper) {
        assert (annotationModelHelper != null);
        List<ResourceImpl> list = CommonAnnotationHelper.getResources(annotationModelHelper);
        return CommonAnnotationHelper.getEnvEntries(list);
    }

    public static MessageDestinationRef[] getMessageDestinationRefs(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
        assert (annotationModelHelper != null);
        assert (typeElement != null);
        List<ResourceImpl> list = CommonAnnotationHelper.getResources(annotationModelHelper, typeElement);
        return CommonAnnotationHelper.getMessageDestinationRefs(list);
    }

    public static MessageDestinationRef[] getMessageDestinationRefs(AnnotationModelHelper annotationModelHelper) {
        assert (annotationModelHelper != null);
        List<ResourceImpl> list = CommonAnnotationHelper.getResources(annotationModelHelper);
        return CommonAnnotationHelper.getMessageDestinationRefs(list);
    }

    public static ServiceRef[] getServiceRefs(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
        assert (annotationModelHelper != null);
        assert (typeElement != null);
        List<ServiceRef> list = CommonAnnotationHelper.getWebServiceRefs(annotationModelHelper, typeElement);
        List<ResourceImpl> list2 = CommonAnnotationHelper.getResources(annotationModelHelper, typeElement);
        list.addAll(CommonAnnotationHelper.getServiceRefs(list2));
        return list.toArray(new ServiceRef[list.size()]);
    }

    public static ServiceRef[] getServiceRefs(AnnotationModelHelper annotationModelHelper) {
        assert (annotationModelHelper != null);
        List<ServiceRef> list = CommonAnnotationHelper.getWebServiceRefs(annotationModelHelper);
        List<ResourceImpl> list2 = CommonAnnotationHelper.getResources(annotationModelHelper);
        list.addAll(CommonAnnotationHelper.getServiceRefs(list2));
        return list.toArray(new ServiceRef[list.size()]);
    }

    private static List<ResourceImpl> getResources(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
        ResourceImpl resourceImpl;
        ArrayList<ResourceImpl> arrayList = new ArrayList<ResourceImpl>();
        for (VariableElement element : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!annotationModelHelper.hasAnnotation(element.getAnnotationMirrors(), "javax.annotation.Resource")) continue;
            resourceImpl = new ResourceImpl(element, typeElement, annotationModelHelper);
            arrayList.add(resourceImpl);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!annotationModelHelper.hasAnnotation(executableElement.getAnnotationMirrors(), "javax.annotation.Resource")) continue;
            resourceImpl = new ResourceImpl(executableElement, typeElement, annotationModelHelper);
            arrayList.add(resourceImpl);
        }
        return arrayList;
    }

    private static List<ResourceImpl> getResources(final AnnotationModelHelper annotationModelHelper) {
        final ArrayList<ResourceImpl> arrayList = new ArrayList<ResourceImpl>();
        try {
            annotationModelHelper.getAnnotationScanner().findAnnotations("javax.annotation.Resource", EnumSet.of(ElementKind.CLASS, ElementKind.METHOD, ElementKind.FIELD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotationMirror) {
                    ResourceImpl resourceImpl = new ResourceImpl(element, typeElement, annotationModelHelper);
                    arrayList.add(resourceImpl);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    private static List<ServiceRef> getWebServiceRefs(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
        ArrayList<ServiceRef> arrayList = new ArrayList<ServiceRef>();
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!annotationModelHelper.hasAnnotation(variableElement.getAnnotationMirrors(), "javax.xml.ws.WebServiceRef")) continue;
            CommonAnnotationHelper.addServiceReference(arrayList, variableElement, typeElement, annotationModelHelper);
        }
        return arrayList;
    }

    private static List<ServiceRef> getWebServiceRefs(final AnnotationModelHelper annotationModelHelper) {
        final ArrayList<ServiceRef> arrayList = new ArrayList<ServiceRef>();
        try {
            annotationModelHelper.getAnnotationScanner().findAnnotations("javax.xml.ws.WebServiceRef", EnumSet.of(ElementKind.FIELD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotationMirror) {
                    CommonAnnotationHelper.addServiceReference(arrayList, element, typeElement, annotationModelHelper);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    private static ResourceRef[] getResourceRefs(List<ResourceImpl> list) {
        ArrayList<ResourceRefImpl> arrayList = new ArrayList<ResourceRefImpl>(list.size());
        for (ResourceImpl resourceImpl : list) {
            if (!RESOURCE_REF_TYPES.contains(resourceImpl.getType())) continue;
            arrayList.add(new ResourceRefImpl(resourceImpl));
        }
        return arrayList.toArray(new ResourceRef[arrayList.size()]);
    }

    private static EnvEntry[] getEnvEntries(List<ResourceImpl> list) {
        ArrayList<EnvEntryImpl> arrayList = new ArrayList<EnvEntryImpl>(list.size());
        for (ResourceImpl resourceImpl : list) {
            if (!ENV_ENTRY_TYPES.contains(resourceImpl.getType())) continue;
            arrayList.add(new EnvEntryImpl(resourceImpl));
        }
        return arrayList.toArray(new EnvEntry[arrayList.size()]);
    }

    private static MessageDestinationRef[] getMessageDestinationRefs(List<ResourceImpl> list) {
        ArrayList<MessageDestinationRefImpl> arrayList = new ArrayList<MessageDestinationRefImpl>(list.size());
        for (ResourceImpl resourceImpl : list) {
            if (!MESSAGE_DESTINATION_TYPES.contains(resourceImpl.getType())) continue;
            arrayList.add(new MessageDestinationRefImpl(resourceImpl));
        }
        return arrayList.toArray(new MessageDestinationRef[arrayList.size()]);
    }

    private static List<ServiceRef> getServiceRefs(List<ResourceImpl> list) {
        ArrayList<ServiceRef> arrayList = new ArrayList<ServiceRef>(list.size());
        for (ResourceImpl resourceImpl : list) {
            if (!SERVICE_REF_TYPES.contains(resourceImpl.getType())) continue;
            arrayList.add(new ServiceRefImpl(resourceImpl));
        }
        return arrayList;
    }

    private static ResourceEnvRef[] getResourceEnvRefs(List<ResourceImpl> list) {
        ArrayList<ResourceEnvRefImpl> arrayList = new ArrayList<ResourceEnvRefImpl>(list.size());
        for (ResourceImpl resourceImpl : list) {
            if (RESOURCE_REF_TYPES.contains(resourceImpl.getType()) || ENV_ENTRY_TYPES.contains(resourceImpl.getType()) || MESSAGE_DESTINATION_TYPES.contains(resourceImpl.getType()) || SERVICE_REF_TYPES.contains(resourceImpl.getType())) continue;
            arrayList.add(new ResourceEnvRefImpl(resourceImpl));
        }
        return arrayList.toArray(new ResourceEnvRef[arrayList.size()]);
    }

    private static void addServiceReference(List<ServiceRef> list, Element element, TypeElement typeElement, AnnotationModelHelper annotationModelHelper) {
        DeclaredType declaredType;
        Element element2;
        TypeMirror typeMirror = element.asType();
        if (typeMirror.getKind() == TypeKind.DECLARED && (ElementKind.INTERFACE == (element2 = (declaredType = (DeclaredType)typeMirror).asElement()).getKind() || ElementKind.CLASS == element2.getKind())) {
            TypeElement typeElement2 = (TypeElement)element2;
            ServiceRefImpl serviceRefImpl = new ServiceRefImpl(element, typeElement2, typeElement, annotationModelHelper);
            ServiceRef serviceRef = null;
            for (ServiceRef portComponentRefArray : list) {
                if (!serviceRefImpl.getServiceRefName().equals(portComponentRefArray.getServiceRefName())) continue;
                serviceRef = portComponentRefArray;
            }
            if (serviceRef != null) {
                if (serviceRefImpl.sizePortComponentRef() > 0) {
                    PortComponentRef portComponentRef = serviceRefImpl.getPortComponentRef(0);
                    PortComponentRef[] portComponentRefArray = serviceRef.getPortComponentRef();
                    boolean bl = false;
                    for (PortComponentRef portComponentRef2 : portComponentRefArray) {
                        if (!portComponentRef2.getServiceEndpointInterface().equals(portComponentRef.getServiceEndpointInterface())) continue;
                        bl = true;
                    }
                    if (!bl) {
                        serviceRef.addPortComponentRef(portComponentRef);
                    }
                }
            } else {
                list.add(serviceRefImpl);
            }
        }
    }
}

