/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.CommonAttributePanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigData;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.Util;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.setFocus;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Field;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.WizardConstants;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CommonAttributeVisualPanel
extends JPanel
implements ChangeListener,
WizardConstants {
    public static final String TYPE_JDBC_RESOURCE = "_DS";
    public static final String TYPE_PERSISTENCE_MANAGER = "_PM";
    public static final String TYPE_CP_POOL_SETTING = "_CP_SETTING";
    protected ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.Bundle");
    protected final CommonAttributePanel panel;
    protected FieldGroup[] groups;
    protected int fieldSize;
    protected ResourceConfigHelper helper;
    protected String panelType = "_DS";
    protected boolean createNewResource = false;
    protected JTextArea descriptionTextArea = null;
    protected JPanel[] jPanel1 = null;
    protected JLabel[] jLabels = null;
    protected JComponent[] jFields = null;
    protected Field[] fields = null;
    protected String resourceName;
    protected boolean showGroupTitle = false;
    private JRadioButton existingResourceRadioButton;
    private JRadioButton newResourceRadioButton;
    private JPanel jPanel0;
    private JComboBox existingResourceComboBox;
    private boolean firstTime = true;
    private int y = 0;

    public CommonAttributeVisualPanel(CommonAttributePanel commonAttributePanel, FieldGroup[] fieldGroupArray, String string, ResourceConfigHelper resourceConfigHelper) {
        this.panel = commonAttributePanel;
        this.helper = resourceConfigHelper;
        this.resourceName = commonAttributePanel.getResourceName();
        this.setFieldGroups(fieldGroupArray);
        this.setName(NbBundle.getMessage(CommonAttributeVisualPanel.class, (String)("TITLE_" + fieldGroupArray[0].getName())));
        if (fieldGroupArray.length > 1) {
            this.showGroupTitle = true;
        }
        this.setLayout(new GridBagLayout());
        if (!this.showGroupTitle) {
            this.initDescriptionComponent();
        }
        this.setPanelType(string);
        if (this.getPanelType().equals(TYPE_JDBC_RESOURCE) || this.getPanelType().equals(TYPE_PERSISTENCE_MANAGER)) {
            this.initChoiceComponents();
            this.initComponents();
        } else {
            this.initComponents();
        }
        this.getAccessibleContext().setAccessibleName(this.bundle.getString("TITLE_ConnPoolWizardPanel_optionalProps"));
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("TITLE_ConnPoolWizardPanel_optionalProps"));
        this.refreshFields();
        this.firstTime = false;
    }

    public void setFieldGroups(FieldGroup[] fieldGroupArray) {
        this.groups = fieldGroupArray;
        this.fieldSize = 0;
        for (int i = 0; i < fieldGroupArray.length; ++i) {
            this.fieldSize += fieldGroupArray[i].sizeField();
        }
    }

    private void initComponents() {
        int n = 0;
        int n2 = 28;
        if (this.fieldSize < 6) {
            n2 = 42;
            n = 7;
        }
        int n3 = 0;
        this.jPanel1 = new JPanel[this.groups.length];
        this.fields = new Field[this.fieldSize];
        this.jLabels = new JLabel[this.fieldSize];
        this.jFields = new JComponent[this.fieldSize];
        for (int i = 0; i < this.groups.length; ++i) {
            GridBagConstraints gridBagConstraints;
            Field[] fieldArray;
            if (this.showGroupTitle) {
                fieldArray = new JLabel();
                fieldArray.setText(this.bundle.getString("LBL_GROUP_" + this.groups[i].getName()));
                fieldArray.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_LBL_GROUP_" + this.groups[i].getName() + "A11yDesc"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = this.y++;
                gridBagConstraints.fill = 2;
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.insets = new Insets(5, 0, 0, 11);
                this.add((Component)fieldArray, gridBagConstraints);
            }
            fieldArray = this.groups[i].getField();
            int n4 = fieldArray.length;
            this.jPanel1[i] = new JPanel();
            this.jPanel1[i].setLayout(new GridBagLayout());
            this.jPanel1[i].setMaximumSize(new Dimension(480, n2 * n4));
            this.jPanel1[i].setMinimumSize(new Dimension(480, n2 * n4));
            this.jPanel1[i].setPreferredSize(new Dimension(480, n2 * n4));
            for (int j = 0; j < n4; ++j) {
                JComponent jComponent;
                this.fields[n3] = fieldArray[j];
                JLabel jLabel = new JLabel();
                Mnemonics.setLocalizedText((JLabel)jLabel, (String)this.bundle.getString("LBL_" + this.fields[n3].getName()));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = j;
                gridBagConstraints.fill = 2;
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.insets = new Insets(2, 12, n, 0);
                this.jLabels[n3] = jLabel;
                this.jPanel1[i].add((Component)this.jLabels[n3], gridBagConstraints);
                if (FieldHelper.isList(this.fields[n3])) {
                    int n5;
                    jComponent = new JComboBox();
                    jLabel.setLabelFor(jComponent);
                    ((JComboBox)jComponent).getAccessibleContext().setAccessibleDescription(this.bundle.getString("ToolTip_" + this.fields[n3].getName()));
                    String[] stringArray = FieldHelper.getTags(this.fields[n3]);
                    for (n5 = 0; n5 < stringArray.length; ++n5) {
                        ((JComboBox)jComponent).addItem(stringArray[n5]);
                    }
                    n5 = n3;
                    ((JComboBox)jComponent).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            CommonAttributeVisualPanel.this.jComboBoxActionPerformed(actionEvent, n5);
                        }
                    });
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = j;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.insets = new Insets(2, 20, n, 0);
                    gridBagConstraints.weightx = 1.0;
                    this.jFields[n3] = jComponent;
                    this.jPanel1[i].add((Component)jComponent, gridBagConstraints);
                } else {
                    if (FieldHelper.isInt(this.fields[n3])) {
                        jComponent = new JTextField(Util.getNumericDocument(), null, 0);
                    } else {
                        jComponent = new JTextField();
                        ((JTextComponent)jComponent).setText("jTextField1");
                    }
                    jLabel.setLabelFor(jComponent);
                    ((JTextField)jComponent).getAccessibleContext().setAccessibleDescription(this.bundle.getString("ToolTip_" + this.fields[n3].getName()));
                    jComponent.setToolTipText(this.bundle.getString("ToolTip_" + this.fields[n3].getName()));
                    jComponent.setMinimumSize(new Dimension(340, 21));
                    jComponent.setPreferredSize(new Dimension(340, 21));
                    final int n6 = n3;
                    jComponent.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyReleased(KeyEvent keyEvent) {
                            CommonAttributeVisualPanel.this.jTextField1KeyReleased(keyEvent, n6);
                        }
                    });
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = j;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.insets = new Insets(2, 20, n, 0);
                    this.jFields[n3] = jComponent;
                    this.jPanel1[i].add((Component)jComponent, gridBagConstraints);
                }
                ++n3;
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.y++;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 10, 11);
            this.jPanel1[i].setBorder(new EtchedBorder());
            this.add((Component)this.jPanel1[i], gridBagConstraints);
        }
    }

    private void initDescriptionComponent() {
        this.descriptionTextArea = new JTextArea();
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(UIManager.getFont("Label.font"));
        this.descriptionTextArea.setText(this.bundle.getString(this.resourceName + "_Description"));
        this.descriptionTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descriptionTextArea.setRequestFocusEnabled(false);
        this.descriptionTextArea.setEnabled(false);
        this.descriptionTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.y++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(12, 12, 20, 11);
        this.add((Component)this.descriptionTextArea, gridBagConstraints);
    }

    private void jComboBoxActionPerformed(ActionEvent actionEvent, int n) {
        String string;
        String string2;
        ResourceConfigData resourceConfigData = this.helper.getData();
        String string3 = (String)((JComboBox)this.jFields[n]).getSelectedItem();
        if (!string3.equals(string2 = resourceConfigData.getString(string = this.fields[n].getName()))) {
            resourceConfigData.setString(string, string3);
        }
    }

    private void jTextField1KeyReleased(KeyEvent keyEvent, int n) {
        ResourceConfigData resourceConfigData = this.helper.getData();
        String string = ((JTextField)this.jFields[n]).getText();
        String string2 = this.fields[n].getName();
        String string3 = resourceConfigData.getString(string2);
        String string4 = this.jLabels[n].getText();
        if (!string.equals(string3)) {
            resourceConfigData.setString(string2, string);
        }
        this.panel.fireChange(this);
    }

    private void initChoiceComponents() {
        this.jPanel0 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.existingResourceRadioButton = new JRadioButton();
        this.existingResourceComboBox = new JComboBox();
        this.newResourceRadioButton = new JRadioButton();
        this.jPanel0.setMaximumSize(new Dimension(480, 150));
        this.jPanel0.setMinimumSize(new Dimension(480, 150));
        this.jPanel0.setPreferredSize(new Dimension(480, 150));
        this.jPanel0.setLayout(new GridBagLayout());
        this.jPanel0.setBorder(new EtchedBorder());
        this.existingResourceRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.existingResourceRadioButton, (String)this.bundle.getString("ExistingResource" + this.getPanelType()));
        this.existingResourceRadioButton.setToolTipText(this.bundle.getString("ACS_ExistingResourceA11yDesc" + this.getPanelType()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.jPanel0.add((Component)this.existingResourceRadioButton, gridBagConstraints);
        this.existingResourceComboBox.setToolTipText(this.bundle.getString("ACS_ExistingResourceComboBoxA11yDesc" + this.getPanelType()));
        this.existingResourceComboBox.getAccessibleContext().setAccessibleName(this.bundle.getString("ExistingResource" + this.getPanelType()));
        this.existingResourceComboBox.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_ExistingResourceComboBoxA11yDesc" + this.getPanelType()));
        this.existingResourceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonAttributeVisualPanel.this.existingResourceComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 24, 5, 11);
        this.jPanel0.add((Component)this.existingResourceComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.newResourceRadioButton, (String)this.bundle.getString("NewResource" + this.getPanelType()));
        this.newResourceRadioButton.setToolTipText(this.bundle.getString("ACS_NewResourceA11yDesc" + this.getPanelType()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.jPanel0.add((Component)this.newResourceRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.y++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 40, 0);
        this.add((Component)this.jPanel0, gridBagConstraints);
        buttonGroup.add(this.existingResourceRadioButton);
        buttonGroup.add(this.newResourceRadioButton);
        buttonGroup.getSelection().addChangeListener(this);
        List list = null;
        if (this.getPanelType().equals(TYPE_JDBC_RESOURCE)) {
            list = ResourceUtils.getRegisteredConnectionPools(this.helper.getData());
        } else if (this.getPanelType().equals(TYPE_PERSISTENCE_MANAGER)) {
            list = ResourceUtils.getRegisteredJdbcResources(this.helper.getData());
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.existingResourceComboBox.addItem(list.get(i));
            }
        }
        if (this.existingResourceComboBox.getItemCount() == 0) {
            this.existingResourceComboBox.insertItemAt(this.bundle.getString("NoResource" + this.getPanelType()), 0);
            this.existingResourceRadioButton.setEnabled(true);
            this.existingResourceComboBox.setEnabled(true);
        } else {
            this.existingResourceComboBox.insertItemAt(this.bundle.getString("SelectFromTheList"), 0);
            this.existingResourceRadioButton.setSelected(true);
            this.newResourceRadioButton.setSelected(false);
        }
        this.existingResourceComboBox.setSelectedIndex(0);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource().getClass() == JToggleButton.ToggleButtonModel.class) {
            if (this.existingResourceRadioButton.isSelected()) {
                this.existingResourceComboBox.setEnabled(true);
                this.setExistingResourceData();
            } else {
                this.existingResourceComboBox.setEnabled(false);
                this.setNewResourceData();
            }
            if (!this.firstTime) {
                this.panel.fireChange(this);
            }
        }
    }

    private void existingResourceComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setExistingResourceData();
    }

    public boolean isNewResourceSelected() {
        return this.createNewResource;
    }

    public void setExistingResourceData() {
        ResourceConfigData resourceConfigData = this.helper.getData();
        if (this.existingResourceComboBox.getSelectedIndex() > 0) {
            String string = this.existingResourceComboBox.getSelectedItem().toString();
            if (this.getPanelType().equals(TYPE_JDBC_RESOURCE)) {
                resourceConfigData.setString("pool-name", string);
            } else if (this.getPanelType().equals(TYPE_PERSISTENCE_MANAGER)) {
                resourceConfigData.setString("jdbc-resource-jndi-name", string);
            }
        } else if (!this.firstTime) {
            if (this.getPanelType().equals(TYPE_JDBC_RESOURCE)) {
                resourceConfigData.setString("pool-name", "");
            } else if (this.getPanelType().equals(TYPE_PERSISTENCE_MANAGER)) {
                resourceConfigData.setString("jdbc-resource-jndi-name", "");
            }
        }
        if (!this.firstTime) {
            this.panel.fireChange(this);
        }
        this.createNewResource = false;
    }

    public void setNewResourceData() {
        this.createNewResource = true;
    }

    public void refreshFields() {
        ResourceConfigData resourceConfigData = this.helper.getData();
        for (int i = 0; i < this.jFields.length; ++i) {
            String string;
            String string2 = FieldHelper.isList(this.fields[i]) ? (String)((JComboBox)this.jFields[i]).getSelectedItem() : ((JTextField)this.jFields[i]).getText();
            String string3 = this.fields[i].getName();
            Object object = resourceConfigData.get(string3);
            if (object == null) {
                object = FieldHelper.getDefaultValue(this.fields[i]);
                if (string3.equals("jndi-name") && (string = resourceConfigData.getTargetFile()) != null && (this.getPanelType().equals(TYPE_JDBC_RESOURCE) || this.getPanelType().equals(TYPE_PERSISTENCE_MANAGER))) {
                    object = object + string;
                }
                resourceConfigData.set(string3, object);
            }
            if (string2.equals(string = (String)object)) continue;
            if (FieldHelper.isList(this.fields[i])) {
                ((JComboBox)this.jFields[i]).setSelectedItem(string);
                continue;
            }
            ((JTextField)this.jFields[i]).setText(string);
        }
        if (this.getPanelType().equals(TYPE_JDBC_RESOURCE)) {
            String string = resourceConfigData.getString("pool-name");
            this.existingResourceComboBox.setSelectedItem(string);
        } else if (this.getPanelType().equals(TYPE_PERSISTENCE_MANAGER)) {
            String string = resourceConfigData.getString("jdbc-resource-jndi-name");
            this.existingResourceComboBox.setSelectedItem(string);
        }
    }

    public CommonAttributeVisualPanel setFirstTime(boolean bl) {
        this.firstTime = bl;
        return this;
    }

    public void initData() {
        this.refreshFields();
    }

    protected String getPanelType() {
        return this.panelType;
    }

    protected void setPanelType(String string) {
        this.panelType = string;
    }

    public void setInitialFocus() {
        new setFocus(this.existingResourceRadioButton);
    }

    public void setPropInitialFocus() {
        new setFocus(this.jFields[0]);
    }

    public void setHelper(ResourceConfigHelper resourceConfigHelper) {
        this.helper = resourceConfigHelper;
        this.helper.getData().setString("jndi-name", resourceConfigHelper.getData().getTargetFile());
        this.refreshFields();
    }
}

