/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.editors.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.DDTableModel;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.DDTableModelEditor;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.MessageArea;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.MultiLineField;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.SortableDDTableModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class DDTablePanel
extends JPanel
implements EnhancedCustomPropertyEditor {
    static final ResourceBundle bundle = NbBundle.getBundle(DDTablePanel.class);
    private DDTableModel model;
    private JScrollPane scrollPane;
    private JTable tab;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private int sortCol;
    private Dialog editDialog;
    boolean getPropertyValueCalled = false;

    public DDTablePanel(DDTableModel m, String[] toolTips) {
        this.initComponents(m, toolTips, true, true, true, 500, 70, 12);
    }

    public DDTablePanel(DDTableModel m, String[] toolTips, int insetVal) {
        this.initComponents(m, toolTips, true, true, true, 500, 70, insetVal);
    }

    public DDTablePanel(DDTableModel m, String[] toolTips, boolean allowAdd, boolean allowRemove) {
        this.initComponents(m, toolTips, allowAdd, allowRemove, true, 500, 70, 12);
    }

    public DDTablePanel(DDTableModel m) {
        this.initComponents(m, new String[0], false, false, false, 500, 70, 12);
    }

    public DDTablePanel(DDTableModel m, String[] toolTips, int width, int height) {
        this.initComponents(m, toolTips, true, true, true, width, height, 12);
    }

    private void initComponents(DDTableModel m, String[] toolTips, boolean allowAdd, boolean allowRemove, boolean allowEdit, int width, int height, int insetVal) {
        this.model = m;
        this.sortCol = -1;
        this.setBorder(new EmptyBorder(insetVal, insetVal, insetVal, insetVal));
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.tab = new JTable(this.model);
        this.tab.setSelectionMode(0);
        this.scrollPane.setViewportView(this.tab);
        this.add((Component)this.scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        this.addButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)bundle.getString("CTL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DDTablePanel.this.addButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.addButton);
        this.addButton.setVisible(allowAdd);
        this.editButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)bundle.getString("CTL_Edit"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DDTablePanel.this.editButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.editButton);
        this.removeButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)bundle.getString("CTL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DDTablePanel.this.removeButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.removeButton);
        this.removeButton.setEnabled(false);
        this.removeButton.setVisible(allowRemove);
        this.add((Component)buttonPanel, "South");
        if (this.model instanceof SortableDDTableModel) {
            this.addMouseListenerToHeader((SortableDDTableModel)this.model);
        }
        this.setHeaderToolTips(toolTips);
        if (allowRemove || allowEdit) {
            this.tab.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && DDTablePanel.this.tab.getRowCount() > 0) {
                        boolean rowSelected = DDTablePanel.this.tab.getSelectedRow() != -1;
                        DDTablePanel.this.removeButton.setEnabled(rowSelected);
                        DDTablePanel.this.editButton.setEnabled(rowSelected);
                    }
                }
            });
        }
        if (allowEdit) {
            this.tab.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    int row;
                    if (me.getClickCount() == 2 && (row = DDTablePanel.this.tab.rowAtPoint(me.getPoint())) != -1) {
                        DDTablePanel.this.tab.setRowSelectionInterval(row, row);
                        DDTablePanel.this.editButtonActionPerformed(null);
                    }
                }
            });
        }
        this.editButton.setEnabled(false);
        this.editButton.setVisible(allowEdit);
        int tableWidth = this.initColumnSizes();
        if (tableWidth > width) {
            width = tableWidth;
        }
        this.tab.setPreferredScrollableViewportSize(new Dimension(width, height));
        this.addAncestorListener(new AListener());
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DDTablePanel"));
        this.addButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_add"));
        this.editButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_edit"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_remove"));
        this.tab.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DDTable"));
        this.tab.getAccessibleContext().setAccessibleName(this.model.getModelName());
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.tab.getSelectionModel().addListSelectionListener(l);
    }

    public void addVerticalScrollBarAdjustmentListener(AdjustmentListener l) {
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(l);
    }

    public void setVerticalScrollBarValue(int val) {
        int curVal = this.scrollPane.getVerticalScrollBar().getValue();
        if (curVal != val) {
            this.scrollPane.getVerticalScrollBar().setValue(val);
        }
    }

    public void linkLabel(JLabel label) {
        label.setLabelFor(this.tab);
    }

    public Color getHeaderColor() {
        if (this.tab.getColumnCount() < 1) {
            return Color.black;
        }
        TableColumn c = this.tab.getColumnModel().getColumn(0);
        TableCellRenderer cellR = c.getHeaderRenderer();
        Component comp = cellR.getTableCellRendererComponent(this.tab, c.getHeaderValue(), false, false, -1, 0);
        return comp.getForeground();
    }

    public int getSelectedRow() {
        return this.tab.getSelectedRow();
    }

    public void setSelectedRow(int row) {
        if (row == -1) {
            this.tab.clearSelection();
        } else {
            this.tab.addRowSelectionInterval(row, row);
        }
    }

    private void setHeaderToolTips(String[] toolTips) {
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            TableColumn c = this.tab.getColumnModel().getColumn(i);
            TableCellRenderer cellR = c.getHeaderRenderer();
            DefaultTableCellRenderer label = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JTableHeader header;
                    if (table != null && (header = table.getTableHeader()) != null) {
                        this.setForeground(header.getForeground());
                        this.setBackground(header.getBackground());
                        int style = DDTablePanel.this.tab.convertColumnIndexToModel(column) == DDTablePanel.this.sortCol ? 1 : 0;
                        this.setFont(header.getFont().deriveFont(style));
                    }
                    this.setText(value == null ? "" : value.toString());
                    this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    return this;
                }
            };
            label.setHorizontalAlignment(0);
            c.setHeaderRenderer(label);
            cellR = label;
            Component comp = cellR.getTableCellRendererComponent(this.tab, c.getHeaderValue(), false, false, -1, i);
            if (comp == null || !(comp instanceof JComponent) || i >= toolTips.length) continue;
            JComponent jComp = (JComponent)comp;
            jComp.setToolTipText(toolTips[i]);
        }
    }

    private int maxSize(int col) {
        Component c = null;
        int max = 0;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            c = this.tab.getDefaultRenderer(this.model.getColumnClass(col)).getTableCellRendererComponent(this.tab, this.model.getValueAt(i, col), false, false, i, col);
            if (c.getPreferredSize().width <= max) continue;
            max = c.getPreferredSize().width;
        }
        return max;
    }

    private int initColumnSizes() {
        int totWidth = this.tab.getIntercellSpacing().width * this.model.getColumnCount();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            TableColumn column = this.tab.getColumnModel().getColumn(i);
            Component comp = column.getHeaderRenderer().getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            int headerWidth = comp.getPreferredSize().width + 6;
            int cellWidth = this.maxSize(i);
            totWidth += Math.max(headerWidth, cellWidth);
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
        }
        return totWidth;
    }

    public void setCellEditor(int col, TableCellEditor cEdit) {
        this.tab.getColumnModel().getColumn(col).setCellEditor(cEdit);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.editRow(this.tab.getSelectedRow(), true);
    }

    private void closeEditDialog() {
        this.editDialog.setVisible(false);
        this.editDialog.dispose();
        this.editDialog = null;
    }

    public void editSelectedRow() {
        this.editRow(this.tab.getSelectedRow(), false);
    }

    private void editRow(final int row, final boolean isNew) {
        final DDTableModelEditor editor = this.model.getEditor();
        final Object obj = isNew ? this.model.makeNewElement() : this.model.getValueAt(row);
        editor.setValue(obj);
        JPanel p = new JPanel();
        JPanel editorPanel = editor.getPanel();
        Object hCtx = null;
        if (hCtx != null) {
            HelpCtx.setHelpIDString((JComponent)p, (String)hCtx.getHelpID());
        }
        p.add("North", editorPanel);
        p.getAccessibleContext().setAccessibleDescription(editorPanel.getAccessibleContext().getAccessibleDescription());
        String editType = isNew ? bundle.getString("TTL_ADD") : bundle.getString("TTL_EDIT");
        String title = MessageFormat.format(bundle.getString("TTL_DIALOG"), editType, this.model.getModelName());
        if (p.getAccessibleContext().getAccessibleDescription() == null) {
            p.getAccessibleContext().setAccessibleDescription(title);
        }
        DialogDescriptor dd = new DialogDescriptor((Object)p, title, true, 2, null, 0, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() != NotifyDescriptor.OK_OPTION) {
                    if (isNew) {
                        DDTablePanel.this.model.newElementCancelled(obj);
                    }
                } else {
                    List errors = DDTablePanel.this.model.isValueValid(editor.getValue(), isNew ? -1 : row);
                    if (!errors.isEmpty()) {
                        Component errorComp = DDTablePanel.this.getErrorComponent("MSG_TableErrors", errors);
                        errorComp.getAccessibleContext().setAccessibleDescription(DDTablePanel.this.getA11yText(errors));
                        NotifyDescriptor d = new NotifyDescriptor((Object)errorComp, MessageFormat.format(bundle.getString("TTL_DIALOG"), bundle.getString("TTL_ERROR"), DDTablePanel.this.model.getModelName()), 2, 0, new Object[]{NotifyDescriptor.OK_OPTION}, null);
                        DialogDisplayer.getDefault().notify(d);
                        return;
                    }
                    if (!isNew) {
                        if (!DDTablePanel.this.model.isEditValid(editor.getValue(), row)) {
                            return;
                        }
                        int[] rows = DDTablePanel.this.tab.getSelectedRows();
                        DDTablePanel.this.tab.clearSelection();
                        DDTablePanel.this.model.setValueAt(row, editor.getValue());
                        if (rows != null) {
                            for (int i = 0; i < rows.length; ++i) {
                                DDTablePanel.this.tab.setRowSelectionInterval(rows[i], rows[i]);
                            }
                        }
                    } else {
                        DDTablePanel.this.model.addRowAt(row >= DDTablePanel.this.model.getRowCount() ? DDTablePanel.this.model.getRowCount() - 1 : row, obj, editor.getValue());
                    }
                }
                DDTablePanel.this.closeEditDialog();
            }
        });
        dd.setClosingOptions(new Object[0]);
        JButton cancel = new JButton(bundle.getString("LBL_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Cancel"));
        cancel.setVerifyInputWhenFocusTarget(false);
        dd.setOptions(new Object[]{NotifyDescriptor.OK_OPTION, cancel});
        this.editDialog = DialogDisplayer.getDefault().createDialog(dd);
        this.editDialog.setVisible(true);
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.editRow(this.tab.getSelectedRow(), false);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int row = this.tab.getSelectedRow();
        List errors = this.model.canRemoveRow(row);
        if (!errors.isEmpty()) {
            Component c = this.getErrorComponent("MSG_RemoveWarning", errors);
            NotifyDescriptor.Confirmation confirmDesc = new NotifyDescriptor.Confirmation((Object)c, bundle.getString("CTL_Remove") + " " + this.model.getModelName() + " " + bundle.getString("TTL_WARNING"));
            Object[] options = new Object[]{bundle.getString("CTL_Remove"), NotifyDescriptor.CANCEL_OPTION};
            confirmDesc.setOptions(options);
            Object o = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmDesc);
            if (o == NotifyDescriptor.CANCEL_OPTION) {
                return;
            }
        }
        this.tab.removeRowSelectionInterval(row, row);
        DDTableModelEditor editor = this.model.getEditor();
        editor.setValue(this.model.getValueAt(row));
        this.model.removeRowAt(row);
    }

    private Component getErrorComponent(String summaryString, List errors) {
        if (errors.size() == 1) {
            return new MultiLineField((String)errors.get(0));
        }
        MessageArea msg = new MessageArea();
        Object[] o = new Object[]{this.model.getModelName()};
        msg.setText(MessageFormat.format(bundle.getString(summaryString), o));
        Iterator iter = errors.iterator();
        while (iter.hasNext()) {
            msg.appendBulletItem((String)iter.next());
        }
        return msg;
    }

    private String getA11yText(List errors) {
        Object[] o = new Object[]{this.model.getModelName()};
        StringBuffer buf = new StringBuffer(MessageFormat.format(bundle.getString("MSG_TableErrors"), o));
        for (int i = 0; i < errors.size(); ++i) {
            buf.append("\n" + (String)errors.get(i));
        }
        return buf.toString();
    }

    private void addMouseListenerToHeader(final SortableDDTableModel model) {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = DDTablePanel.this.tab.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = DDTablePanel.this.tab.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    model.setSortColumn(DDTablePanel.this.sortCol = column);
                }
            }
        };
        JTableHeader th = this.tab.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public Object getPropertyValue() throws IllegalStateException {
        this.getPropertyValueCalled = true;
        return this.model.getValue();
    }

    class AListener
    implements AncestorListener {
        AListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            if (!DDTablePanel.this.isShowing() && !DDTablePanel.this.getPropertyValueCalled) {
                DDTablePanel.this.model.editsCancelled();
            }
        }
    }
}

