/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCSchema;
import org.netbeans.modules.db.metadata.model.spi.CatalogImplementation;

public class JDBCCatalog
extends CatalogImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCCatalog.class.getName());
    protected final JDBCMetadata jdbcMetadata;
    protected final String name;
    protected final boolean _default;
    protected final String defaultSchemaName;
    protected Schema defaultSchema;
    protected Schema syntheticSchema;
    protected Map<String, Schema> schemas;

    public JDBCCatalog(JDBCMetadata jdbcMetadata, String name, boolean _default, String defaultSchemaName) {
        assert (defaultSchemaName == null || _default);
        this.jdbcMetadata = jdbcMetadata;
        this.name = name;
        this._default = _default;
        this.defaultSchemaName = defaultSchemaName;
        LOGGER.log(Level.FINE, "Create JDBCCatalog(jdbcMetadata={0}, name={1}, _default={2}, defaultSchemaName={3})", new Object[]{jdbcMetadata, name, _default, defaultSchemaName});
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean isDefault() {
        return this._default;
    }

    @Override
    public final Schema getSyntheticSchema() {
        this.initSchemas();
        return this.syntheticSchema;
    }

    @Override
    public final Collection<Schema> getSchemas() {
        return this.initSchemas().values();
    }

    @Override
    public final Schema getSchema(String name) {
        return MetadataUtilities.find(name, this.initSchemas());
    }

    @Override
    public final void refresh() {
        this.schemas = null;
    }

    public String toString() {
        return "JDBCCatalog[name='" + this.name + "',default=" + this._default + "]";
    }

    public final Schema getDefaultSchema() {
        this.initSchemas();
        return this.defaultSchema;
    }

    protected JDBCSchema createJDBCSchema(String name, boolean _default, boolean synthetic) {
        return new JDBCSchema(this, name, _default, synthetic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSchemas() {
        LinkedHashMap<String, Schema> newSchemas = new LinkedHashMap<String, Schema>();
        try {
            if (this.jdbcMetadata.getDmd().supportsSchemasInTableDefinitions()) {
                ResultSet rs = this.jdbcMetadata.getDmd().getSchemas();
                if (rs != null) {
                    int columnCount = rs.getMetaData().getColumnCount();
                    if (columnCount < 2) {
                        LOGGER.fine("DatabaseMetaData.getSchemas() not JDBC 3.0-compliant");
                    }
                    boolean supportsCatalog = this.jdbcMetadata.getDmd().supportsCatalogsInTableDefinitions();
                    try {
                        while (rs.next()) {
                            String schemaName = rs.getString("TABLE_SCHEM");
                            String catalogName = columnCount > 1 && supportsCatalog ? rs.getString("TABLE_CATALOG") : this.name;
                            LOGGER.log(Level.FINE, "Read schema ''{0}'' in catalog ''{1}''", new Object[]{schemaName, catalogName});
                            LOGGER.log(Level.FINEST, "MetadataUtilities.equals(catalogName=''{0}'', name=''{1}'') returns {2}", new Object[]{catalogName, this.name, MetadataUtilities.equals(catalogName, this.name)});
                            if (!MetadataUtilities.equals(catalogName, this.name)) continue;
                            if (this.defaultSchemaName != null && MetadataUtilities.equals(schemaName, this.defaultSchemaName)) {
                                this.defaultSchema = this.createJDBCSchema(this.defaultSchemaName, true, false).getSchema();
                                newSchemas.put(this.defaultSchema.getName(), this.defaultSchema);
                                LOGGER.log(Level.FINE, "Created default schema {0}", this.defaultSchema);
                                continue;
                            }
                            Schema schema = this.createJDBCSchema(schemaName, false, false).getSchema();
                            newSchemas.put(schemaName, schema);
                            LOGGER.log(Level.FINE, "Created schema {0}", schema);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                } else {
                    LOGGER.info(this + " returns null from jdbcMetadata.getDmd().getSchemas().");
                }
            }
            if (newSchemas.isEmpty() && !this.jdbcMetadata.getDmd().supportsSchemasInTableDefinitions()) {
                this.syntheticSchema = this.createJDBCSchema(null, this._default, true).getSchema();
                if (this._default) {
                    this.defaultSchema = this.syntheticSchema;
                }
                LOGGER.log(Level.FINE, "Created synthetic schema {0}", this.syntheticSchema);
            }
        }
        catch (SQLException e) {
            throw new MetadataException(e);
        }
        this.schemas = Collections.unmodifiableMap(newSchemas);
    }

    private Map<String, Schema> initSchemas() {
        if (this.schemas != null) {
            return this.schemas;
        }
        LOGGER.log(Level.FINE, "Initializing schemas in {0}", this);
        this.createSchemas();
        return this.schemas;
    }

    public final JDBCMetadata getJDBCMetadata() {
        return this.jdbcMetadata;
    }
}

