/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.compiler_pass.opts;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jruby.compiler.ir.CodeVersion;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IR_Class;
import org.jruby.compiler.ir.IR_Closure;
import org.jruby.compiler.ir.IR_ExecutionScope;
import org.jruby.compiler.ir.IR_Module;
import org.jruby.compiler.ir.IR_Scope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.compiler_pass.CompilerPass;
import org.jruby.compiler.ir.instructions.ASSERT_METHOD_VERSION_Instr;
import org.jruby.compiler.ir.instructions.COPY_Instr;
import org.jruby.compiler.ir.instructions.CallInstruction;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.instructions.JUMP_Instr;
import org.jruby.compiler.ir.operands.Array;
import org.jruby.compiler.ir.operands.BreakResult;
import org.jruby.compiler.ir.operands.Constant;
import org.jruby.compiler.ir.operands.Fixnum;
import org.jruby.compiler.ir.operands.Float;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalOptimizationPass
implements CompilerPass {
    @Override
    public boolean isPreOrder() {
        return false;
    }

    @Override
    public void run(IR_Scope s) {
        if (s instanceof IR_ExecutionScope) {
            IR_ExecutionScope es = (IR_ExecutionScope)s;
            List<IR_Closure> closures = es.getClosures();
            for (IR_Closure c : closures) {
                this.run(c);
            }
            LocalOptimizationPass.runLocalOpts(es);
            es.computeExecutionScopeFlags();
        }
    }

    private static void runLocalOpts(IR_ExecutionScope s) {
        Label deoptLabel = s.getNewLabel();
        HashMap<Operand, Operand> valueMap = new HashMap<Operand, Operand>();
        HashMap<String, CodeVersion> versionMap = new HashMap<String, CodeVersion>();
        ListIterator<IR_Instr> instrs = s.getInstrs().listIterator();
        while (instrs.hasNext()) {
            IR_Instr i = instrs.next();
            Operation iop = i._op;
            if (iop.startsBasicBlock()) {
                valueMap = new HashMap();
                versionMap = new HashMap();
            }
            Operand val = i.simplifyAndGetResult(valueMap);
            Variable res = i.getResult();
            if (val != null && res != null && res != val) {
                valueMap.put(res, val);
                if (val instanceof BreakResult) {
                    BreakResult br = (BreakResult)val;
                    i.markDead();
                    instrs.add(new COPY_Instr(res, br._result));
                    instrs.add(new JUMP_Instr(br._jumpTarget));
                }
            } else if (iop.isCall()) {
                val = null;
                CallInstruction call2 = (CallInstruction)i;
                Operand r = call2.getReceiver();
                if (r != null) {
                    IRMethod rm;
                    Operand v;
                    if (!r.isConstant() && (v = (Operand)valueMap.get(r)) != null) {
                        r = v;
                    }
                    if ((rm = call2.getTargetMethodWithReceiver(r)) != null) {
                        Operand[] args2;
                        IR_Module rc = rm.getDefiningModule();
                        if (rc == IR_Class.getCoreClass("Fixnum")) {
                            args2 = call2.getOperands();
                            if (args2[2].isConstant()) {
                                LocalOptimizationPass.addMethodGuard(rm, deoptLabel, versionMap, instrs);
                                val = ((Fixnum)r).computeValue(rm.getName(), (Constant)args2[2]);
                            }
                        } else if (rc == IR_Class.getCoreClass("Float")) {
                            args2 = call2.getOperands();
                            if (args2[2].isConstant()) {
                                LocalOptimizationPass.addMethodGuard(rm, deoptLabel, versionMap, instrs);
                                val = ((Float)r).computeValue(rm.getName(), (Constant)args2[2]);
                            }
                        } else if (rc == IR_Class.getCoreClass("Array") && (args2 = call2.getOperands())[2] instanceof Fixnum && rm.getName() == "[]") {
                            LocalOptimizationPass.addMethodGuard(rm, deoptLabel, versionMap, instrs);
                            val = ((Array)r).fetchCompileTimeArrayElement(((Fixnum)args2[2])._value.intValue(), false);
                        }
                        if (val != null) {
                            i.markDead();
                            instrs.add(new COPY_Instr(res, val));
                            valueMap.put(res, val);
                        }
                    }
                }
            }
            if (!iop.endsBasicBlock() && (!iop.isCall() || i.isDead())) continue;
            valueMap = new HashMap();
            versionMap = new HashMap();
        }
    }

    private static void addMethodGuard(IRMethod m, Label deoptLabel, Map<String, CodeVersion> versionMap, ListIterator instrs) {
        String fullName = m.getFullyQualifiedName();
        CodeVersion knownVersion = versionMap.get(fullName);
        CodeVersion mVersion = m.getVersion();
        if (knownVersion == null || knownVersion._version != mVersion._version) {
            instrs.add(new ASSERT_METHOD_VERSION_Instr(m.getDefiningModule(), m.getName(), m.getVersion(), deoptLabel));
            versionMap.put(fullName, mVersion);
        }
    }
}

