/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jcodings.specific.ASCIIEncoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;

@JRubyClass(name={"Complex"}, parent="Numeric")
public class RubyComplex
extends RubyNumeric {
    private static ObjectAllocator COMPLEX_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyFixnum zero = RubyFixnum.zero(runtime2);
            return new RubyComplex(runtime2, klass, zero, zero);
        }
    };
    private IRubyObject real;
    private IRubyObject image;
    private static boolean canonicalization = false;
    private static final boolean CL_CANON = true;

    public static RubyClass createComplexClass(Ruby runtime2) {
        String[] undefined;
        RubyClass complexc = runtime2.defineClass("Complex", runtime2.getNumeric(), COMPLEX_ALLOCATOR);
        runtime2.setComplex(complexc);
        complexc.index = 20;
        complexc.setReifiedClass(RubyComplex.class);
        complexc.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyComplex;
            }
        };
        complexc.defineAnnotatedMethods(RubyComplex.class);
        complexc.getSingletonClass().undefineMethod("allocate");
        complexc.getSingletonClass().undefineMethod("new");
        for (String undef : undefined = new String[]{"<", "<=", "<=>", ">", ">=", "between?", "divmod", "floor", "ceil", "modulo", "round", "step", "truncate"}) {
            complexc.undefineMethod(undef);
        }
        complexc.defineConstant("I", RubyComplex.newComplexConvert(runtime2.getCurrentContext(), RubyFixnum.zero(runtime2), RubyFixnum.one(runtime2)));
        return complexc;
    }

    private RubyComplex(Ruby runtime2, IRubyObject clazz, IRubyObject real2, IRubyObject image2) {
        super(runtime2, (RubyClass)clazz);
        this.real = real2;
        this.image = image2;
    }

    static RubyComplex newComplexRaw(Ruby runtime2, IRubyObject x, RubyObject y) {
        return new RubyComplex(runtime2, (IRubyObject)runtime2.getComplex(), x, y);
    }

    static RubyComplex newComplexRaw(Ruby runtime2, IRubyObject x) {
        return new RubyComplex(runtime2, (IRubyObject)runtime2.getComplex(), x, RubyFixnum.zero(runtime2));
    }

    public static IRubyObject newComplexCanonicalize(ThreadContext context, IRubyObject x) {
        return RubyComplex.newComplexCanonicalize(context, x, RubyFixnum.zero(context.getRuntime()));
    }

    public static IRubyObject newComplexCanonicalize(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyComplex.canonicalizeInternal(context, context.getRuntime().getComplex(), x, y);
    }

    static IRubyObject newComplexPolar(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyComplex.polar(context, context.getRuntime().getComplex(), x, y);
    }

    static IRubyObject newComplex(ThreadContext context, IRubyObject clazz, IRubyObject x) {
        return RubyComplex.newComplex(context, clazz, x, RubyFixnum.zero(context.getRuntime()));
    }

    static IRubyObject newComplex(ThreadContext context, IRubyObject clazz, IRubyObject x, IRubyObject y) {
        assert (!(x instanceof RubyComplex));
        return RubyComplex.canonicalizeInternal(context, clazz, x, y);
    }

    static RubyComplex newComplexBang(ThreadContext context, IRubyObject clazz, IRubyObject x, IRubyObject y) {
        return new RubyComplex(context.getRuntime(), clazz, x, y);
    }

    public static RubyComplex newComplexBang(ThreadContext context, IRubyObject clazz, IRubyObject x) {
        return RubyComplex.newComplexBang(context, clazz, x, RubyFixnum.zero(context.getRuntime()));
    }

    IRubyObject getImage() {
        return this.image;
    }

    IRubyObject getReal() {
        return this.real;
    }

    private static IRubyObject m_cos(ThreadContext context, IRubyObject x) {
        if (Numeric.f_real_p(context, x).isTrue()) {
            return RubyMath.cos(x, x);
        }
        RubyComplex complex = (RubyComplex)x;
        return RubyComplex.newComplex(context, context.getRuntime().getComplex(), Numeric.f_mul(context, RubyMath.cos(x, complex.real), RubyMath.cosh(x, complex.image)), Numeric.f_mul(context, Numeric.f_negate(context, RubyMath.sin(x, complex.real)), RubyMath.sinh(x, complex.image)));
    }

    private static IRubyObject m_sin(ThreadContext context, IRubyObject x) {
        if (Numeric.f_real_p(context, x).isTrue()) {
            return RubyMath.sin(x, x);
        }
        RubyComplex complex = (RubyComplex)x;
        return RubyComplex.newComplex(context, context.getRuntime().getComplex(), Numeric.f_mul(context, RubyMath.sin(x, complex.real), RubyMath.cosh(x, complex.image)), Numeric.f_mul(context, RubyMath.cos(x, complex.real), RubyMath.sinh(x, complex.image)));
    }

    private static IRubyObject m_sqrt(ThreadContext context, IRubyObject x) {
        if (Numeric.f_real_p(context, x).isTrue()) {
            if (!Numeric.f_negative_p(context, x)) {
                return RubyMath.sqrt(x, x);
            }
            return RubyComplex.newComplex(context, context.getRuntime().getComplex(), RubyFixnum.zero(context.getRuntime()), RubyMath.sqrt(x, Numeric.f_negate(context, x)));
        }
        RubyComplex complex = (RubyComplex)x;
        if (Numeric.f_negative_p(context, complex.image)) {
            return Numeric.f_conjugate(context, RubyComplex.m_sqrt(context, Numeric.f_conjugate(context, x)));
        }
        IRubyObject a = Numeric.f_abs(context, x);
        RubyFixnum two = RubyFixnum.two(context.getRuntime());
        return RubyComplex.newComplex(context, context.getRuntime().getComplex(), RubyMath.sqrt(x, Numeric.f_div(context, Numeric.f_add(context, a, complex.real), two)), RubyMath.sqrt(x, Numeric.f_div(context, Numeric.f_sub(context, a, complex.real), two)));
    }

    @Deprecated
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyComplex.newInstanceBang(context, recv2, args2[0]);
            }
            case 2: {
                return RubyComplex.newInstanceBang(context, recv2, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv2, IRubyObject real2) {
        if (!(real2 instanceof RubyNumeric)) {
            real2 = Numeric.f_to_i(context, real2);
        }
        return new RubyComplex(context.getRuntime(), recv2, real2, RubyFixnum.zero(context.getRuntime()));
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv2, IRubyObject real2, IRubyObject image2) {
        if (!(real2 instanceof RubyNumeric)) {
            real2 = Numeric.f_to_i(context, real2);
        }
        if (!(image2 instanceof RubyNumeric)) {
            image2 = Numeric.f_to_i(context, image2);
        }
        return new RubyComplex(context.getRuntime(), recv2, real2, image2);
    }

    public static void setCanonicalization(boolean canonical) {
        canonicalization = canonical;
    }

    private static void realCheck(ThreadContext context, IRubyObject num) {
        switch (num.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: 
            case 21: {
                break;
            }
            default: {
                if (num instanceof RubyNumeric && Numeric.f_real_p(context, num).isTrue()) break;
                throw context.getRuntime().newArgumentError("not a real");
            }
        }
    }

    private static IRubyObject canonicalizeInternal(ThreadContext context, IRubyObject clazz, IRubyObject real2, IRubyObject image2) {
        if (Numeric.f_zero_p(context, image2) && Numeric.k_exact_p(image2) && canonicalization) {
            return real2;
        }
        if (Numeric.f_real_p(context, real2).isTrue() && Numeric.f_real_p(context, image2).isTrue()) {
            return new RubyComplex(context.getRuntime(), clazz, real2, image2);
        }
        if (Numeric.f_real_p(context, real2).isTrue()) {
            RubyComplex complex = (RubyComplex)image2;
            return new RubyComplex(context.getRuntime(), clazz, Numeric.f_sub(context, real2, complex.image), Numeric.f_add(context, RubyFixnum.zero(context.getRuntime()), complex.real));
        }
        if (Numeric.f_real_p(context, image2).isTrue()) {
            RubyComplex complex = (RubyComplex)real2;
            return new RubyComplex(context.getRuntime(), clazz, complex.real, Numeric.f_add(context, complex.image, image2));
        }
        RubyComplex complex1 = (RubyComplex)real2;
        RubyComplex complex2 = (RubyComplex)image2;
        return new RubyComplex(context.getRuntime(), clazz, Numeric.f_sub(context, complex1.real, complex2.image), Numeric.f_add(context, complex1.image, complex2.real));
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyComplex.newInstance(context, recv2, args2[0]);
            }
            case 2: {
                return RubyComplex.newInstance(context, recv2, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 1);
        return null;
    }

    public static IRubyObject newInstanceNew(ThreadContext context, IRubyObject recv2, IRubyObject real2) {
        return RubyComplex.newInstance(context, recv2, real2);
    }

    @JRubyMethod(name={"rect", "rectangular"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject real2) {
        RubyComplex.realCheck(context, real2);
        return RubyComplex.canonicalizeInternal(context, recv2, real2, RubyFixnum.zero(context.getRuntime()));
    }

    public static IRubyObject newInstanceNew(ThreadContext context, IRubyObject recv2, IRubyObject real2, IRubyObject image2) {
        return RubyComplex.newInstance(context, recv2, real2, image2);
    }

    @JRubyMethod(name={"rect", "rectangular"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject real2, IRubyObject image2) {
        RubyComplex.realCheck(context, real2);
        RubyComplex.realCheck(context, image2);
        return RubyComplex.canonicalizeInternal(context, recv2, real2, image2);
    }

    private static IRubyObject f_complex_polar(ThreadContext context, IRubyObject clazz, IRubyObject x, IRubyObject y) {
        assert (!(x instanceof RubyComplex) && !(y instanceof RubyComplex));
        return RubyComplex.canonicalizeInternal(context, clazz, Numeric.f_mul(context, x, RubyComplex.m_cos(context, y)), Numeric.f_mul(context, x, RubyComplex.m_sin(context, y)));
    }

    @JRubyMethod(name={"polar"}, meta=true)
    public static IRubyObject polar(ThreadContext context, IRubyObject clazz, IRubyObject abs3, IRubyObject arg2) {
        return RubyComplex.f_complex_polar(context, clazz, abs3, arg2);
    }

    @JRubyMethod(name={"polar"}, meta=true, required=1, optional=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject polar19(ThreadContext context, IRubyObject clazz, IRubyObject[] args2) {
        IRubyObject abs3 = args2[0];
        IRubyObject arg2 = args2.length < 2 ? RubyFixnum.zero(context.getRuntime()) : args2[1];
        RubyComplex.realCheck(context, abs3);
        RubyComplex.realCheck(context, arg2);
        return RubyComplex.f_complex_polar(context, clazz, abs3, arg2);
    }

    public static IRubyObject newComplexConvert(ThreadContext context, IRubyObject x) {
        return RubyComplex.newComplexConvert(context, x, RubyFixnum.zero(context.getRuntime()));
    }

    public static IRubyObject newComplexConvert(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyComplex.convert(context, context.getRuntime().getComplex(), x, y);
    }

    @Deprecated
    public static IRubyObject convert(ThreadContext context, IRubyObject clazz, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyComplex.convert(context, clazz, args2[0]);
            }
            case 2: {
                return RubyComplex.convert(context, clazz, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject a1) {
        return RubyComplex.convertCommon(context, recv2, a1, context.getRuntime().getNil());
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject a1, IRubyObject a2) {
        return RubyComplex.convertCommon(context, recv2, a1, a2);
    }

    private static IRubyObject convertCommon(ThreadContext context, IRubyObject recv2, IRubyObject a1, IRubyObject a2) {
        DynamicScope scope = context.getCurrentScope();
        IRubyObject backref = scope.getBackRef(context.getRuntime());
        if (backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        if (a1 instanceof RubyString) {
            a1 = RubyComplex.str_to_c_strict(context, a1);
        }
        if (a2 instanceof RubyString) {
            a2 = RubyComplex.str_to_c_strict(context, a2);
        }
        scope.setBackRef(backref);
        if (a1 instanceof RubyComplex) {
            RubyComplex a1Complex = (RubyComplex)a1;
            if (Numeric.k_exact_p(a1Complex.image) && Numeric.f_zero_p(context, a1Complex.image)) {
                a1 = a1Complex.real;
            }
        }
        if (a2 instanceof RubyComplex) {
            RubyComplex a2Complex = (RubyComplex)a2;
            if (Numeric.k_exact_p(a2Complex.image) && Numeric.f_zero_p(context, a2Complex.image)) {
                a2 = a2Complex.real;
            }
        }
        if (a1 instanceof RubyComplex && (a2.isNil() || Numeric.k_exact_p(a2) && Numeric.f_zero_p(context, a2))) {
            return a1;
        }
        if (a2.isNil()) {
            if (a1 instanceof RubyNumeric && !Numeric.f_real_p(context, a1).isTrue()) {
                return a1;
            }
            return RubyComplex.newInstance(context, recv2, a1);
        }
        if (a1 instanceof RubyNumeric && a2 instanceof RubyNumeric && (!Numeric.f_real_p(context, a1).isTrue() || !Numeric.f_real_p(context, a2).isTrue())) {
            Ruby runtime2 = context.getRuntime();
            return Numeric.f_add(context, a1, Numeric.f_mul(context, a2, RubyComplex.newComplexBang(context, runtime2.getComplex(), RubyFixnum.zero(runtime2), RubyFixnum.one(runtime2))));
        }
        return RubyComplex.newInstance(context, recv2, a1, a2);
    }

    @JRubyMethod(name={"real"})
    public IRubyObject real() {
        return this.real;
    }

    @JRubyMethod(name={"imaginary", "imag"})
    public IRubyObject image() {
        return this.image;
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject negate(ThreadContext context) {
        return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_negate(context, this.real), Numeric.f_negate(context, this.image));
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_add(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_add(context, this.real, otherComplex.real), Numeric.f_add(context, this.image, otherComplex.image));
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, other).isTrue()) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_add(context, this.real, other), this.image);
        }
        return this.coerceBin(context, "+", other);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_sub(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_sub(context, this.real, otherComplex.real), Numeric.f_sub(context, this.image, otherComplex.image));
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, other).isTrue()) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_sub(context, this.real, other), this.image);
        }
        return this.coerceBin(context, "-", other);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            IRubyObject realp = Numeric.f_sub(context, Numeric.f_mul(context, this.real, otherComplex.real), Numeric.f_mul(context, this.image, otherComplex.image));
            IRubyObject imagep = Numeric.f_add(context, Numeric.f_mul(context, this.real, otherComplex.image), Numeric.f_mul(context, this.image, otherComplex.real));
            return RubyComplex.newComplex(context, this.getMetaClass(), realp, imagep);
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, other).isTrue()) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_mul(context, this.real, other), Numeric.f_mul(context, this.image, other));
        }
        return this.coerceBin(context, "*", other);
    }

    @JRubyMethod(name={"/", "quo"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            if (this.real instanceof RubyFloat || this.image instanceof RubyFloat || otherComplex.real instanceof RubyFloat || otherComplex.image instanceof RubyFloat) {
                RubyFloat magn = RubyMath.hypot(this, otherComplex.real, otherComplex.image);
                RubyComplex tmp = RubyComplex.newComplexBang(context, this.getMetaClass(), Numeric.f_quo(context, otherComplex.real, magn), Numeric.f_quo(context, otherComplex.image, magn));
                return Numeric.f_quo(context, Numeric.f_mul(context, this, Numeric.f_conjugate(context, tmp)), magn);
            }
            return Numeric.f_quo(context, Numeric.f_mul(context, this, Numeric.f_conjugate(context, other)), Numeric.f_abs2(context, other));
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, other).isTrue()) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_quo(context, this.real, other), Numeric.f_quo(context, this.image, other));
        }
        return this.coerceBin(context, "/", other);
    }

    @JRubyMethod(name={"fdiv"})
    public IRubyObject fdiv(ThreadContext context, IRubyObject other) {
        IRubyObject complex = RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_to_f(context, this.real), Numeric.f_to_f(context, this.image));
        return Numeric.f_div(context, complex, other);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_expt(ThreadContext context, IRubyObject other) {
        if (Numeric.k_exact_p(other) && Numeric.f_zero_p(context, other)) {
            return RubyComplex.newComplexBang(context, this.getMetaClass(), RubyFixnum.one(context.getRuntime()));
        }
        if (other instanceof RubyRational && Numeric.f_one_p(context, Numeric.f_denominator(context, other))) {
            other = Numeric.f_numerator(context, other);
        }
        if (other instanceof RubyComplex) {
            RubyArray a = Numeric.f_polar(context, this).convertToArray();
            IRubyObject r = a.eltInternal(0);
            IRubyObject theta = a.eltInternal(1);
            RubyComplex otherComplex = (RubyComplex)other;
            RubyFloat nr = RubyMath.exp(this, Numeric.f_sub(context, Numeric.f_mul(context, otherComplex.real, RubyMath.log(this, r)), Numeric.f_mul(context, otherComplex.image, theta)));
            IRubyObject ntheta = Numeric.f_add(context, Numeric.f_mul(context, theta, otherComplex.real), Numeric.f_mul(context, otherComplex.image, RubyMath.log(this, r)));
            return RubyComplex.polar(context, this.getMetaClass(), nr, ntheta);
        }
        if (other instanceof RubyInteger) {
            RubyFixnum one = RubyFixnum.one(context.getRuntime());
            if (Numeric.f_gt_p(context, other, RubyFixnum.zero(context.getRuntime())).isTrue()) {
                IRubyObject x;
                IRubyObject z = x = this;
                IRubyObject n = Numeric.f_sub(context, other, one);
                RubyFixnum two = RubyFixnum.two(context.getRuntime());
                while (!Numeric.f_zero_p(context, n)) {
                    RubyArray a = Numeric.f_divmod(context, n, two).convertToArray();
                    while (Numeric.f_zero_p(context, a.eltInternal(1))) {
                        RubyComplex xComplex = x;
                        x = RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_sub(context, Numeric.f_mul(context, xComplex.real, xComplex.real), Numeric.f_mul(context, xComplex.image, xComplex.image)), Numeric.f_mul(context, Numeric.f_mul(context, two, xComplex.real), xComplex.image));
                        n = a.eltInternal(0);
                        a = Numeric.f_divmod(context, n, two).convertToArray();
                    }
                    z = Numeric.f_mul(context, z, x);
                    n = Numeric.f_sub(context, n, one);
                }
                return z;
            }
            return Numeric.f_expt(context, Numeric.f_div(context, Numeric.f_to_r(context, one), this), Numeric.f_negate(context, other));
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, other).isTrue()) {
            RubyArray a = Numeric.f_polar(context, this).convertToArray();
            IRubyObject r = a.eltInternal(0);
            IRubyObject theta = a.eltInternal(1);
            return RubyComplex.f_complex_polar(context, this.getMetaClass(), Numeric.f_expt(context, r, other), Numeric.f_mul(context, theta, other));
        }
        return this.coerceBin(context, "**", other);
    }

    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            boolean test2 = Numeric.f_equal(context, this.real, otherComplex.real).isTrue() && Numeric.f_equal(context, this.image, otherComplex.image).isTrue();
            return context.getRuntime().newBoolean(test2);
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, other).isTrue()) {
            boolean test3 = Numeric.f_equal(context, this.real, other).isTrue() && Numeric.f_zero_p(context, this.image);
            return context.getRuntime().newBoolean(test3);
        }
        return Numeric.f_equal(context, other, this);
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject coerce(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, other).isTrue()) {
            return context.getRuntime().newArray((IRubyObject)RubyComplex.newComplexBang(context, this.getMetaClass(), other), (IRubyObject)this);
        }
        throw context.getRuntime().newTypeError(other.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
    }

    @JRubyMethod(name={"abs", "magnitude"})
    public IRubyObject abs(ThreadContext context) {
        return RubyMath.hypot(this, this.real, this.image);
    }

    @JRubyMethod(name={"abs2"})
    public IRubyObject abs2(ThreadContext context) {
        return Numeric.f_add(context, Numeric.f_mul(context, this.real, this.real), Numeric.f_mul(context, this.image, this.image));
    }

    @JRubyMethod(name={"arg", "angle", "phase"})
    public IRubyObject arg(ThreadContext context) {
        return RubyMath.atan2(this, this.image, this.real);
    }

    @JRubyMethod(name={"rectangular", "rect"})
    public IRubyObject rect(ThreadContext context) {
        return context.getRuntime().newArray(this.real, this.image);
    }

    @JRubyMethod(name={"polar"})
    public IRubyObject polar(ThreadContext context) {
        return context.getRuntime().newArray(Numeric.f_abs(context, this), Numeric.f_arg(context, this));
    }

    @JRubyMethod(name={"conjugate", "conj", "~"})
    public IRubyObject conjugate(ThreadContext context) {
        return RubyComplex.newComplex(context, this.getMetaClass(), this.real, Numeric.f_negate(context, this.image));
    }

    @JRubyMethod(name={"real?"})
    public IRubyObject real_p(ThreadContext context) {
        return context.getRuntime().getFalse();
    }

    public IRubyObject complex_p(ThreadContext context) {
        return context.getRuntime().getTrue();
    }

    public IRubyObject exact_p(ThreadContext context) {
        return Numeric.f_exact_p(context, this.real).isTrue() && Numeric.f_exact_p(context, this.image).isTrue() ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    public IRubyObject inexact_p(ThreadContext context) {
        return this.exact_p(context).isTrue() ? context.getRuntime().getFalse() : context.getRuntime().getTrue();
    }

    @JRubyMethod(name={"denominator"})
    public IRubyObject demoninator(ThreadContext context) {
        return Numeric.f_lcm(context, Numeric.f_denominator(context, this.real), Numeric.f_denominator(context, this.image));
    }

    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        IRubyObject cd = this.callMethod(context, "denominator");
        return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_mul(context, Numeric.f_numerator(context, this.real), Numeric.f_div(context, cd, Numeric.f_denominator(context, this.real))), Numeric.f_mul(context, Numeric.f_numerator(context, this.image), Numeric.f_div(context, cd, Numeric.f_denominator(context, this.image))));
    }

    @JRubyMethod(name={"hash"})
    public IRubyObject hash(ThreadContext context) {
        return Numeric.f_xor(context, this.real.callMethod(context, "hash"), this.image.callMethod(context, "hash"));
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            if (this.real.getMetaClass() == otherComplex.real.getMetaClass() && this.image.getMetaClass() == otherComplex.image.getMetaClass() && Numeric.f_equal(context, this, otherComplex).isTrue()) {
                return context.getRuntime().getTrue();
            }
        }
        return context.getRuntime().getFalse();
    }

    private static boolean signbit(ThreadContext context, IRubyObject x) {
        if (x instanceof RubyFloat) {
            double value2 = ((RubyFloat)x).getDoubleValue();
            return !Double.isNaN(value2) && Double.doubleToLongBits(value2) < 0L;
        }
        return Numeric.f_negative_p(context, x);
    }

    private static boolean tpositive_p(ThreadContext context, IRubyObject x) {
        return !RubyComplex.signbit(context, x);
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        boolean impos = RubyComplex.tpositive_p(context, this.image);
        RubyString str = Numeric.f_to_s(context, this.real).convertToString();
        str.cat(impos ? (byte)43 : 45);
        str.cat(Numeric.f_to_s(context, Numeric.f_abs(context, this.image)).convertToString().getByteList());
        if (!RubyComplex.lastCharDigit(str)) {
            str.cat((byte)42);
        }
        str.cat((byte)105);
        return str;
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        boolean impos = RubyComplex.tpositive_p(context, this.image);
        RubyString str = context.getRuntime().newString();
        str.cat((byte)40);
        str.cat(Numeric.f_inspect(context, this.real).convertToString().getByteList());
        str.cat(impos ? (byte)43 : 45);
        str.cat(Numeric.f_inspect(context, Numeric.f_abs(context, this.image)).convertToString().getByteList());
        if (!RubyComplex.lastCharDigit(str)) {
            str.cat((byte)42);
        }
        str.cat((byte)105);
        str.cat((byte)41);
        return str;
    }

    private static boolean lastCharDigit(RubyString str) {
        ByteList bytes2 = str.getByteList();
        return ASCIIEncoding.INSTANCE.isDigit(bytes2.getUnsafeBytes()[bytes2.getBegin() + bytes2.getRealSize() - 1]);
    }

    @JRubyMethod(name={"marshal_dump"})
    public IRubyObject marshal_dump(ThreadContext context) {
        RubyArray dump2 = context.getRuntime().newArray(this.real, this.image);
        if (this.hasVariables()) {
            dump2.syncVariables(this.getVariableList());
        }
        return dump2;
    }

    @JRubyMethod(name={"marshal_load"})
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        RubyArray load2 = arg2.convertToArray();
        this.real = load2.size() > 0 ? load2.eltInternal(0) : context.getRuntime().getNil();
        IRubyObject iRubyObject = this.image = load2.size() > 1 ? load2.eltInternal(1) : context.getRuntime().getNil();
        if (load2.hasVariables()) {
            this.syncVariables(load2.getVariableList());
        }
        return this;
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i(ThreadContext context) {
        if (Numeric.k_inexact_p(this.image) || !Numeric.f_zero_p(context, this.image)) {
            throw context.getRuntime().newRangeError("can't convert " + Numeric.f_to_s(context, this).convertToString() + " into Integer");
        }
        return Numeric.f_to_i(context, this.real);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f(ThreadContext context) {
        if (Numeric.k_inexact_p(this.image) || !Numeric.f_zero_p(context, this.image)) {
            throw context.getRuntime().newRangeError("can't convert " + Numeric.f_to_s(context, this).convertToString() + " into Float");
        }
        return Numeric.f_to_f(context, this.real);
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        if (Numeric.k_inexact_p(this.image) || !Numeric.f_zero_p(context, this.image)) {
            throw context.getRuntime().newRangeError("can't convert " + Numeric.f_to_s(context, this).convertToString() + " into Rational");
        }
        return Numeric.f_to_r(context, this.real);
    }

    @JRubyMethod(name={"rationalize"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject rationalize(ThreadContext context, IRubyObject[] args2) {
        return this.to_r(context);
    }

    static RubyArray str_to_c_internal(ThreadContext context, IRubyObject recv2) {
        IRubyObject r;
        IRubyObject t;
        IRubyObject re;
        RubyString s = recv2.convertToString();
        ByteList bytes2 = s.getByteList();
        Ruby runtime2 = context.getRuntime();
        if (bytes2.getRealSize() == 0) {
            return runtime2.newArray(runtime2.getNil(), recv2);
        }
        IRubyObject si = re = runtime2.getNil();
        IRubyObject sr = re;
        boolean po = false;
        IRubyObject m = RubyRegexp.newDummyRegexp(runtime2, Numeric.ComplexPatterns.comp_pat0).callMethod(context, "match", (IRubyObject)s);
        if (!m.isNil()) {
            sr = m.callMethod(context, "[]", RubyFixnum.one(runtime2));
            si = m.callMethod(context, "[]", RubyFixnum.two(runtime2));
            re = m.callMethod(context, "post_match");
            po = true;
        }
        if (m.isNil() && !(m = RubyRegexp.newDummyRegexp(runtime2, Numeric.ComplexPatterns.comp_pat1).callMethod(context, "match", (IRubyObject)s)).isNil()) {
            sr = runtime2.getNil();
            si = m.callMethod(context, "[]", RubyFixnum.one(runtime2));
            if (si.isNil()) {
                si = runtime2.newString();
            }
            if ((t = m.callMethod(context, "[]", RubyFixnum.two(runtime2))).isNil()) {
                t = runtime2.newString(new ByteList(new byte[]{49}));
            }
            si.convertToString().cat(t.convertToString().getByteList());
            re = m.callMethod(context, "post_match");
            po = false;
        }
        if (m.isNil()) {
            m = RubyRegexp.newDummyRegexp(runtime2, Numeric.ComplexPatterns.comp_pat2).callMethod(context, "match", (IRubyObject)s);
            if (m.isNil()) {
                return runtime2.newArray(runtime2.getNil(), recv2);
            }
            sr = m.callMethod(context, "[]", RubyFixnum.one(runtime2));
            if (m.callMethod(context, "[]", RubyFixnum.two(runtime2)).isNil()) {
                si = runtime2.getNil();
            } else {
                si = m.callMethod(context, "[]", RubyFixnum.three(runtime2));
                t = m.callMethod(context, "[]", RubyFixnum.four(runtime2));
                if (t.isNil()) {
                    t = runtime2.newString(new ByteList(new byte[]{49}));
                }
                si.convertToString().cat(t.convertToString().getByteList());
            }
            re = m.callMethod(context, "post_match");
            po = false;
        }
        IRubyObject i = r = RubyFixnum.zero(runtime2);
        if (!sr.isNil()) {
            r = sr.callMethod(context, "include?", runtime2.newString(new ByteList(new byte[]{47}))).isTrue() ? Numeric.f_to_r(context, sr) : (Numeric.f_gt_p(context, sr.callMethod(context, "count", runtime2.newString(".eE")), RubyFixnum.zero(runtime2)).isTrue() ? Numeric.f_to_f(context, sr) : Numeric.f_to_i(context, sr));
        }
        if (!si.isNil()) {
            i = si.callMethod(context, "include?", runtime2.newString(new ByteList(new byte[]{47}))).isTrue() ? Numeric.f_to_r(context, si) : (Numeric.f_gt_p(context, si.callMethod(context, "count", runtime2.newString(".eE")), RubyFixnum.zero(runtime2)).isTrue() ? Numeric.f_to_f(context, si) : Numeric.f_to_i(context, si));
        }
        return runtime2.newArray(po ? RubyComplex.newComplexPolar(context, r, i) : RubyComplex.newComplexCanonicalize(context, r, i), re);
    }

    private static IRubyObject str_to_c_strict(ThreadContext context, IRubyObject recv2) {
        RubyArray a = RubyComplex.str_to_c_internal(context, recv2);
        if (a.eltInternal(0).isNil() || a.eltInternal(1).convertToString().getByteList().length() > 0) {
            IRubyObject s = recv2.callMethod(context, "inspect");
            throw context.getRuntime().newArgumentError("invalid value for convert(): " + s.convertToString());
        }
        return a.eltInternal(0);
    }
}

