/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.PrintStream;
import java.lang.reflect.Member;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"NativeException"}, parent="RuntimeError")
public class NativeException
extends RubyException {
    private final Throwable cause;
    public static final String CLASS_NAME = "NativeException";
    private final Ruby runtime;

    public NativeException(Ruby runtime2, RubyClass rubyClass, Throwable cause2) {
        super(runtime2, rubyClass, cause2.getClass().getName() + ": " + cause2.getMessage());
        this.runtime = runtime2;
        this.cause = cause2;
    }

    public static RubyClass createClass(Ruby runtime2, RubyClass baseClass) {
        RubyClass exceptionClass = runtime2.defineClass(CLASS_NAME, baseClass, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        exceptionClass.defineAnnotatedMethods(NativeException.class);
        return exceptionClass;
    }

    @JRubyMethod(frame=true)
    public IRubyObject cause(Block unusedBlock) {
        return Java.getInstance(this.getRuntime(), this.cause);
    }

    public IRubyObject backtrace() {
        IRubyObject rubyTrace = super.backtrace();
        if (rubyTrace.isNil()) {
            return rubyTrace;
        }
        RubyArray array = (RubyArray)rubyTrace.dup();
        StackTraceElement[] stackTrace = this.cause.getStackTrace();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            StackTraceElement element = stackTrace[i];
            String className = element.getClassName();
            String line = null;
            if (element.getFileName() == null) {
                line = className + ":" + element.getLineNumber() + ":in `" + element.getMethodName() + "'";
            } else {
                int index2 = className.lastIndexOf(".");
                String packageName = null;
                packageName = index2 == -1 ? "" : className.substring(0, index2) + "/";
                line = packageName.replace(".", "/") + element.getFileName() + ":" + element.getLineNumber() + ":in `" + element.getMethodName() + "'";
            }
            RubyString string2 = this.runtime.newString(line);
            array.unshift(string2);
        }
        return array;
    }

    public void trimStackTrace(Member target) {
        StackTraceElement b;
        StackTraceElement a;
        Throwable t = new Throwable();
        StackTraceElement[] origStackTrace = this.cause.getStackTrace();
        StackTraceElement[] currentStackTrace = t.getStackTrace();
        int skip2 = 0;
        for (int i = 1; i <= origStackTrace.length && i <= currentStackTrace.length && (a = origStackTrace[origStackTrace.length - i]).equals(b = currentStackTrace[currentStackTrace.length - i]); ++i) {
            ++skip2;
        }
        if (target != null) {
            String className = target.getDeclaringClass().getName();
            String methodName = target.getName();
            for (int i = origStackTrace.length - skip2 - 1; i >= 0; --i) {
                StackTraceElement frame = origStackTrace[i];
                if (!frame.getClassName().equals(className) || !frame.getMethodName().equals(methodName)) continue;
                skip2 = origStackTrace.length - i - 1;
                break;
            }
        }
        if (skip2 > 0) {
            StackTraceElement[] newStackTrace = new StackTraceElement[origStackTrace.length - skip2];
            for (int i = 0; i < newStackTrace.length; ++i) {
                newStackTrace[i] = origStackTrace[i];
            }
            this.cause.setStackTrace(newStackTrace);
        }
    }

    public void printBacktrace(PrintStream errorStream) {
        super.printBacktrace(errorStream);
        if (this.getRuntime().getDebug().isTrue()) {
            errorStream.println("Complete Java stackTrace");
            this.cause.printStackTrace(errorStream);
        }
    }

    public Throwable getCause() {
        return this.cause;
    }
}

