/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import com.kenai.jaffl.CallingConvention;
import com.kenai.jaffl.Library;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.struct.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jnr.netdb.Protocol;
import jnr.netdb.ProtocolsDB;
import jnr.netdb.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeProtocolsDB
implements ProtocolsDB {
    private final LibProto lib;

    public static final NativeProtocolsDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    NativeProtocolsDB(LibProto lib) {
        this.lib = lib;
    }

    private static final NativeProtocolsDB load() {
        try {
            LibProto lib;
            Platform.OS os = Platform.getPlatform().getOS();
            if (!(os.equals((Object)Platform.OS.DARWIN) || os.equals((Object)Platform.OS.WINDOWS) && Platform.getPlatform().getCPU() == Platform.CPU.I386 || os.equals((Object)Platform.OS.LINUX) || os.equals((Object)Platform.OS.SOLARIS) || os.equals((Object)Platform.OS.FREEBSD) || os.equals((Object)Platform.OS.NETBSD))) {
                return null;
            }
            if (os.equals((Object)Platform.OS.WINDOWS)) {
                HashMap<LibraryOption, CallingConvention> options2 = new HashMap<LibraryOption, CallingConvention>();
                options2.put(LibraryOption.CallingConvention, CallingConvention.STDCALL);
                lib = Library.loadLibrary(LibProto.class, options2, "Ws2_32");
            } else {
                String[] stringArray;
                if (os.equals((Object)Platform.OS.SOLARIS)) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "socket";
                    stringArray2[1] = "nsl";
                    stringArray = stringArray2;
                    stringArray2[2] = "c";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "c";
                }
                String[] libnames = stringArray;
                lib = Library.loadLibrary(LibProto.class, libnames);
            }
            lib.getprotobyname("ip");
            lib.getprotobynumber(0);
            return new NativeProtocolsDB(lib);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private final Protocol protocolFromNative(UnixProtoent p2) {
        if (p2 == null) {
            return null;
        }
        List emptyAliases = Collections.emptyList();
        Pointer ptr = p2.aliases.get();
        List<String> aliases2 = ptr != null ? StringUtil.getNullTerminatedStringArray(ptr) : emptyAliases;
        return new Protocol(p2.name.get(), (short)p2.proto.get(), aliases2);
    }

    @Override
    public Protocol getProtocolByName(String name2) {
        return this.protocolFromNative(this.lib.getprotobyname(name2));
    }

    @Override
    public Protocol getProtocolByNumber(Integer proto) {
        return this.protocolFromNative(this.lib.getprotobynumber(proto));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Protocol> getAllProtocols() {
        ArrayList<Protocol> allProtocols = new ArrayList<Protocol>();
        try {
            UnixProtoent p2;
            while ((p2 = this.lib.getprotoent()) != null) {
                allProtocols.add(this.protocolFromNative(p2));
            }
        }
        finally {
            this.lib.endprotoent();
        }
        return allProtocols;
    }

    static /* synthetic */ NativeProtocolsDB access$000() {
        return NativeProtocolsDB.load();
    }

    public static interface LibProto {
        public UnixProtoent getprotobyname(String var1);

        public UnixProtoent getprotobynumber(int var1);

        public UnixProtoent getprotoent();

        public void endprotoent();
    }

    public static class UnixProtoent
    extends Struct {
        public final Struct.String name = new Struct.UTF8StringRef();
        public final Struct.Pointer aliases = new Struct.Pointer();
        public final Struct.Signed32 proto = new Struct.Signed32();
    }

    private static final class SingletonHolder {
        public static final NativeProtocolsDB INSTANCE = NativeProtocolsDB.access$000();

        private SingletonHolder() {
        }
    }
}

