/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallInfo;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Function;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.ObjectBuffer;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.nio.Buffer;
import java.nio.ByteOrder;

public final class HeapInvocationBuffer
implements InvocationBuffer {
    private static final int FFI_SIZEOF_ARG = Platform.getPlatform().addressSize() / 8;
    private static final int PARAM_SIZE = 8;
    private static final Encoder encoder = HeapInvocationBuffer.getEncoder();
    private final CallInfo info;
    private final byte[] buffer;
    private ObjectBuffer objectBuffer = null;
    private int paramOffset = 0;
    private int paramIndex = 0;

    public HeapInvocationBuffer(CallInfo info) {
        this.info = info;
        this.buffer = new byte[encoder.getBufferSize(info)];
    }

    public HeapInvocationBuffer(Function function) {
        this.info = function;
        this.buffer = new byte[encoder.getBufferSize(function)];
    }

    byte[] array() {
        return this.buffer;
    }

    ObjectBuffer objectBuffer() {
        return this.objectBuffer;
    }

    public final void putByte(int value2) {
        this.paramOffset = encoder.putByte(this.buffer, this.paramOffset, value2);
        ++this.paramIndex;
    }

    public final void putShort(int value2) {
        this.paramOffset = encoder.putShort(this.buffer, this.paramOffset, value2);
        ++this.paramIndex;
    }

    public final void putInt(int value2) {
        this.paramOffset = encoder.putInt(this.buffer, this.paramOffset, value2);
        ++this.paramIndex;
    }

    public final void putLong(long value2) {
        this.paramOffset = encoder.putLong(this.buffer, this.paramOffset, value2);
        ++this.paramIndex;
    }

    public final void putFloat(float value2) {
        this.paramOffset = encoder.putFloat(this.buffer, this.paramOffset, value2);
        ++this.paramIndex;
    }

    public final void putDouble(double value2) {
        this.paramOffset = encoder.putDouble(this.buffer, this.paramOffset, value2);
        ++this.paramIndex;
    }

    public final void putAddress(long value2) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, value2);
        ++this.paramIndex;
    }

    private final ObjectBuffer getObjectBuffer() {
        if (this.objectBuffer == null) {
            this.objectBuffer = new ObjectBuffer();
        }
        return this.objectBuffer;
    }

    public final void putArray(byte[] array, int offset2, int length2, int flags) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset2, length2, flags);
    }

    public final void putArray(short[] array, int offset2, int length2, int flags) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset2, length2, flags);
    }

    public final void putArray(int[] array, int offset2, int length2, int flags) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset2, length2, flags);
    }

    public final void putArray(long[] array, int offset2, int length2, int flags) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset2, length2, flags);
    }

    public final void putArray(float[] array, int offset2, int length2, int flags) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset2, length2, flags);
    }

    public final void putArray(double[] array, int offset2, int length2, int flags) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset2, length2, flags);
    }

    public final void putDirectBuffer(Buffer value2, int offset2, int length2) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putDirectBuffer(this.paramIndex++, value2, offset2, length2);
    }

    public final void putStruct(byte[] struct, int offset2) {
        Type type2 = this.info.getParameterType(this.paramIndex);
        if (encoder.isRaw()) {
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset, type2.alignment());
            System.arraycopy(struct, offset2, this.buffer, this.paramOffset, type2.size());
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset + type2.size(), FFI_SIZEOF_ARG);
        } else {
            this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
            this.getObjectBuffer().putArray(this.paramIndex, struct, offset2, type2.size(), 1);
        }
        ++this.paramIndex;
    }

    public final void putStruct(long struct) {
        Type type2 = this.info.getParameterType(this.paramIndex);
        if (encoder.isRaw()) {
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset, type2.alignment());
            MemoryIO.getInstance().getByteArray(struct, this.buffer, this.paramOffset, type2.size());
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset + type2.size(), FFI_SIZEOF_ARG);
        } else {
            this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, struct);
        }
        ++this.paramIndex;
    }

    public final void putJNIEnvironment() {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putJNI(this.paramIndex++, 0x1000000);
    }

    private static final Encoder getEncoder() {
        if (Platform.getPlatform().getCPU() == Platform.CPU.I386) {
            return Foreign.getInstance().isRawParameterPackingEnabled() ? HeapInvocationBuffer.newI386RawEncoder() : HeapInvocationBuffer.newLE32Encoder();
        }
        if (Platform.getPlatform().addressSize() == 64) {
            return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? HeapInvocationBuffer.newBE64Encoder() : HeapInvocationBuffer.newLE64Encoder();
        }
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? HeapInvocationBuffer.newBE32Encoder() : HeapInvocationBuffer.newLE32Encoder();
    }

    private static final Encoder newI386RawEncoder() {
        return new I386RawEncoder();
    }

    private static final Encoder newLE32Encoder() {
        return new DefaultEncoder(LE32ArrayIO.INSTANCE);
    }

    private static final Encoder newLE64Encoder() {
        return new DefaultEncoder(LE64ArrayIO.INSTANCE);
    }

    private static final Encoder newBE32Encoder() {
        return new DefaultEncoder(BE32ArrayIO.INSTANCE);
    }

    private static final Encoder newBE64Encoder() {
        return new DefaultEncoder(BE64ArrayIO.INSTANCE);
    }

    private static final int FFI_ALIGN(int v, int a) {
        return (v - 1 | a - 1) + 1;
    }

    private static final class BE64ArrayIO
    extends BigEndianArrayIO {
        static final ArrayIO INSTANCE = new BE64ArrayIO();

        private BE64ArrayIO() {
        }

        public void putAddress(byte[] buffer, int offset2, long value2) {
            this.putLong(buffer, offset2, value2);
        }
    }

    private static final class BE32ArrayIO
    extends BigEndianArrayIO {
        static final ArrayIO INSTANCE = new BE32ArrayIO();

        private BE32ArrayIO() {
        }

        public void putAddress(byte[] buffer, int offset2, long value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 24);
            buffer[offset2 + 1] = (byte)(value2 >> 16);
            buffer[offset2 + 2] = (byte)(value2 >> 8);
            buffer[offset2 + 3] = (byte)value2;
        }
    }

    private static abstract class BigEndianArrayIO
    extends ArrayIO {
        private BigEndianArrayIO() {
        }

        public final void putByte(byte[] buffer, int offset2, int value2) {
            buffer[offset2] = (byte)value2;
        }

        public final void putShort(byte[] buffer, int offset2, int value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 8);
            buffer[offset2 + 1] = (byte)value2;
        }

        public final void putInt(byte[] buffer, int offset2, int value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 24);
            buffer[offset2 + 1] = (byte)(value2 >> 16);
            buffer[offset2 + 2] = (byte)(value2 >> 8);
            buffer[offset2 + 3] = (byte)value2;
        }

        public final void putLong(byte[] buffer, int offset2, long value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 56);
            buffer[offset2 + 1] = (byte)(value2 >> 48);
            buffer[offset2 + 2] = (byte)(value2 >> 40);
            buffer[offset2 + 3] = (byte)(value2 >> 32);
            buffer[offset2 + 4] = (byte)(value2 >> 24);
            buffer[offset2 + 5] = (byte)(value2 >> 16);
            buffer[offset2 + 6] = (byte)(value2 >> 8);
            buffer[offset2 + 7] = (byte)value2;
        }
    }

    private static final class LE64ArrayIO
    extends LittleEndianArrayIO {
        static final ArrayIO INSTANCE = new LE64ArrayIO();

        private LE64ArrayIO() {
        }

        public final void putAddress(byte[] buffer, int offset2, long value2) {
            this.putLong(buffer, offset2, value2);
        }
    }

    private static final class LE32ArrayIO
    extends LittleEndianArrayIO {
        static final ArrayIO INSTANCE = new LE32ArrayIO();

        private LE32ArrayIO() {
        }

        public final void putAddress(byte[] buffer, int offset2, long value2) {
            buffer[offset2] = (byte)value2;
            buffer[offset2 + 1] = (byte)(value2 >> 8);
            buffer[offset2 + 2] = (byte)(value2 >> 16);
            buffer[offset2 + 3] = (byte)(value2 >> 24);
        }
    }

    private static abstract class LittleEndianArrayIO
    extends ArrayIO {
        private LittleEndianArrayIO() {
        }

        public final void putByte(byte[] buffer, int offset2, int value2) {
            buffer[offset2] = (byte)value2;
        }

        public final void putShort(byte[] buffer, int offset2, int value2) {
            buffer[offset2] = (byte)value2;
            buffer[offset2 + 1] = (byte)(value2 >> 8);
        }

        public final void putInt(byte[] buffer, int offset2, int value2) {
            buffer[offset2] = (byte)value2;
            buffer[offset2 + 1] = (byte)(value2 >> 8);
            buffer[offset2 + 2] = (byte)(value2 >> 16);
            buffer[offset2 + 3] = (byte)(value2 >> 24);
        }

        public final void putLong(byte[] buffer, int offset2, long value2) {
            buffer[offset2] = (byte)value2;
            buffer[offset2 + 1] = (byte)(value2 >> 8);
            buffer[offset2 + 2] = (byte)(value2 >> 16);
            buffer[offset2 + 3] = (byte)(value2 >> 24);
            buffer[offset2 + 4] = (byte)(value2 >> 32);
            buffer[offset2 + 5] = (byte)(value2 >> 40);
            buffer[offset2 + 6] = (byte)(value2 >> 48);
            buffer[offset2 + 7] = (byte)(value2 >> 56);
        }
    }

    private static abstract class ArrayIO {
        private ArrayIO() {
        }

        public abstract void putByte(byte[] var1, int var2, int var3);

        public abstract void putShort(byte[] var1, int var2, int var3);

        public abstract void putInt(byte[] var1, int var2, int var3);

        public abstract void putLong(byte[] var1, int var2, long var3);

        public final void putFloat(byte[] buffer, int offset2, float value2) {
            this.putInt(buffer, offset2, Float.floatToRawIntBits(value2));
        }

        public final void putDouble(byte[] buffer, int offset2, double value2) {
            this.putLong(buffer, offset2, Double.doubleToRawLongBits(value2));
        }

        public abstract void putAddress(byte[] var1, int var2, long var3);
    }

    private static final class DefaultEncoder
    extends Encoder {
        private final ArrayIO io;

        public DefaultEncoder(ArrayIO io2) {
            this.io = io2;
        }

        public final boolean isRaw() {
            return false;
        }

        public final int getBufferSize(CallInfo info) {
            return info.getParameterCount() * 8;
        }

        public final int putByte(byte[] buffer, int offset2, int value2) {
            this.io.putByte(buffer, offset2, value2);
            return offset2 + 8;
        }

        public final int putShort(byte[] buffer, int offset2, int value2) {
            this.io.putShort(buffer, offset2, value2);
            return offset2 + 8;
        }

        public final int putInt(byte[] buffer, int offset2, int value2) {
            this.io.putInt(buffer, offset2, value2);
            return offset2 + 8;
        }

        public final int putLong(byte[] buffer, int offset2, long value2) {
            this.io.putLong(buffer, offset2, value2);
            return offset2 + 8;
        }

        public final int putFloat(byte[] buffer, int offset2, float value2) {
            this.io.putFloat(buffer, offset2, value2);
            return offset2 + 8;
        }

        public final int putDouble(byte[] buffer, int offset2, double value2) {
            this.io.putDouble(buffer, offset2, value2);
            return offset2 + 8;
        }

        public final int putAddress(byte[] buffer, int offset2, long value2) {
            this.io.putAddress(buffer, offset2, value2);
            return offset2 + 8;
        }
    }

    private static final class I386RawEncoder
    extends Encoder {
        private static final ArrayIO IO = LE32ArrayIO.INSTANCE;

        private I386RawEncoder() {
        }

        public final boolean isRaw() {
            return true;
        }

        public final int getBufferSize(CallInfo info) {
            return info.getRawParameterSize();
        }

        public final int putByte(byte[] buffer, int offset2, int value2) {
            IO.putByte(buffer, offset2, value2);
            return offset2 + 4;
        }

        public final int putShort(byte[] buffer, int offset2, int value2) {
            IO.putShort(buffer, offset2, value2);
            return offset2 + 4;
        }

        public final int putInt(byte[] buffer, int offset2, int value2) {
            IO.putInt(buffer, offset2, value2);
            return offset2 + 4;
        }

        public final int putLong(byte[] buffer, int offset2, long value2) {
            IO.putLong(buffer, offset2, value2);
            return offset2 + 8;
        }

        public final int putFloat(byte[] buffer, int offset2, float value2) {
            IO.putFloat(buffer, offset2, value2);
            return offset2 + 4;
        }

        public final int putDouble(byte[] buffer, int offset2, double value2) {
            IO.putDouble(buffer, offset2, value2);
            return offset2 + 8;
        }

        public final int putAddress(byte[] buffer, int offset2, long value2) {
            IO.putAddress(buffer, offset2, value2);
            return offset2 + 4;
        }
    }

    private static abstract class Encoder {
        private Encoder() {
        }

        public abstract boolean isRaw();

        public abstract int getBufferSize(CallInfo var1);

        public abstract int putByte(byte[] var1, int var2, int var3);

        public abstract int putShort(byte[] var1, int var2, int var3);

        public abstract int putInt(byte[] var1, int var2, int var3);

        public abstract int putLong(byte[] var1, int var2, long var3);

        public abstract int putFloat(byte[] var1, int var2, float var3);

        public abstract int putDouble(byte[] var1, int var2, double var3);

        public abstract int putAddress(byte[] var1, int var2, long var3);
    }
}

