/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.HashNameAnalyzer;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.MethodElement;
import org.netbeans.modules.ruby.options.TypeInferenceSettings;
import org.openide.filesystems.FileObject;

public final class RubyIndexerHelper {
    public static final int DEFAULT_DOC = 0;
    public static final int NODOC = 1;
    public static final int DOC = 2;
    public static final int NODOC_ALL = 3;
    public static final String HASH_KEY_BOOL = "bool";
    public static final String HASH_KEY_STRING = "string";
    public static final String HASH_KEY_INTEGER = "string";

    private RubyIndexerHelper() {
    }

    public static String getMethodSignature(AstElement child, int flags, String signature, FileObject fo, ContextKnowledge knowledge) {
        if (knowledge.getParserResult().getSnapshot() == null) {
            return signature;
        }
        ParserResult parserResult = knowledge.getParserResult();
        Node root = knowledge.getRoot();
        try {
            MethodDefNode method;
            int docIndex;
            int nodocIndex;
            String line2;
            String hashNames = "";
            int originalFlags = flags;
            List<String> rdocs = null;
            if (RubyIndexerHelper.isRubyStubs(fo)) {
                rdocs = RubyIndexerHelper.getCallSeq(child, parserResult.getSnapshot());
            } else if (TypeInferenceSettings.getDefault().getRdocTypeInference()) {
                rdocs = AstUtilities.gatherDocumentation(parserResult.getSnapshot(), child.getNode());
            }
            ArrayList<Node> calls = new ArrayList<Node>();
            AstUtilities.addNodesByType(child.getNode(), new NodeType[]{NodeType.FCALLNODE}, calls);
            boolean optionalBlock = false;
            for (Node call : calls) {
                if (!"block_given?".equals(((FCallNode)call).getName())) continue;
                optionalBlock = true;
                break;
            }
            String blockArgs = null;
            if (rdocs != null) {
                boolean seenBlock = false;
                boolean seenNonBlock = false;
                for (String line2 : rdocs) {
                    boolean seenLeftParen = false;
                    boolean seenRightParen = false;
                    boolean hasBlock = false;
                    for (int i = 0; i < line2.length(); ++i) {
                        int blockEnd;
                        int blockBegin;
                        char c = line2.charAt(i);
                        if (c == '(') {
                            seenLeftParen = true;
                            continue;
                        }
                        if (c == ')') {
                            seenRightParen = true;
                            continue;
                        }
                        if (c != '{' || (seenLeftParen || seenRightParen) && (!seenLeftParen || !seenRightParen)) continue;
                        hasBlock = true;
                        if (blockArgs != null || (blockBegin = line2.indexOf(124, i + 1)) == -1 || (blockEnd = line2.indexOf(124, blockBegin + 1)) == -1) break;
                        StringBuilder sb = new StringBuilder();
                        for (int j = blockBegin; j < blockEnd; ++j) {
                            char d = line2.charAt(j);
                            if (!Character.isLetter(d) && d != ',') continue;
                            sb.append(d);
                        }
                        if (sb.length() <= 0) break;
                        blockArgs = sb.toString();
                        break;
                    }
                    if (hasBlock) {
                        seenBlock = true;
                        continue;
                    }
                    seenNonBlock = true;
                }
                if (seenBlock) {
                    if (blockArgs == null) {
                        blockArgs = "";
                    }
                    if (seenNonBlock) {
                        optionalBlock = true;
                    }
                }
            }
            Snapshot snapshot = parserResult.getSnapshot();
            int lineStart = GsfUtilities.getRowStart((CharSequence)snapshot.getText(), (int)child.getNode().getPosition().getStartOffset());
            int lineEnd = GsfUtilities.getRowEnd((CharSequence)snapshot.getText(), (int)lineStart);
            line2 = ((Object)snapshot.getText().subSequence(lineStart, lineEnd)).toString();
            int rdocYieldIdx = line2.indexOf(":yield:");
            if (rdocYieldIdx == -1) {
                rdocYieldIdx = line2.indexOf(":yields:");
                if (rdocYieldIdx != -1) {
                    rdocYieldIdx += ":yields:".length();
                }
            } else {
                rdocYieldIdx += ":yield:".length();
            }
            if (rdocYieldIdx != -1) {
                StringBuilder sb = new StringBuilder();
                for (int i = rdocYieldIdx; i < line2.length(); ++i) {
                    char c = line2.charAt(i);
                    if (c == '+' || Character.isWhitespace(c)) continue;
                    sb.append(c);
                }
                blockArgs = sb.toString();
            }
            if ((nodocIndex = line2.indexOf(":nodoc:")) != -1) {
                flags |= 0x20;
            }
            if ((docIndex = line2.indexOf(":doc:")) != -1) {
                flags &= 0xFFFFFFDF;
            }
            String name = child.getName();
            if (blockArgs == null) {
                if ("each".equals(name)) {
                    blockArgs = "";
                } else if (name.startsWith("each_")) {
                    blockArgs = name.substring("each_".length());
                } else if (child instanceof MethodElement) {
                    int paramCount;
                    MethodElement me = (MethodElement)((Object)child);
                    List<String> params = me.getParameters();
                    int n = paramCount = params != null ? params.size() : 0;
                    if (paramCount > 0 && params.get(paramCount - 1).startsWith("&")) {
                        blockArgs = "";
                    }
                }
            }
            if (optionalBlock) {
                flags |= 0x40;
                flags |= 0x80;
            } else if (blockArgs != null) {
                flags |= 0x40;
            }
            int attributeIndex = signature.indexOf(59);
            if (flags != originalFlags || attributeIndex == -1) {
                char first = IndexedElement.flagToFirstChar(flags);
                char second = IndexedElement.flagToSecondChar(flags);
                signature = attributeIndex == -1 ? signature + ";" + first + second : signature.substring(0, attributeIndex + 1) + first + second + signature.substring(attributeIndex + 3);
            }
            if (blockArgs == null) {
                blockArgs = "";
            }
            if (child.getNode() instanceof MethodDefNode && (hashNames = RubyIndexerHelper.getAttribute(fo, root, method = (MethodDefNode)child.getNode())) == null && rdocs != null && child instanceof MethodElement) {
                MethodElement me = (MethodElement)((Object)child);
                boolean match = false;
                for (String param : me.getParameters()) {
                    if (!param.startsWith("*")) continue;
                    hashNames = HashNameAnalyzer.collect(param.substring(1), rdocs);
                    match = true;
                    break;
                }
                if (!match && me.getParameters().contains("options")) {
                    hashNames = HashNameAnalyzer.collect("options", rdocs);
                    match = true;
                }
            }
            if (hashNames == null) {
                hashNames = "";
            } else {
                int paren;
                int offset = 0;
                while ((paren = hashNames.indexOf(40, offset)) != -1) {
                    paren = hashNames.indexOf(41, paren);
                    assert (paren != -1);
                    offset = paren;
                }
            }
            RubyType returnType = child.getType();
            if (blockArgs.length() > 0 || returnType.isKnown() || hashNames.length() > 0) {
                return signature + ";" + blockArgs + ";" + returnType.asIndexedString() + ";" + hashNames;
            }
            return signature;
        }
        catch (BadLocationException ble) {
            return signature;
        }
    }

    public static int isNodocClass(AstElement child, Snapshot snapshot) {
        if (snapshot == null) {
            return 0;
        }
        try {
            int start = child.getNode().getPosition().getStartOffset();
            if (start > snapshot.getText().length()) {
                return 0;
            }
            int lineStart = GsfUtilities.getRowStart((CharSequence)snapshot.getText(), (int)start);
            int lineEnd = GsfUtilities.getRowEnd((CharSequence)snapshot.getText(), (int)lineStart);
            String line = ((Object)snapshot.getText().subSequence(lineStart, lineEnd)).toString();
            int nodocIndex = line.indexOf(":nodoc:");
            if (nodocIndex != -1) {
                if (line.indexOf("all", nodocIndex) != -1) {
                    return 3;
                }
                return 1;
            }
            int docIndex = line.indexOf(":doc:");
            if (docIndex != -1) {
                return 2;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }

    private static boolean endsWithIgnSpace(String s, String ending) {
        int si = s.length() - 1;
        int ei = ending.length() - 1;
        while (ei >= 0) {
            char b;
            while (si >= 0 && Character.isWhitespace(s.charAt(si))) {
                --si;
            }
            if (si < 0) {
                return false;
            }
            char a = Character.toLowerCase(s.charAt(si));
            if (a != (b = Character.toLowerCase(ending.charAt(ei))) && a != '=' && (a != '-' || b != '=' && b != '-')) {
                return false;
            }
            --ei;
            --si;
        }
        return true;
    }

    private static List<String> getCallSeq(AstElement child, Snapshot snapshot) {
        ArrayList<String> callseq = null;
        List<String> comments = AstUtilities.gatherDocumentation(snapshot, child.getNode());
        if (comments == null) {
            return null;
        }
        for (int i = 0; i < comments.size(); ++i) {
            String line = comments.get(i);
            if (line.startsWith("#   ") && line.substring(1).trim().length() != 0) continue;
            if (i <= 0) break;
            callseq = new ArrayList<String>(i);
            for (int j = 0; j < i; ++j) {
                callseq.add(comments.get(j));
            }
            break;
        }
        return callseq;
    }

    private static boolean isRubyStubs(FileObject fo) {
        return fo.getParent() != null && fo.getParent().getParent() != null && "rubystubs".equals(fo.getParent().getParent().getName());
    }

    static String replaceAttributes(String signature, int flags) {
        int attributeIndex = signature.indexOf(59);
        if (attributeIndex == -1) {
            char first = IndexedElement.flagToFirstChar(flags);
            char second = IndexedElement.flagToSecondChar(flags);
            signature = attributeIndex == -1 ? signature + ";" + first + second : signature.substring(0, attributeIndex + 1) + first + second + signature.substring(attributeIndex + 3);
        }
        return signature;
    }

    static String getMethodSignatureForUserSources(AstElement methodElement, String signature, int flags, ContextKnowledge knowledge) {
        RubyType type = methodElement.getType();
        if (type.isKnown()) {
            return signature + ";;" + type.asIndexedString() + ";";
        }
        return signature;
    }

    private static String clz(Node root, Node n) {
        AstPath path = new AstPath(root, n);
        String clz = AstUtilities.getFqnName(path);
        return clz;
    }

    private static String sig(MethodDefNode method) {
        return AstUtilities.getDefSignature(method);
    }

    private static String getAttribute(FileObject file, Node root, MethodDefNode method) {
        String n = file.getName();
        if (n.length() < 2) {
            return null;
        }
        char c = n.charAt(0);
        switch (c) {
            case 'a': {
                if ("active_record_helper".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActionView::Helpers::ActiveRecordHelper".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("form(")) {
                            return "options(action:action)";
                        }
                        if (sig.startsWith("error_messages_for(")) {
                            return "params(=>header_tag|id|class|object_name)";
                        }
                        return null;
                    }
                    return null;
                }
                if ("aggregations".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActiveRecord::Aggregations::ClassMethods".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("composed_of(")) {
                            return "options(=>class_name|mapping|allow_nil:bool)";
                        }
                        return null;
                    }
                    return null;
                }
                if ("asset_tag_helper".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActionView::Helpers::AssetTagHelper".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("auto_discovery_link_tag(")) {
                            return "type(:rss|:atom),tag_options(=>rel|type|title),url_options(=>anchor|only_path:bool|controller:controller|action:action|trailing_slash:bool|host|protocol)";
                        }
                        if (sig.startsWith("image_tag(")) {
                            return "options(=>alt|size)";
                        }
                        return null;
                    }
                    return null;
                }
                if (!"associations".equals(n)) break;
                String clz = RubyIndexerHelper.clz(root, (Node)method);
                if ("ActiveRecord::Associations::ClassMethods".equals(clz)) {
                    String sig = RubyIndexerHelper.sig(method);
                    if (sig.startsWith("has_many(")) {
                        return "options(=>class_name|conditions|order|group|foreign_key|dependent|exclusively_dependent|finder_sql|counter_sql|extend|include|limit|offset|select|as|through|source|source_type|uniq),association_id(-table)";
                    }
                    if (sig.startsWith("has_one(")) {
                        return "options(=>class_name|conditions|order|dependent|foreign_key|include|as)),association_id(-model)";
                    }
                    if (sig.startsWith("belongs_to(")) {
                        return "options(=>class_name|conditions|foreign_key|counter_cache|include|polymorphic)),association_id(-model)";
                    }
                    if (sig.startsWith("has_and_belongs_to_many(")) {
                        return "options(=>class_name|join_table|foreign_key|association_foreign_key|conditions|order|uniq:bool|finder_sql|delete_sql|insert_sql|extend|include|group|limit|offset|select)),association_id(-table)";
                    }
                    return null;
                }
                return null;
            }
            case 'b': {
                if ("base".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActiveRecord::Base".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("find(")) {
                            return "args(:first|:all),args(=>conditions|order|group|limit|offset|joins|readonly:bool|include|select|from|readonly:bool|lock:bool)";
                        }
                        return null;
                    }
                    if ("ActionController::Base".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("url_for(")) {
                            return "options(=>anchor|only_path:bool|controller:controller|action:action|trailing_slash:bool|host|protocol)";
                        }
                        if (sig.startsWith("redirect_to(")) {
                            return "options(=>anchor|only_path:bool|controller:controller|action:action|trailing_slash:bool|host|protocol),options(:back|\"http://)";
                        }
                        if (sig.startsWith("render(")) {
                            return "options(=>action:action|partial:partial|status:status|template|file:file|text:string|json|inline|nothing)";
                        }
                        if (sig.startsWith("render_to_string(")) {
                            return "options(=>action:action|partial:partial|status:status|template|file:file|text:string|json|inline|nothing)";
                        }
                        return null;
                    }
                    return null;
                }
                if (!"benchmark_helper".equals(n)) break;
                String clz = RubyIndexerHelper.clz(root, (Node)method);
                if ("ActionView::Helpers::BenchmarkHelper".equals(clz)) {
                    String sig = RubyIndexerHelper.sig(method);
                    if (sig.startsWith("benchmark(")) {
                        return "level(:debug|:info|:warn|:error)";
                    }
                    return null;
                }
                return null;
            }
            case 'c': {
                if ("calculations".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActiveRecord::Calculations::ClassMethods".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("calculate(")) {
                            return "options(=>conditions|joins|order|group|select|distinct:bool),operation(:count|:avg|:min|:max|:sum),column_name(-column)";
                        }
                        if (sig.startsWith("count(")) {
                            return "args(=>conditions|joins|include|order|group|select|distinct:bool)";
                        }
                        if (sig.startsWith("minimum(")) {
                            return "options(=>conditions|joins|order|group|select|distinct:bool),column_name(-column)";
                        }
                        if (sig.startsWith("average(")) {
                            return "options(=>conditions|joins|order|group|select|distinct:bool),column_name(-column)";
                        }
                        if (sig.startsWith("sum(")) {
                            return "options(=>conditions|joins|order|group|select|distinct:bool),column_name(-column)";
                        }
                        if (sig.startsWith("maximum(")) {
                            return "options(=>conditions|joins|order|group|select|distinct:bool),column_name(-column)";
                        }
                        return null;
                    }
                    return null;
                }
                if (!"cgi_process".equals(n)) break;
                String clz = RubyIndexerHelper.clz(root, (Node)method);
                if ("ActionController::Base".equals(clz)) {
                    String sig = RubyIndexerHelper.sig(method);
                    if (sig.startsWith("process_cgi(")) {
                        return "session_options(=>database_manager|session_key|session_id|new_session|session_expires|session_domain|session_secure|session_path)";
                    }
                    return null;
                }
                return null;
            }
            case 'd': {
                if (!"date_helper".equals(n)) break;
                String clz = RubyIndexerHelper.clz(root, (Node)method);
                if ("ActionView::Helpers::DateHelper".equals(clz)) {
                    String sig = RubyIndexerHelper.sig(method);
                    if (sig.startsWith("date_select(")) {
                        return "options(=>discard_year:bool|discard_month:bool|discard_day:bool|order|disabled:bool)";
                    }
                    if (sig.startsWith("time_select(")) {
                        return "options(=>include_seconds:bool)";
                    }
                    return null;
                }
                return null;
            }
            case 'f': {
                if ("form_helper".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActionView::Helpers::FormHelper".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("form_for(")) {
                            String path = file.getPath();
                            if (path.indexOf("-2") != -1 || path.indexOf("-1") == -1) {
                                return "record_or_name_or_array(-model),(rgs=>url:hash|html:hash|builder)";
                            }
                            return "object_name(-model),args(=>url:hash|html:hash|builder)";
                        }
                        if (sig.startsWith("fields_for(")) {
                            String path = file.getPath();
                            if (path.indexOf("-2") != -1 || path.indexOf("-1") == -1) {
                                return "record_or_name_or_array(-model),args(=>url:hash)";
                            }
                            return "object_name(-model),args(=>url:hash)";
                        }
                        if (sig.startsWith("text_field(")) {
                            String path = file.getPath();
                            if (path.indexOf("-2") != -1 || path.indexOf("-1") == -1) {
                                return "record_or_name_or_array(-model)";
                            }
                            return "object_name(-model)";
                        }
                        if (sig.startsWith("password_field(")) {
                            String path = file.getPath();
                            if (path.indexOf("-2") != -1 || path.indexOf("-1") == -1) {
                                return "record_or_name_or_array(-model)";
                            }
                            return "object_name(-model)";
                        }
                        if (sig.startsWith("hidden_field(")) {
                            String path = file.getPath();
                            if (path.indexOf("-2") != -1 || path.indexOf("-1") == -1) {
                                return "record_or_name_or_array(-model)";
                            }
                            return "object_name(-model)";
                        }
                        if (sig.startsWith("file_field(")) {
                            String path = file.getPath();
                            if (path.indexOf("-2") != -1 || path.indexOf("-1") == -1) {
                                return "record_or_name_or_array(-model)";
                            }
                            return "object_name(-model)";
                        }
                        if (sig.startsWith("text_area(")) {
                            String path = file.getPath();
                            if (path.indexOf("-2") != -1 || path.indexOf("-1") == -1) {
                                return "record_or_name_or_array(-model)";
                            }
                            return "object_name(-model)";
                        }
                        if (sig.startsWith("check_box(")) {
                            String path = file.getPath();
                            if (path.indexOf("-2") != -1 || path.indexOf("-1") == -1) {
                                return "record_or_name_or_array(-model)";
                            }
                            return "object_name(-model)";
                        }
                        if (sig.startsWith("radio_button(")) {
                            String path = file.getPath();
                            if (path.indexOf("-2") != -1 || path.indexOf("-1") == -1) {
                                return "record_or_name_or_array(-model)";
                            }
                            return "object_name(-model)";
                        }
                        return null;
                    }
                    return null;
                }
                if (!"form_tag_helper".equals(n)) break;
                String clz = RubyIndexerHelper.clz(root, (Node)method);
                if ("ActionView::Helpers::FormTagHelper".equals(clz)) {
                    String sig = RubyIndexerHelper.sig(method);
                    if (sig.startsWith("form_tag(")) {
                        return "options(=>anchor|only_path:bool|controller:controller|action:action|trailing_slash:bool|host|protocol)";
                    }
                    if (sig.startsWith("select_tag(")) {
                        return "options(=>multiple:bool)";
                    }
                    if (sig.startsWith("text_area_tag(")) {
                        return "options(=>size)";
                    }
                    if (sig.startsWith("text_field_tag(")) {
                        return "options(=>disabled:bool|size|maxlength)";
                    }
                    if (sig.startsWith("password_field_tag(")) {
                        return "options(=>disabled:bool|size|maxlength)";
                    }
                    if (sig.startsWith("hidden_field_tag(")) {
                        return "options(=>disabled:bool|size|maxlength)";
                    }
                    return null;
                }
                return null;
            }
            case 'k': {
                if (!"kernel".equals(n)) break;
                String clz = RubyIndexerHelper.clz(root, (Node)method);
                if ("Kernel".equals(clz)) {
                    String sig = RubyIndexerHelper.sig(method);
                    if (sig.startsWith("describe(")) {
                        return "args(=>behaviour_type|shared:bool)";
                    }
                    return null;
                }
                return null;
            }
            case 'l': {
                if (!"list".equals(n)) break;
                String clz = RubyIndexerHelper.clz(root, (Node)method);
                if ("ActiveRecord::Acts::List::ClassMethods".equals(clz)) {
                    String sig = RubyIndexerHelper.sig(method);
                    if (sig.startsWith("acts_as_list(")) {
                        return "options(=>column|scope)";
                    }
                    return null;
                }
                return null;
            }
            case 'n': {
                if ("nested_set".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActiveRecord::Acts::NestedSet::ClassMethods".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("acts_as_nested_set(")) {
                            return "options(=>parent_column|left_column|right_column|scope)";
                        }
                        return null;
                    }
                    return null;
                }
                if (!"number_helper".equals(n)) break;
                String clz = RubyIndexerHelper.clz(root, (Node)method);
                if ("ActionView::Helpers::NumberHelper".equals(clz)) {
                    String sig = RubyIndexerHelper.sig(method);
                    if (sig.startsWith("number_to_phone(")) {
                        return "options(=>area_code:bool|delimiter|extension|country_code)";
                    }
                    if (sig.startsWith("number_to_currency(")) {
                        return "options(=>precision|unit|separator|delimiter)";
                    }
                    if (sig.startsWith("number_to_percentage(")) {
                        return "options(=>precision|separator)";
                    }
                    return null;
                }
                return null;
            }
            case 'p': {
                if ("pagination".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActionController::Pagination".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("paginate(")) {
                            return "options(=>singular_name|class_name|per_page|conditions|order|order_by|joins|join|include|selected|count)";
                        }
                        return null;
                    }
                    return null;
                }
                if ("pagination_helper".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActionView::Helpers::PaginationHelper".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("pagination_links(")) {
                            return "options(name|window_size|always_show_anchors:bool|link_to_current_page:bool|params),html_options(=>confirm:string|popup:bool|methodclass|id)";
                        }
                        return null;
                    }
                    return null;
                }
                if (!"prototype_helper".equals(n)) break;
                String clz = RubyIndexerHelper.clz(root, (Node)method);
                if ("ActionView::Helpers::PrototypeHelper".equals(clz)) {
                    String sig = RubyIndexerHelper.sig(method);
                    if (sig.startsWith("observe_field")) {
                        return "options(=>url:hash|function|frequency|update|with|on)";
                    }
                    if (sig.startsWith("observe_form")) {
                        return "options(=>url:hash|function|frequency|update|with|on)";
                    }
                    if (sig.startsWith("link_to_remote(")) {
                        return "options(=>url:hash|update)";
                    }
                    if (sig.startsWith("remote_function(")) {
                        return "options(=>url:hash|update)";
                    }
                    if (sig.startsWith("submit_to_remote(")) {
                        return "options(=>url:hash|update)";
                    }
                    if (sig.startsWith("form_remote_tag(")) {
                        return "options(=>url:hash|update)";
                    }
                    return null;
                }
                return null;
            }
            case 's': {
                if ("scaffolding".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActionController::Scaffolding::ClassMethods".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("scaffold(")) {
                            return "model_id(-model),options(=>suffix:bool)";
                        }
                        return null;
                    }
                    return null;
                }
                if ("schema_definitions".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActiveRecord::ConnectionAdapters::TableDefinition".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("column(")) {
                            return "type(:primary_key|:string|:text|:integer|:float|:decimal|:datetime|:timestamp|:time|:date|:binary|:boolean),options(=>limit|default:nil|null:bool|precision|scale)";
                        }
                        return null;
                    }
                    return null;
                }
                if ("schema_statements".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActiveRecord::ConnectionAdapters::SchemaStatements".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("create_table(")) {
                            return "options(=>id:bool|primary_key:string|options:hash|temporary:bool|force:bool)";
                        }
                        if (sig.startsWith("add_column(")) {
                            return "table_name(-table),column_name(-column),options(=>limit|default:nil|null:bool|precision|scale),type(:primary_key|:string|:text|:integer|:float|:decimal|:datetime|:timestamp|:time|:date|:binary|:boolean)";
                        }
                        if (sig.startsWith("change_column(")) {
                            return "table_name(-table),column_name(-column),options(=>limit|default:nil|null:bool|precision|scale),type(:primary_key|:string|:text|:integer|:float|:decimal|:datetime|:timestamp|:time|:date|:binary|:boolean)";
                        }
                        if (sig.startsWith("rename_table(")) {
                            String path = file.getPath();
                            if (path.indexOf("-2") != -1 || path.indexOf("-1") == -1) {
                                return "table_name(-table)";
                            }
                            return "name(-table)";
                        }
                        if (sig.startsWith("rename_column(")) {
                            return "table_name(-table),column_name(-column)";
                        }
                        if (sig.startsWith("change_column_default(")) {
                            return "table_name(-table),column_name(-column)";
                        }
                        if (sig.startsWith("drop_table(")) {
                            String path = file.getPath();
                            if (path.indexOf("-2") != -1 || path.indexOf("-1") == -1) {
                                return "table_name(-table)";
                            }
                            return "name(-table)";
                        }
                        if (sig.startsWith("add_index(")) {
                            return "table_name(-table),column_name(-column)";
                        }
                        if (sig.startsWith("remove_index(")) {
                            return "table_name(-table)";
                        }
                        if (sig.startsWith("remove_column(")) {
                            return "table_name(-table),column_name(-column)";
                        }
                        return null;
                    }
                    return null;
                }
                if ("session_management".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActionController::SessionManagement::ClassMethods".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("session_store=(")) {
                            return "store(:active_record_store|:drb_store|:mem_cache_store|:memory_store)";
                        }
                        if (sig.startsWith("session(")) {
                            return "args(=>on:bool|off:bool|only|except|database_manager|session_key|session_id|new_session|session_expires|session_domain|session_secure|session_path)";
                        }
                        return null;
                    }
                    return null;
                }
                if (!"streaming".equals(n)) break;
                String clz = RubyIndexerHelper.clz(root, (Node)method);
                if ("ActionController::Streaming".equals(clz)) {
                    String sig = RubyIndexerHelper.sig(method);
                    if (sig.startsWith("send_file(")) {
                        return "options(=>filename|type|disposition|stream|buffer_size|status:status)";
                    }
                    if (sig.startsWith("send_data(")) {
                        return "options(=>filename|type|disposition|status:status)";
                    }
                    return null;
                }
                return null;
            }
            case 't': {
                if (!"tree".equals(n)) break;
                String clz = RubyIndexerHelper.clz(root, (Node)method);
                if ("ActiveRecord::Acts::Tree::ClassMethods".equals(clz)) {
                    String sig = RubyIndexerHelper.sig(method);
                    if (sig.startsWith("acts_as_tree(")) {
                        return "options(=>foreign_key|order|counter_cache)";
                    }
                    return null;
                }
                return null;
            }
            case 'u': {
                if (!"url_helper".equals(n)) break;
                String clz = RubyIndexerHelper.clz(root, (Node)method);
                if ("ActionView::Helpers::UrlHelper".equals(clz)) {
                    String sig = RubyIndexerHelper.sig(method);
                    if (sig.startsWith("url_for(")) {
                        return "options(=>escape:bool|anchor|only_path:bool|controller:controller|action:action|trailing_slash:bool|host|protocol)";
                    }
                    if (sig.startsWith("link_to(")) {
                        return "options(=>anchor|only_path:bool|controller:controller|action:action|trailing_slash:bool|host|protocol),html_options(=>confirm:string|popup:bool|methodclass|id)";
                    }
                    if (sig.startsWith("button_to(")) {
                        return "options(=>anchor|only_path:bool|controller:controller|action:action|trailing_slash:bool|host|protocol),html_options(=>confirm:string|popup:bool|method|disabled:boolclass|id)";
                    }
                    if (sig.startsWith("mail_to(")) {
                        return "html_options(=>encode|replace_at|replace_dot|subject|body|cc|bccclass|id)";
                    }
                    return null;
                }
                return null;
            }
            case 'v': {
                if ("validations".equals(n)) {
                    String clz = RubyIndexerHelper.clz(root, (Node)method);
                    if ("ActiveRecord::Validations::ClassMethods".equals(clz)) {
                        String sig = RubyIndexerHelper.sig(method);
                        if (sig.startsWith("validates_each(")) {
                            return "attrs(=>on:validationactive|allow_nil:bool|if)";
                        }
                        if (sig.startsWith("validates_confirmation_of(")) {
                            return "attr_names(=>on:validationactive|message|if)";
                        }
                        if (sig.startsWith("validates_acceptance_of(")) {
                            return "attr_names(=>on:validationactive|message|if|accept)";
                        }
                        if (sig.startsWith("validates_presence_of(")) {
                            return "attr_names(=>on:validationactive|message|if)";
                        }
                        if (sig.startsWith("validates_length_of(")) {
                            return "attrs(=>minimum|maximum|is|within|in|allow_nil:bool|too_long|too_short|wrong_length|on:validationactive|message|if)";
                        }
                        if (sig.startsWith("validates_uniqueness_of(")) {
                            return "attr_names(=>message|scope|case_sensitive:bool|allow_nil:bool|if)";
                        }
                        if (sig.startsWith("validates_format_of(")) {
                            return "attr_names(=>on:validationactive|message|if|with)";
                        }
                        if (sig.startsWith("validates_inclusion_of(")) {
                            return "attr_names(=>in|message|allow_nil:bool|if)";
                        }
                        if (sig.startsWith("validates_exclusion_of(")) {
                            return "attr_names(=>in|message|allow_nil:bool|if)";
                        }
                        if (sig.startsWith("validates_associated(")) {
                            return "attr_names(=>on:validationactive|if)";
                        }
                        if (sig.startsWith("validates_numericality_of(")) {
                            return "attr_names(=>on:validationactive|message|if|only_integer:bool|allow_nil:bool)";
                        }
                        return null;
                    }
                    return null;
                }
                if (!"verification".equals(n)) break;
                String clz = RubyIndexerHelper.clz(root, (Node)method);
                if ("ActionController::Verification::ClassMethods".equals(clz)) {
                    String sig = RubyIndexerHelper.sig(method);
                    if (sig.startsWith("verify(")) {
                        return "options(=>params|session|flash|method|post:submitmethod|xhr:bool|add_flash:hash|add_headers:hash|redirect_to|render|only:bool|except:bool)";
                    }
                    return null;
                }
                return null;
            }
        }
        return null;
    }
}

