/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.ruby.ReflowParagraphAction;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.ruby.options.CodeStyle;

public class RubyFormatter
implements org.netbeans.modules.csl.api.Formatter {
    private boolean isEmbeddedDoc;
    private final CodeStyle codeStyle;
    private int rightMarginOverride = -1;

    public RubyFormatter() {
        this.codeStyle = null;
    }

    public RubyFormatter(CodeStyle codeStyle, int rightMarginOverride) {
        assert (codeStyle != null);
        this.codeStyle = codeStyle;
        this.rightMarginOverride = rightMarginOverride;
    }

    public boolean needsParserResult() {
        return false;
    }

    public void reindent(Context context) {
        Document document = context.document();
        int startOffset = context.startOffset();
        int endOffset = context.endOffset();
        if (this.codeStyle != null) {
            this.reindent(context, document, startOffset, endOffset, null, true);
        } else {
            RubyFormatter f = new RubyFormatter(CodeStyle.get(document), -1);
            f.reindent(context, document, startOffset, endOffset, null, true);
        }
    }

    public void reformat(Context context, ParserResult info) {
        Document document = context.document();
        int startOffset = context.startOffset();
        int endOffset = context.endOffset();
        if (this.codeStyle != null) {
            this.reindent(context, document, startOffset, endOffset, info, false);
        } else {
            RubyFormatter f = new RubyFormatter(CodeStyle.get(document), -1);
            f.reindent(context, document, startOffset, endOffset, info, false);
        }
    }

    public int indentSize() {
        if (this.codeStyle != null) {
            return this.codeStyle.getIndentSize();
        }
        return CodeStyle.get((Document)null).getIndentSize();
    }

    public int hangingIndentSize() {
        if (this.codeStyle != null) {
            return this.codeStyle.getContinuationIndentSize();
        }
        return CodeStyle.get((Document)null).getContinuationIndentSize();
    }

    private int getFormatStableStart(BaseDocument doc, int offset) {
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, offset);
        if (ts == null) {
            return 0;
        }
        ts.move(offset);
        if (!ts.movePrevious()) {
            return 0;
        }
        do {
            Token token;
            TokenId id;
            if ((id = (token = ts.token()).id()) != RubyTokenId.CLASS && id != RubyTokenId.MODULE && id != RubyTokenId.DEF) continue;
            return ts.offset();
        } while (ts.movePrevious());
        return ts.offset();
    }

    public static int getTokenBalanceDelta(TokenId id, Token<? extends RubyTokenId> token, BaseDocument doc, TokenSequence<? extends RubyTokenId> ts, boolean includeKeywords) {
        if (id == RubyTokenId.IDENTIFIER) {
            if (token.length() == 1) {
                char c = token.text().charAt(0);
                if (c == '[') {
                    return 1;
                }
                if (c == ']') {
                    return -1;
                }
            }
        } else {
            if (id == RubyTokenId.LPAREN || id == RubyTokenId.LBRACKET || id == RubyTokenId.LBRACE) {
                return 1;
            }
            if (id == RubyTokenId.RPAREN || id == RubyTokenId.RBRACKET || id == RubyTokenId.RBRACE) {
                return -1;
            }
            if (includeKeywords) {
                if (LexUtilities.isBeginToken(id, doc, ts)) {
                    return 1;
                }
                if (id == RubyTokenId.END) {
                    return -1;
                }
            }
        }
        return 0;
    }

    public static int getTokenBalance(BaseDocument doc, int begin, int end, boolean includeKeywords, boolean rhtml) {
        int balance = 0;
        if (rhtml) {
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            TokenSequence t = th.tokenSequence();
            if (t == null) {
                return 0;
            }
            t.move(begin);
            if (!t.moveNext()) {
                return 0;
            }
            do {
                Token rubyToken;
                Token token;
                TokenId id;
                if (!(id = (token = t.token()).id()).primaryCategory().equals("ruby")) continue;
                TokenSequence ts = t.embedded(RubyTokenId.language());
                ts.move(begin);
                ts.moveNext();
                while ((rubyToken = ts.token()) != null) {
                    TokenId rubyId = rubyToken.id();
                    balance += RubyFormatter.getTokenBalanceDelta(rubyId, (Token<? extends RubyTokenId>)rubyToken, doc, (TokenSequence<? extends RubyTokenId>)ts, includeKeywords);
                    if (ts.moveNext() && ts.offset() < end) continue;
                }
            } while (t.moveNext() && t.offset() < end);
        } else {
            TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, begin);
            if (ts == null) {
                return 0;
            }
            ts.move(begin);
            if (!ts.moveNext()) {
                return 0;
            }
            do {
                Token token = ts.token();
                TokenId id = token.id();
                balance += RubyFormatter.getTokenBalanceDelta(id, (Token<? extends RubyTokenId>)token, doc, ts, includeKeywords);
            } while (ts.moveNext() && ts.offset() < end);
        }
        return balance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInLiteral(BaseDocument doc, int offset) throws BadLocationException {
        TokenId id;
        int pos = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        if (pos != -1) {
            Token<? extends RubyTokenId> token = LexUtilities.getToken(doc, pos);
            if (token == null) return true;
            TokenId id2 = token.id();
            if (id2 == RubyTokenId.STRING_LITERAL || id2 == RubyTokenId.DOCUMENTATION || id2 == RubyTokenId.QUOTED_STRING_LITERAL || id2 == RubyTokenId.REGEXP_LITERAL) {
                return true;
            }
            if (id2 != RubyTokenId.STRING_END && id2 != RubyTokenId.QUOTED_STRING_END) return false;
            TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, pos);
            ts.move(pos);
            OffsetRange range = LexUtilities.findHeredocBegin(ts, token);
            if (range == OffsetRange.NONE) return false;
            String text = doc.getText(range.getStart(), range.getLength());
            return !text.startsWith("<<-");
        }
        Token<? extends RubyTokenId> token = LexUtilities.getToken(doc, offset);
        if (token == null || (id = token.id()) != RubyTokenId.STRING_LITERAL && id != RubyTokenId.DOCUMENTATION && id != RubyTokenId.QUOTED_STRING_LITERAL && id != RubyTokenId.REGEXP_LITERAL) return false;
        return true;
    }

    private Token<? extends RubyTokenId> getFirstToken(BaseDocument doc, int offset) throws BadLocationException {
        int lineBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        if (lineBegin != -1) {
            if (this.isEmbeddedDoc) {
                TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, lineBegin);
                if (ts != null) {
                    ts.moveNext();
                    Token token = ts.token();
                    while (token != null && token.id() == RubyTokenId.WHITESPACE) {
                        if (!ts.moveNext()) {
                            return null;
                        }
                        token = ts.token();
                    }
                    return token;
                }
            } else {
                return LexUtilities.getToken(doc, lineBegin);
            }
        }
        return null;
    }

    private boolean isEndIndent(BaseDocument doc, int offset) throws BadLocationException {
        int lineBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        if (lineBegin != -1) {
            Token<? extends RubyTokenId> token = this.getFirstToken(doc, offset);
            if (token == null) {
                String lineBeginStr;
                return this.isEmbeddedDoc && lineBegin < doc.getLength() - 2 && ((lineBeginStr = doc.getText(lineBegin, 2)).equals("-%") && lineBegin < doc.getLength() - 3 ? (lineBeginStr = doc.getText(lineBegin, 3)).equals("-%>") : lineBeginStr.equals("%>"));
            }
            TokenId id = token.id();
            return LexUtilities.isIndentToken(id) && !LexUtilities.isBeginToken(id, doc, offset) || id == RubyTokenId.END || id == RubyTokenId.RBRACE || id == RubyTokenId.RBRACKET || id == RubyTokenId.RPAREN;
        }
        return false;
    }

    private boolean isLineContinued(BaseDocument doc, int offset, int bracketBalance) throws BadLocationException {
        if ((offset = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)offset)) == -1) {
            return false;
        }
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, offset);
        if (ts == null) {
            return false;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return false;
        }
        Token<? extends RubyTokenId> token = ts.token();
        if (token != null) {
            String text;
            boolean isContinuationOperator;
            TokenId id = token.id();
            boolean bl = isContinuationOperator = id == RubyTokenId.NONUNARY_OP || id == RubyTokenId.DOT;
            if (ts.offset() == offset && token.length() > 1 && ((Object)token.text()).toString().startsWith("\\")) {
                isContinuationOperator = true;
            }
            if (token.length() == 1 && id == RubyTokenId.IDENTIFIER && ((Object)token.text()).toString().equals(",") && bracketBalance == 0) {
                isContinuationOperator = true;
            }
            if (isContinuationOperator) {
                token = LexUtilities.getToken(doc, Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset));
                return token == null || (id = token.id()) != RubyTokenId.DEF && (id != RubyTokenId.ANY_KEYWORD || !((Object)token.text()).toString().equals("alias"));
            }
            if (id == RubyTokenId.ANY_KEYWORD && ("or".equals(text = ((Object)token.text()).toString()) || "and".equals(text))) {
                return true;
            }
        }
        return false;
    }

    public void reindent(final Context context, Document document, int startOffset, int endOffset, ParserResult info, final boolean indentOnly) {
        this.isEmbeddedDoc = RubyUtils.isRhtmlDocument(document) || RubyUtils.isYamlDocument(document);
        try {
            Token<? extends RubyTokenId> token;
            final BaseDocument doc = (BaseDocument)document;
            if (indentOnly && this.isEmbeddedDoc && (token = LexUtilities.getToken(doc, startOffset)) == null) {
                return;
            }
            if (endOffset > doc.getLength()) {
                endOffset = doc.getLength();
            }
            final int lineStart = startOffset = Utilities.getRowStart((BaseDocument)doc, (int)startOffset);
            int initialOffset = 0;
            int initialIndent = 0;
            if (startOffset > 0) {
                int prevOffset = Utilities.getRowStart((BaseDocument)doc, (int)(startOffset - 1));
                initialOffset = this.getFormatStableStart(doc, prevOffset);
                initialIndent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)initialOffset);
            }
            final ArrayList<Integer> offsets = new ArrayList<Integer>();
            final ArrayList<Integer> indents = new ArrayList<Integer>();
            boolean indentEmptyLines = startOffset != 0 || endOffset != doc.getLength();
            boolean includeEnd = true;
            this.computeIndents(doc, initialIndent, initialOffset, endOffset, info, offsets, indents, indentEmptyLines, true, indentOnly);
            final int finalStartOffset = startOffset;
            final int finalEndOffset = endOffset;
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        assert (indents.size() == offsets.size());
                        Formatter editorFormatter = null;
                        for (int i = indents.size() - 1; i >= 0; --i) {
                            int currentIndent;
                            int indent = (Integer)indents.get(i);
                            int lineBegin = (Integer)offsets.get(i);
                            if (lineBegin < lineStart) break;
                            if (lineBegin == lineStart && i > 0) {
                                int prevOffset = (Integer)offsets.get(i - 1);
                                int prevIndent = (Integer)indents.get(i - 1);
                                int actualPrevIndent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)prevOffset);
                                if (actualPrevIndent != prevIndent && !Utilities.isRowEmpty((BaseDocument)doc, (int)prevOffset) && !Utilities.isRowWhite((BaseDocument)doc, (int)prevOffset)) {
                                    indent = actualPrevIndent + (indent - prevIndent);
                                }
                            }
                            if ((currentIndent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)lineBegin)) == indent || indent < 0) continue;
                            if (context != null) {
                                assert (lineBegin == Utilities.getRowStart((BaseDocument)doc, (int)lineBegin));
                                context.modifyIndent(lineBegin, indent);
                                continue;
                            }
                            if (editorFormatter == null) {
                                editorFormatter = doc.getFormatter();
                            }
                            editorFormatter.changeRowIndent(doc, lineBegin, indent);
                        }
                        if (!indentOnly && RubyFormatter.this.codeStyle.reformatComments()) {
                            RubyFormatter.this.reformatComments(doc, finalStartOffset, finalEndOffset);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
    }

    public void computeIndents(BaseDocument doc, int initialIndent, int startOffset, int endOffset, ParserResult info, List<Integer> offsets, List<Integer> indents, boolean indentEmptyLines, boolean includeEnd, boolean indentOnly) {
        try {
            int offset = Utilities.getRowStart((BaseDocument)doc, (int)startOffset);
            int end = endOffset;
            int indentSize = this.codeStyle.getIndentSize();
            int hangingIndentSize = this.codeStyle.getContinuationIndentSize();
            int balance = 0;
            int bracketBalance = 0;
            boolean continued = false;
            boolean indentHtml = false;
            if (this.isEmbeddedDoc) {
                indentHtml = this.codeStyle.indentHtml();
            }
            while (!includeEnd && offset < end || includeEnd && offset <= end) {
                int lineBegin;
                int indent;
                int hangingIndent;
                int n = hangingIndent = continued ? hangingIndentSize : 0;
                if (this.isEmbeddedDoc && !indentOnly) {
                    Integer ind;
                    Map suggestedLineIndents = (Map)doc.getProperty((Object)"AbstractIndenter.lineIndents");
                    initialIndent = suggestedLineIndents != null ? ((ind = (Integer)suggestedLineIndents.get(Utilities.getLineOffset((BaseDocument)doc, (int)offset))) != null ? ind : GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset)) : GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
                }
                if (this.isInLiteral(doc, offset)) {
                    indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
                    if (this.isEmbeddedDoc && indentHtml && balance > 0) {
                        indent += balance * indentSize;
                    }
                } else {
                    indent = this.isEndIndent(doc, offset) ? (balance - 1) * indentSize + hangingIndent + initialIndent : balance * indentSize + hangingIndent + initialIndent;
                }
                if (indent < 0) {
                    indent = 0;
                }
                if ((lineBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset)) != -1 || indentEmptyLines) {
                    indents.add(indent);
                    offsets.add(offset);
                }
                int endOfLine = Utilities.getRowEnd((BaseDocument)doc, (int)offset) + 1;
                if (lineBegin != -1) {
                    balance += RubyFormatter.getTokenBalance(doc, lineBegin, endOfLine, true, this.isEmbeddedDoc);
                    continued = this.isLineContinued(doc, offset, bracketBalance += RubyFormatter.getTokenBalance(doc, lineBegin, endOfLine, false, this.isEmbeddedDoc));
                }
                offset = endOfLine;
            }
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
    }

    void reformatComments(BaseDocument doc, int start, int end) {
        int rightMargin = this.rightMarginOverride;
        if (rightMargin == -1) {
            CodeStyle style = this.codeStyle;
            if (style == null) {
                style = CodeStyle.get((Document)doc);
            }
            rightMargin = style.getRightMargin();
        }
        ReflowParagraphAction.reflowComments(doc, start, end, rightMargin);
    }
}

