/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.Node;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyBaseDeclarationFinder;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;

final class RubyClassDeclarationFinder
extends RubyBaseDeclarationFinder<IndexedClass> {
    private final Node classNode;

    RubyClassDeclarationFinder() {
        this(null, null, null, null, null);
    }

    RubyClassDeclarationFinder(ParserResult info, Node root, AstPath path, RubyIndex index, Node classNode) {
        super(info, root, path, index);
        this.classNode = classNode;
    }

    DeclarationFinder.DeclarationLocation findClassDeclaration() {
        int f;
        String className = ((INameNode)this.classNode).getName();
        Node localClass = null;
        if (localClass != null) {
            if (this.classNode instanceof Colon2Node) {
                AstPath classPath = new AstPath(this.root, localClass);
                if (classPath.leaf() != null) {
                    String fqn2;
                    String fqn1 = AstUtilities.getFqn((Colon2Node)this.classNode);
                    if (fqn1.equals(fqn2 = AstUtilities.getFqnName(classPath))) {
                        return RubyClassDeclarationFinder.fix(RubyClassDeclarationFinder.getLocation(this.info, localClass), this.info);
                    }
                } else assert (false) : localClass.toString();
            } else {
                return RubyClassDeclarationFinder.fix(RubyClassDeclarationFinder.getLocation(this.info, localClass), this.info);
            }
        }
        if (this.classNode instanceof Colon2Node) {
            className = AstUtilities.getFqn((Colon2Node)this.classNode);
        }
        String possibleFqn = AstUtilities.getFqnName(this.path);
        Set<Object> classes = Collections.emptySet();
        String fqn = possibleFqn;
        HashSet<String> uniqueClasses = new HashSet<String>();
        while (classes.size() == 0 && fqn.length() > 0) {
            classes = this.index.getClasses(fqn + "::" + className, QuerySupport.Kind.EXACT, true, false, false, uniqueClasses);
            f = fqn.lastIndexOf("::");
            if (f == -1) break;
            fqn = fqn.substring(0, f);
        }
        if (classes.size() == 0) {
            classes = this.index.getClasses(className, QuerySupport.Kind.EXACT, true, false, false, uniqueClasses);
        }
        if (classes.size() == 0) {
            fqn = possibleFqn;
            while (classes.size() == 0 && fqn.length() > 0) {
                classes = this.index.getClasses(fqn + "::" + className, QuerySupport.Kind.EXACT, true, false, false);
                f = fqn.lastIndexOf("::");
                if (f == -1) break;
                fqn = fqn.substring(0, f);
            }
            if (classes.size() == 0) {
                classes = this.index.getClasses(className, QuerySupport.Kind.EXACT, true, false, false);
            }
        }
        return this.getElementDeclaration(classes, this.classNode);
    }

    Node findClass(Node node, String name, boolean ignoreAlias) {
        String newName;
        String n;
        if (node instanceof ClassNode ? (n = AstUtilities.getClassOrModuleName((IScopingNode)((ClassNode)node))).equals(name) : (node instanceof ConstDeclNode ? ((INameNode)node).getName().equals(name) : !ignoreAlias && node instanceof AliasNode && name.equals(newName = AstUtilities.getNameOrValue(((AliasNode)node).getNewName())))) {
            return node;
        }
        List list = node.childNodes();
        for (Node child : list) {
            Node match;
            if (child.isInvisible() || (match = this.findClass(child, name, ignoreAlias)) == null) continue;
            return match;
        }
        return null;
    }

    @Override
    IndexedClass findBestMatchHelper(Set<? extends IndexedClass> origClasses) {
        HashSet<IndexedClass> classes = new HashSet<IndexedClass>(origClasses);
        HashSet<IndexedClass> candidates = new HashSet<IndexedClass>();
        if (this.classNode instanceof Colon2Node) {
            String fqn = AstUtilities.getFqn((Colon2Node)this.classNode);
            while (fqn != null && fqn.length() > 0) {
                for (IndexedClass indexedClass : classes) {
                    if (!fqn.equals(indexedClass.getSignature())) continue;
                    candidates.add(indexedClass);
                }
                IndexedClass superClass = this.index.getSuperclass(fqn);
                if (superClass == null) break;
                fqn = superClass.getSignature();
            }
        }
        if (candidates.size() == 1) {
            return (IndexedClass)candidates.iterator().next();
        }
        if (!candidates.isEmpty()) {
            classes = candidates;
        }
        Set<String> requires = null;
        if (this.path != null) {
            candidates = new HashSet();
            requires = AstUtilities.getRequires(this.path.root());
            for (IndexedClass indexedClass : classes) {
                String string = indexedClass.getRequire();
                if (!requires.contains(string)) continue;
                candidates.add(indexedClass);
            }
            if (candidates.size() == 1) {
                return (IndexedClass)candidates.iterator().next();
            }
            if (!candidates.isEmpty()) {
                classes = candidates;
            }
        }
        candidates = new HashSet();
        for (IndexedClass indexedClass : classes) {
            String string = indexedClass.getFileUrl();
            if (!RubyUtils.isRubyStubsURL(string)) continue;
            candidates.add(indexedClass);
        }
        if (candidates.size() == 1) {
            return (IndexedClass)candidates.iterator().next();
        }
        if (!candidates.isEmpty()) {
            classes = candidates;
        }
        candidates = new HashSet();
        int longestDocLength = 0;
        for (IndexedClass indexedClass : classes) {
            int n = indexedClass.getDocumentationLength();
            if (n > longestDocLength) {
                candidates.clear();
                candidates.add(indexedClass);
                longestDocLength = n;
                continue;
            }
            if (n <= 0 || n != longestDocLength) continue;
            candidates.add(indexedClass);
        }
        if (candidates.size() == 1) {
            return (IndexedClass)candidates.iterator().next();
        }
        if (!candidates.isEmpty()) {
            classes = candidates;
        }
        if (this.index != null && requires != null) {
            candidates = new HashSet();
            Set<String> set = this.index.getRequiresTransitively(requires);
            for (IndexedClass indexedClass : classes) {
                String require = indexedClass.getRequire();
                if (!set.contains(require)) continue;
                candidates.add(indexedClass);
            }
            if (candidates.size() == 1) {
                return (IndexedClass)candidates.iterator().next();
            }
            if (!candidates.isEmpty()) {
                classes = candidates;
            }
        }
        candidates = new HashSet();
        if (classes.size() > 0) {
            return (IndexedClass)classes.iterator().next();
        }
        return null;
    }
}

