/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.StrNode;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RubyIndexer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.openide.filesystems.FileObject;

final class RailsIndexer {
    private final ContextKnowledge knowledge;
    private final RubyIndexer.TreeAnalyzer analyzer;
    private static final String INCLUDE = "include";
    private static final String REQUIRE = "require";
    private static final String EXTEND = "extend";

    RailsIndexer(ContextKnowledge knowledge, RubyIndexer.TreeAnalyzer analyzer) {
        this.knowledge = knowledge;
        this.analyzer = analyzer;
    }

    private static Map<String, Set<String>> createResultMap() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        result.put(INCLUDE, new HashSet());
        result.put(REQUIRE, new HashSet());
        result.put(EXTEND, new HashSet());
        return result;
    }

    boolean index() {
        boolean fallThrough;
        String fileName = this.analyzer.getFile().getNameExt();
        String path = this.analyzer.getFile().getPath();
        boolean bl = fallThrough = RubyUtils.isRails23OrHigher(this.analyzer.getFile().getPath()) || this.analyzer.getFile().getPath().contains("vendor/rails");
        if ("action_controller.rb".equals(fileName)) {
            this.handleRailsBase("ActionController");
            if (!fallThrough) {
                return false;
            }
        } else if ("active_record.rb".equals(fileName) || path.endsWith("active_record/base.rb")) {
            this.handleRailsBase("ActiveRecord");
            this.analyzer.getMigrationIndexer().handleMigrations();
            if (!fallThrough) {
                return false;
            }
        } else if ("action_mailer.rb".equals(fileName)) {
            this.handleRailsBase("ActionMailer");
            if (!fallThrough) {
                return false;
            }
        } else if ("action_view.rb".equals(fileName)) {
            this.handleRailsBase("ActionView");
            this.handleActionViewHelpers();
            if (!fallThrough) {
                return false;
            }
        } else if (fileName.equals("assertions.rb") && this.analyzer.getUrl().endsWith("lib/action_controller/assertions.rb")) {
            this.handleRailsClass("Test::Unit", "Test::Unit::TestCase", "TestCase", "TestCase");
            if (!fallThrough) {
                return false;
            }
        } else if (fileName.equals("schema_definitions.rb")) {
            this.handleSchemaDefinitions();
        }
        return true;
    }

    private void handleRailsBase(String classIn) {
        this.handleRailsClass(classIn, classIn + "::Base", "Base", "base");
    }

    private void handleRailsClass(String classIn, String classFqn, String clz, String clzNoCase) {
        Node root = this.knowledge.getRoot();
        IndexDocument document = this.analyzer.getSupport().createDocument(this.analyzer.getIndexable());
        this.analyzer.getDocuments().add(document);
        Map<String, Set<String>> result = RailsIndexer.createResultMap();
        this.scan(root, result);
        this.addResults(document, result);
        int flags = 0;
        document.addPair("attrs", IndexedElement.flagToString(flags), false, true);
        document.addPair("fqn", classFqn, true, true);
        document.addPair("class-ig", clzNoCase, true, true);
        document.addPair("class", clz, true, true);
        document.addPair("in", classIn, false, true);
    }

    private void handleActionViewHelpers() {
        if (this.analyzer.getFile() == null || this.analyzer.getFile().getParent() == null) {
            return;
        }
        assert (this.analyzer.getFile().getName().equals("action_view"));
        FileObject helpers = this.analyzer.getFile().getParent().getFileObject("action_view/helpers");
        if (helpers == null) {
            return;
        }
        StringBuilder include = new StringBuilder();
        for (FileObject helper : helpers.getChildren()) {
            String name = helper.getName();
            if (!name.endsWith("_helper")) continue;
            String className = RubyUtils.underlinedNameToCamel(name);
            String fqn = "ActionView::Helpers::" + className;
            if (include.length() > 0) {
                include.append(",");
            }
            include.append(fqn);
        }
        if (include.length() > 0) {
            int flags = 0;
            this.analyzer.addClassIncludes("Base", "ActionView::Base", "ActionView", flags, include.toString());
        }
    }

    private boolean scan(Node node, Map<String, Set<String>> result) {
        Node receiver;
        CallNode call;
        boolean found = false;
        if (node instanceof FCallNode) {
            String name = ((INameNode)node).getName();
            if (name.equals(REQUIRE)) {
                String require;
                Node n;
                ListNode args;
                Node argsNode = ((FCallNode)node).getArgsNode();
                if (argsNode instanceof ListNode && (args = (ListNode)argsNode).size() > 0 && (n = args.get(0)) instanceof StrNode && (require = ((StrNode)n).getValue()) != null && require.length() > 0) {
                    result.get(REQUIRE).add(require);
                }
            } else if (name.equals(INCLUDE) || name.equals(EXTEND)) {
                String key = name.equals(INCLUDE) ? INCLUDE : EXTEND;
                Node argsNode = ((FCallNode)node).getArgsNode();
                if (argsNode instanceof ListNode) {
                    result.get(key).addAll(AstUtilities.getValuesAsFqn((ListNode)argsNode));
                }
            }
        } else if (node instanceof CallNode && (call = (CallNode)node).getName().equals("class_eval") && "Base".equals(AstUtilities.safeGetName(receiver = call.getReceiverNode()))) {
            found = true;
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible() || !this.scan(child, result)) continue;
            found = true;
        }
        return found;
    }

    private void handleSchemaDefinitions() {
        if (this.analyzer.getUrl().indexOf("activerecord-2") == -1) {
            return;
        }
        Node root = AstUtilities.getRoot((Parser.Result)this.analyzer.getResult());
        if (root == null) {
            return;
        }
        Map<String, Set<String>> result = RailsIndexer.createResultMap();
        this.scan(root, result);
        IndexDocument document = this.analyzer.getSupport().createDocument(this.analyzer.getIndexable());
        this.analyzer.getDocuments().add(document);
        this.addResults(document, result);
        int flags = 0;
        document.addPair("attrs", IndexedElement.flagToString(flags), false, true);
        String clz = "TableDefinition";
        String classIn = "ActiveRecord::ConnectionAdapters";
        String classFqn = classIn + "::" + clz;
        String clzNoCase = clz.toLowerCase();
        document.addPair("fqn", classFqn, true, true);
        document.addPair("class-ig", clzNoCase, true, true);
        document.addPair("class", clz, true, true);
        document.addPair("in", classIn, false, true);
        for (String type : new String[]{"string", "text", "integer", "float", "decimal", "datetime", "timestamp", "time", "date", "binary", "boolean"}) {
            EnumSet<Modifier> modifiers = EnumSet.of(Modifier.PUBLIC);
            int mflags = RubyIndexer.getModifiersFlag(modifiers);
            StringBuilder sb = new StringBuilder();
            sb.append(type);
            sb.append("(names,options);");
            sb.append(IndexedElement.flagToFirstChar(mflags));
            sb.append(IndexedElement.flagToSecondChar(mflags));
            sb.append(";;;options(=>limit|default:nil|null:bool|precision|scale)");
            String signature = sb.toString();
            document.addPair("method", signature, true, true);
        }
    }

    private void addResults(IndexDocument document, Map<String, Set<String>> result) {
        String extendz;
        String r = this.analyzer.getRequireString(result.get(REQUIRE));
        if (r != null) {
            document.addPair("requires", r, false, true);
        }
        this.analyzer.addRequire(document);
        String includes = this.analyzer.getIncludedString(result.get(INCLUDE));
        if (includes != null) {
            document.addPair("includes", includes, false, true);
        }
        if ((extendz = this.analyzer.getIncludedString(result.get(EXTEND))) != null) {
            document.addPair("extendWith", extendz, false, true);
        }
    }
}

