/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.DefsNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.NewlineNode;
import org.jrubyparser.ast.Node;
import org.openide.util.Enumerations;

class AstNodeAdapter
implements TreeNode {
    private static final boolean HIDE_NEWLINE_NODES = false;
    private final Node node;
    private final AstNodeAdapter parent;
    private AstNodeAdapter[] children;

    AstNodeAdapter(AstNodeAdapter parent, Node node) {
        this.parent = parent;
        this.node = node;
    }

    private void ensureChildrenInitialized() {
        if (this.children != null) {
            return;
        }
        List subnodes = this.node.childNodes();
        this.children = new AstNodeAdapter[subnodes.size()];
        int index = 0;
        for (Node child : subnodes) {
            this.children[index++] = new AstNodeAdapter(this, child);
        }
    }

    private void addChildren(List<AstNodeAdapter> children, Node node) {
        List subnodes = node.childNodes();
        for (Node child : subnodes) {
            if (child instanceof NewlineNode) {
                this.addChildren(children, child);
                continue;
            }
            children.add(new AstNodeAdapter(this, child));
        }
    }

    @Override
    public TreeNode getChildAt(int i) {
        this.ensureChildrenInitialized();
        return this.children[i];
    }

    @Override
    public int getChildCount() {
        this.ensureChildrenInitialized();
        return this.children.length;
    }

    @Override
    public TreeNode getParent() {
        this.ensureChildrenInitialized();
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        this.ensureChildrenInitialized();
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != treeNode) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        this.ensureChildrenInitialized();
        return this.children.length > 0;
    }

    @Override
    public boolean isLeaf() {
        this.ensureChildrenInitialized();
        return this.children.length == 0;
    }

    public Enumeration children() {
        this.ensureChildrenInitialized();
        return Enumerations.array((Object[])this.children);
    }

    public String toString() {
        if (this.node.getPosition() == SourcePosition.INVALID_POSITION) {
            return "INVALID_POSITION";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(this.node.toString());
        sb.append("<i>");
        sb.append(" (");
        if (this.node.isInvisible()) {
            sb.append("INVISIBLE");
        } else {
            sb.append(this.getStartOffset());
            sb.append("-");
            sb.append(this.getEndOffset());
        }
        sb.append(") ");
        sb.append("</i>");
        String name = null;
        if (this.node instanceof INameNode) {
            name = ((INameNode)this.node).getName();
        } else if (this.node instanceof DefnNode) {
            name = ((DefnNode)this.node).getName();
        } else if (this.node instanceof DefsNode) {
            name = ((DefsNode)this.node).getName();
        } else if (this.node instanceof ConstDeclNode) {
            name = ((ConstDeclNode)this.node).getName();
        } else if (this.node instanceof GlobalVarNode) {
            name = ((GlobalVarNode)this.node).getName();
        } else if (this.node instanceof ClassNode) {
            Colon3Node n = ((ClassNode)this.node).getCPath();
            if (n instanceof Colon2Node) {
                Colon2Node c2n = (Colon2Node)n;
                name = c2n.getName();
            } else {
                name = n.toString();
            }
        } else if (this.node instanceof ModuleNode) {
            Colon3Node n = ((ModuleNode)this.node).getCPath();
            if (n instanceof Colon2Node) {
                Colon2Node c2n = (Colon2Node)n;
                name = c2n.getName();
            } else {
                name = n.toString();
            }
        }
        if (name != null) {
            sb.append(" : <b>");
            sb.append(name);
            sb.append("</b>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    public int getStartOffset() {
        if (this.node.isInvisible()) {
            return -1;
        }
        if (this.node.getPosition() == SourcePosition.INVALID_POSITION) {
            return -1;
        }
        if (this.node.getPosition() != null) {
            return this.node.getPosition().getStartOffset();
        }
        return -1;
    }

    public int getEndOffset() {
        if (this.node.isInvisible()) {
            return -1;
        }
        if (this.node.getPosition() == SourcePosition.INVALID_POSITION) {
            return -1;
        }
        if (this.node.getPosition() != null) {
            return this.node.getPosition().getEndOffset();
        }
        return -1;
    }

    public Object getAstNode() {
        return this.node;
    }
}

