/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.installer.maven.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.installer.ui.SuiteInstallerProjectProperties;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class BuildInstallersAction
extends AbstractAction
implements ContextAwareAction {
    public BuildInstallersAction() {
        this.putValue("Name", NbBundle.getMessage(BuildInstallersAction.class, (String)"CTL_BuildInstallers"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextBuildInstaller(lookup);
    }

    static class ContextBuildInstaller
    extends AbstractAction {
        private final Lookup actionContext;

        public ContextBuildInstaller(Lookup lookup) {
            this.actionContext = lookup;
            this.putValue("Name", NbBundle.getMessage(BuildInstallersAction.class, (String)"CTL_BuildInstallers"));
            this.putValue("hideWhenDisabled", true);
            Project project = (Project)lookup.lookup(Project.class);
            NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            if (nbMavenProject == null || !"nbm-application".equalsIgnoreCase(nbMavenProject.getPackagingType())) {
                this.setEnabled(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Project project = (Project)this.actionContext.lookup(Project.class);
            NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            if (nbMavenProject != null && "nbm-application".equalsIgnoreCase(nbMavenProject.getPackagingType())) {
                int n;
                Object object;
                Serializable serializable;
                Object object2;
                Object object3;
                File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
                String string = nbMavenProject.getMavenProject().getArtifactId() + "-" + nbMavenProject.getMavenProject().getVersion() + ".zip";
                File file2 = new File(file, "target/" + string);
                Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.WARNING, "Running Build Installers action for (existing={1}) zip file {0}", new Object[]{file2, file2.exists()});
                Preferences preferences = SuiteInstallerProjectProperties.prefs((Project)project);
                String string2 = nbMavenProject.getMavenProject().getParent().getArtifactId();
                File file3 = null;
                String string3 = preferences.get("license-type", null);
                File file4 = null;
                String string4 = preferences.get("license-file", null);
                if (string4 != null) {
                    file4 = PropertyUtils.resolveFile((File)file, (String)string4);
                }
                boolean bl = preferences.getBoolean("pack200-enabled", false);
                file3 = new File(InstalledFileLocator.getDefault().locate("etc/applicationIcon.icns", "org.netbeans.modules.apisupport.harness", false).getAbsolutePath().replace("\\", "/"));
                if (file4 == null && string3 != null && !string3.equals("no")) {
                    Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.FINE, "License type defined to {0}", string3);
                    object3 = null;
                    try {
                        object3 = NbBundle.getMessage(SuiteInstallerProjectProperties.class, (String)("SuiteInstallerProjectProperties.license.file." + string3));
                    }
                    catch (MissingResourceException missingResourceException) {
                        Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.WARNING, "License resource not found");
                    }
                    if (object3 != null) {
                        object2 = null;
                        try {
                            serializable = new URL((String)object3);
                            object2 = ((URL)serializable).openStream();
                            if (object2 != null) {
                                file4 = File.createTempFile("license", ".txt");
                                file4.getParentFile().mkdirs();
                                file4.deleteOnExit();
                                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                                object = new byte[4096];
                                n = 0;
                                while ((n = ((InputStream)object2).read((byte[])object)) > 0) {
                                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                                }
                                fileOutputStream.flush();
                                ((OutputStream)fileOutputStream).close();
                            } else {
                                Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.WARNING, "License resource {0} not found", object3);
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.WARNING, "Can`t parse URL", malformedURLException);
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.WARNING, "Input/Output error", iOException);
                        }
                        finally {
                            if (object2 != null) {
                                try {
                                    ((InputStream)object2).close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                }
                object3 = new Properties();
                object2 = nbMavenProject.getMavenProject().getParent().getBasedir();
                ((Properties)object3).put("suite.location", ((File)object2).getAbsolutePath().replace("\\", "/"));
                ((Properties)object3).put("suite.dist.zip", file2.getAbsolutePath().replace("\\", "/"));
                ((Properties)object3).put("suite.dist.directory", new File(file, "target").getAbsolutePath().replace("\\", "/"));
                ((Properties)object3).put("installer.build.dir", new File(file, "target/installerbuild").getAbsolutePath().replace("\\", "/"));
                ((Properties)object3).put("installers.file.prefix", nbMavenProject.getMavenProject().getArtifactId() + "-" + nbMavenProject.getMavenProject().getVersion());
                ((Properties)object3).put("suite.nbi.product.uid", string2.replaceAll("[0-9]+", "").replace("_", "-").toLowerCase(Locale.ENGLISH));
                ((Properties)object3).put("nbi.stub.location", InstalledFileLocator.getDefault().locate("nbi/stub", "org.netbeans.libs.nbi.ant", false).getAbsolutePath().replace("\\", "/"));
                ((Properties)object3).put("nbi.stub.common.location", InstalledFileLocator.getDefault().locate("nbi/.common", "org.netbeans.libs.nbi.ant", false).getAbsolutePath().replace("\\", "/"));
                ((Properties)object3).put("nbi.ant.tasks.jar", InstalledFileLocator.getDefault().locate("modules/ext/nbi-ant-tasks.jar", "org.netbeans.libs.nbi.ant", false).getAbsolutePath().replace("\\", "/"));
                ((Properties)object3).put("nbi.registries.management.jar", InstalledFileLocator.getDefault().locate("modules/ext/nbi-registries-management.jar", "org.netbeans.libs.nbi.ant", false).getAbsolutePath().replace("\\", "/"));
                ((Properties)object3).put("nbi.engine.jar", InstalledFileLocator.getDefault().locate("modules/ext/nbi-engine.jar", "org.netbeans.libs.nbi.engine", false).getAbsolutePath().replace("\\", "/"));
                if (file4 != null) {
                    Logger.getLogger(BuildInstallersAction.class.getName()).log(Level.FINE, "License file is at {0}, exist = {1}", new Object[]{file4, file4.exists()});
                    ((Properties)object3).put("nbi.license.file", file4.getAbsolutePath());
                }
                serializable = new ArrayList();
                boolean bl2 = false;
                for (byte by : (Object)new String[]{"os-windows", "os-linux", "os-solaris", "os-macosx"}) {
                    if (!preferences.getBoolean((String)by, false)) continue;
                    bl2 = true;
                    serializable.add(by.replaceFirst("^os-", ""));
                }
                if (!bl2) {
                    if (Utilities.isWindows()) {
                        serializable.add("windows");
                    } else if (Utilities.getOperatingSystem() == 16) {
                        serializable.add("linux");
                    } else if (Utilities.getOperatingSystem() == 8) {
                        serializable.add("solaris");
                    } else if (Utilities.isMac()) {
                        serializable.add("macosx");
                    }
                }
                object = new StringBuilder();
                for (n = 0; n < serializable.size(); ++n) {
                    if (n != 0) {
                        ((StringBuilder)object).append(" ");
                    }
                    ((StringBuilder)object).append((String)serializable.get(n));
                }
                if (((StringBuilder)object).length() == 0) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)NbBundle.getMessage(BuildInstallersAction.class, (String)"BuildInstallersAction.NotConfigured.Warning.Message"), NbBundle.getMessage(BuildInstallersAction.class, (String)"BuildInstallersAction.NotConfigured.Warning.Title"));
                            dialogDescriptor.setModal(true);
                            JButton jButton = new JButton(NbBundle.getMessage(BuildInstallersAction.class, (String)"BuildInstallersAction.NotConfigured.Warning.OK"));
                            jButton.setDefaultCapable(true);
                            dialogDescriptor.setOptions(new Object[]{jButton});
                            dialogDescriptor.setMessageType(2);
                            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(jButton)) {
                                // empty if block
                            }
                        }
                    });
                    return;
                }
                ((Properties)object3).put("generate.installer.for.platforms", ((StringBuilder)object).toString());
                File file5 = new File(System.getProperty("java.home"));
                if (new File(file5, "lib/rt.jar").exists() && file5.getName().equals("jre")) {
                    file5 = file5.getParentFile();
                }
                ((Properties)object3).put("generator-jdk-location-forward-slashes", file5.getAbsolutePath().replace("\\", "/"));
                ((Properties)object3).put("pack200.enabled", "" + bl);
                if (file3 != null) {
                    ((Properties)object3).put("nbi.dock.icon.file", file3.getAbsolutePath());
                }
                try {
                    ActionUtils.runTarget((FileObject)ContextBuildInstaller.findGenXml(), (String[])new String[]{"build"}, (Properties)object3);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().getInstance("org.netbeans.modules.apisupport.project").notify((Throwable)fileStateInvalidException);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().getInstance("org.netbeans.modules.apisupport.project").notify((Throwable)iOException);
                }
            }
        }

        private static FileObject findGenXml() {
            return FileUtil.toFileObject((File)InstalledFileLocator.getDefault().locate("nbi/stub/template.xml", "org.netbeans.libs.nbi.ant", false));
        }
    }
}

