/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.indicators.DetailDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.impl.TimeSeriesDescriptorAccessor;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;

public class Legend
extends JPanel {
    private final List<TimeSeriesDescriptor> graphs;
    private final List<DetailDescriptor> details;

    public Legend(List<TimeSeriesDescriptor> graphs, List<DetailDescriptor> details) {
        this.graphs = graphs;
        this.details = details;
        this.init(null);
    }

    private boolean hasInfoToPaint(TimeSeriesDescriptor graph, Collection<DataTableMetadata.Column> providedColumns) {
        TimeSeriesDescriptorAccessor accessor = TimeSeriesDescriptorAccessor.getDefault();
        if (providedColumns == null || providedColumns.isEmpty() || accessor.getSourceColumns(graph) == null || accessor.getSourceColumns(graph).isEmpty()) {
            return true;
        }
        ArrayList<DataTableMetadata.Column> list = new ArrayList<DataTableMetadata.Column>(providedColumns);
        list.retainAll(accessor.getSourceColumns(graph));
        return !list.isEmpty();
    }

    private void init(Collection<DataTableMetadata.Column> providedColumns) {
        GridBagConstraints c;
        this.removeAll();
        this.setLayout(new GridBagLayout());
        Font font = DLightUIPrefs.getFont((String)"indicator.legend.font");
        this.setBackground(DLightUIPrefs.getColor((String)"indicator.legend.bgcolor"));
        this.setBorder(BorderFactory.createLineBorder(DLightUIPrefs.getColor((String)"indicator.border.color")));
        Dimension size = new Dimension(DLightUIPrefs.getInt((String)"indicator.legend.width"), DLightUIPrefs.getInt((String)"indicator.legend.width"));
        this.setSize(size);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setOpaque(true);
        TimeSeriesDescriptorAccessor accessor = TimeSeriesDescriptorAccessor.getDefault();
        for (TimeSeriesDescriptor graph : this.graphs) {
            if (!this.hasInfoToPaint(graph, providedColumns)) continue;
            JLabel label = new JLabel(accessor.getDisplayName(graph), new ColorIcon(font.getSize(), accessor.getColor(graph)), 10);
            label.setFont(font);
            label.setForeground(DLightUIPrefs.getColor((String)"indicator.legend.font.color"));
            c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.insets = new Insets(4, 4, 0, 4);
            this.add((Component)label, c);
        }
        c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add(Box.createVerticalStrut(4), c);
        if (this.details != null) {
            for (DetailDescriptor detail : this.details) {
                JLabel name = new JLabel(detail.getDisplayName());
                name.setFont(font);
                name.setForeground(DLightUIPrefs.getColor((String)"indicator.legend.font.color"));
                c = new GridBagConstraints();
                c.anchor = 17;
                c.fill = 2;
                c.insets = new Insets(0, 4, 4, 4);
                this.add((Component)name, c);
                JLabel value = new JLabel(detail.getDefaultValue());
                value.setName(detail.getName());
                value.setForeground(DLightUIPrefs.getColor((String)"indicator.legend.font.color"));
                value.setFont(font.deriveFont(1));
                c = new GridBagConstraints();
                c.anchor = 17;
                c.fill = 2;
                c.gridwidth = 0;
                c.weightx = 1.0;
                c.insets = new Insets(0, 0, 4, 4);
                this.add((Component)value, c);
            }
        }
    }

    public void updateDetail(final String name, final String value) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateDetailImpl(name, value);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Legend.this.updateDetailImpl(name, value);
                }
            });
        }
    }

    public final void updateWithInfoProvided(Collection<DataTableMetadata.Column> columns) {
        this.init(columns);
        this.repaint();
    }

    private void updateDetailImpl(String name, String value) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component comp = this.getComponent(i);
            if (!(comp instanceof JLabel) || !name.equals(comp.getName())) continue;
            ((JLabel)comp).setText(value);
            this.repaint();
            break;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isEnabled()) {
            super.paintComponent(g);
        } else {
            g.setColor(DLightUIPrefs.getColor((String)"indicator.legend.bgcolor"));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (this.isEnabled()) {
            super.paintChildren(g);
        }
    }

    private static class ColorIcon
    implements Icon {
        private final int size;
        private final Color color;

        public ColorIcon(int size, Color color) {
            this.size = size;
            this.color = color;
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, this.size - 1, this.size - 1);
            g.setColor(DLightUIPrefs.getColor((String)"indicator.border.color"));
            g.drawRect(x, y, this.size - 1, this.size - 1);
        }
    }
}

