/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.logging.Logger;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrarySupport;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptorException;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class ClassBasedFaceletsLibrary
extends FaceletsLibrary {
    private final Collection<FaceletsLibrary.NamedComponent> components = new ArrayList<FaceletsLibrary.NamedComponent>();
    private final FileObject libraryDescriptorFile;
    private FaceletsLibraryDescriptor libraryDescriptor;
    private FileChangeListener FILE_CHANGE_LISTENER = new FileChangeAdapter(){

        public void fileChanged(FileEvent fileEvent) {
            ClassBasedFaceletsLibrary.this.support.libraryChanged(ClassBasedFaceletsLibrary.this);
        }
    };

    public ClassBasedFaceletsLibrary(URL uRL, FaceletsLibrarySupport faceletsLibrarySupport, String string) {
        super(faceletsLibrarySupport, string);
        if (uRL == null) {
            throw new NullPointerException("libraryDescriptorSourceURL cannot be null!");
        }
        this.libraryDescriptorFile = URLMapper.findFileObject((URL)uRL);
        if (this.libraryDescriptorFile == null) {
            Logger.getAnonymousLogger().info(String.format("Cannot convert facelets library descriptor's URL %s into a FileObject?!?!", uRL.toString()));
        } else {
            this.libraryDescriptorFile.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.FILE_CHANGE_LISTENER, (Object)this.libraryDescriptorFile));
            try {
                this.libraryDescriptor = FaceletsLibraryDescriptor.create(this.libraryDescriptorFile);
            }
            catch (LibraryDescriptorException libraryDescriptorException) {
                Exceptions.printStackTrace((Throwable)libraryDescriptorException);
            }
        }
    }

    void setComponents(Collection<FaceletsLibrary.NamedComponent> collection) {
        this.components.addAll(collection);
    }

    @Override
    public Collection<FaceletsLibrary.NamedComponent> getComponents() {
        return Collections.unmodifiableCollection(this.components);
    }

    @Override
    public LibraryDescriptor getLibraryDescriptor() {
        LibraryDescriptor libraryDescriptor = this.support.getJsfSupport().getLibraryDescriptor(this.getNamespace());
        return libraryDescriptor == null ? this.libraryDescriptor : libraryDescriptor;
    }

    public void putConverter(String string, String string2) {
        this.components.add(new FaceletsLibrary.Converter(this, string, string2, null));
    }

    public void putConverter(String string, String string2, Class clazz) {
        this.components.add(new FaceletsLibrary.Converter(this, string, string2, clazz));
    }

    public void putValidator(String string, String string2) {
        this.components.add(new FaceletsLibrary.Validator(this, string, string2, null));
    }

    public void putValidator(String string, String string2, Class clazz) {
        this.components.add(new FaceletsLibrary.Validator(this, string, string2, clazz));
    }

    public void putBehavior(String string, String string2) {
        this.components.add(new FaceletsLibrary.Behavior(this, string, string2, null));
    }

    public void putBehavior(String string, String string2, Class clazz) {
        this.components.add(new FaceletsLibrary.Behavior(this, string, string2, clazz));
    }

    public void putTagHandler(String string, Class clazz) {
        this.components.add(new FaceletsLibrary.TagHandler(this, string, clazz));
    }

    public void putComponent(String string, String string2, String string3) {
        this.components.add(new FaceletsLibrary.Component(this, string, string2, string3, null));
    }

    public void putComponent(String string, String string2, String string3, Class clazz) {
        this.components.add(new FaceletsLibrary.Component(this, string, string2, string3, clazz));
    }

    public void putUserTag(String string, URL uRL) {
        this.components.add(new FaceletsLibrary.UserTag(this, string, uRL));
    }

    public void putFunction(String string, Method method) {
        this.components.add(new FaceletsLibrary.Function(this, string, method));
    }

    public FaceletsLibrary.NamedComponent createNamedComponent(String string) {
        return new FaceletsLibrary.NamedComponent(this, string);
    }

    public FaceletsLibrary.Function createFunction(String string, Method method) {
        return new FaceletsLibrary.Function(this, string, method);
    }
}

