/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.subversion.Subversion;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;

public abstract class AbstractStep
implements WizardDescriptor.ValidatingPanel {
    private List<ChangeListener> listeners = new LinkedList<ChangeListener>();
    private boolean valid;
    private JComponent panel;
    private volatile boolean underConstruction;
    private WizardMessage errorMessage;
    private boolean isInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Component getComponent() {
        if (this.panel == null) {
            try {
                this.underConstruction = true;
                this.panel = this.createComponent();
                HelpCtx.setHelpIDString((JComponent)this.panel, (String)this.getClass().getName());
            }
            catch (RuntimeException ex) {
                Subversion.LOG.log(Level.SEVERE, null, ex);
            }
            finally {
                assert (this.panel != null);
                this.underConstruction = false;
                this.fireChange();
            }
        }
        return this.panel;
    }

    protected abstract JComponent createComponent();

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
    }

    protected final void valid() {
        this.setValid(true, null);
    }

    protected final void valid(WizardMessage msg) {
        this.setValid(true, msg);
    }

    protected final void invalid(WizardMessage msg) {
        this.setValid(false, msg);
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final WizardMessage getErrorMessage() {
        return this.errorMessage;
    }

    public final void validate() throws WizardValidationException {
        this.validateBeforeNext();
        if (!this.isValid() || this.errorMessage != null) {
            throw new WizardValidationException(this.panel, this.errorMessage.getMessage(), this.errorMessage.getMessage());
        }
    }

    protected abstract void validateBeforeNext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    private void setValid(boolean valid, WizardMessage msg) {
        boolean fire = this.valid != valid;
        boolean bl = msg != null && this.errorMessage == null || msg == null && this.errorMessage != null || msg != null && this.errorMessage != null && !msg.getMessage().equals(this.errorMessage.getMessage());
        this.valid = valid;
        this.errorMessage = msg;
        if (fire |= bl) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> clone;
        if (this.underConstruction) {
            return;
        }
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            clone = new ArrayList<ChangeListener>(this.listeners);
        }
        Iterator it = clone.iterator();
        ChangeEvent event = new ChangeEvent(this);
        while (it.hasNext()) {
            ChangeListener listener = (ChangeListener)it.next();
            listener.stateChanged(event);
        }
    }

    public class WizardMessage {
        private final boolean info;
        private final String msg;

        public WizardMessage(String msg, boolean isInfo) {
            this.info = isInfo;
            this.msg = msg;
        }

        public boolean isInfo() {
            return this.info;
        }

        public String getMessage() {
            return this.msg;
        }
    }
}

