/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.kenai;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JTextPane;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.notifications.NotificationsManager;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class KenaiNotificationListener
extends VCSKenaiAccessor.KenaiNotificationListener {
    protected void handleVCSNotification(VCSKenaiAccessor.VCSKenaiNotification notification) {
        if (notification.getService() != VCSKenaiAccessor.Service.VCS_SVN) {
            LOG.fine("rejecting VCS notification " + notification + " because not from svn");
            return;
        }
        File projectDir = notification.getProjectDirectory();
        if (!SvnUtils.isManaged(projectDir)) {
            assert (false) : " project " + projectDir + " not managed";
            LOG.fine("rejecting VCS notification " + notification + " for " + projectDir + " because not versioned by svn");
            return;
        }
        LOG.fine("accepting VCS notification " + notification + " for " + projectDir);
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        File[] files = cache.listFiles(new File[]{projectDir}, 22996);
        List modifications = notification.getModifications();
        LinkedList<File> notifyFiles = new LinkedList<File>();
        String revision = null;
        block4: for (File file : files) {
            String path;
            try {
                path = SvnUtils.getRepositoryPath(file);
            }
            catch (SVNClientException ex) {
                LOG.log(Level.WARNING, file.getAbsolutePath(), ex);
                continue;
            }
            path = this.trim(path);
            for (VCSKenaiAccessor.VCSKenaiModification modification : modifications) {
                String resource = modification.getResource();
                LOG.finer(" changed file " + path + ", " + resource);
                if (!path.equals(resource = this.trim(resource))) continue;
                LOG.fine("  will notify " + file + ", " + notification);
                notifyFiles.add(file);
                if (revision != null) continue block4;
                revision = modification.getId();
                continue block4;
            }
        }
        if (notifyFiles.size() > 0) {
            this.notifyFileChange(notifyFiles.toArray(new File[notifyFiles.size()]), projectDir, notification.getUri().toString(), revision);
            try {
                NotificationsManager.getInstance().notfied(files, Long.parseLong(revision));
            }
            catch (NumberFormatException e) {
                LOG.log(Level.WARNING, revision, e);
            }
        }
    }

    protected void setupPane(JTextPane pane, File[] files, File projectDir, String url, String revision) {
        NotificationsManager.getInstance().setupPane(pane, files, this.getFileNames(files), projectDir, url, revision);
    }
}

