/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.maven.model.Dependency;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.ui.nodes.ArtifactNode;
import org.netbeans.modules.maven.hints.ui.nodes.VersionNode;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SearchDependencyUI
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager explorerManager = new ExplorerManager();
    private JButton addButton = new JButton(NbBundle.getMessage(SearchDependencyUI.class, (String)"BTN_Add"));
    private BeanTreeView beanTreeView;
    private NBVersionInfo nbvi;
    private RequestProcessor.Task task;
    private boolean retrigger = false;
    private Project project;
    private JLabel lblClassName;
    private JLabel lblMatchingArtifacts;
    private JLabel lblSelected;
    private JScrollPane treeView;
    private JTextField txtClassName;

    public SearchDependencyUI(String string, Project project) {
        this.initComponents();
        this.project = project;
        this.beanTreeView = (BeanTreeView)this.treeView;
        this.beanTreeView.setPopupAllowed(false);
        this.beanTreeView.setRootVisible(false);
        this.addButton.setEnabled(false);
        this.txtClassName.setText(string);
        this.txtClassName.selectAll();
        this.explorerManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                    Node[] nodeArray;
                    for (Node node : nodeArray = SearchDependencyUI.this.explorerManager.getSelectedNodes()) {
                        if (node instanceof VersionNode) {
                            SearchDependencyUI.this.nbvi = ((VersionNode)node).getNBVersionInfo();
                            break;
                        }
                        if (!(node instanceof ArtifactNode)) continue;
                        NBVersionInfo nBVersionInfo = null;
                        ArtifactNode artifactNode = (ArtifactNode)node;
                        List<NBVersionInfo> list = artifactNode.getVersionInfos();
                        for (NBVersionInfo nBVersionInfo2 : list) {
                            if (nBVersionInfo != null && nBVersionInfo2.getVersion().compareTo(nBVersionInfo.getVersion()) <= 0) continue;
                            nBVersionInfo = nBVersionInfo2;
                        }
                        SearchDependencyUI.this.nbvi = nBVersionInfo;
                    }
                    if (SearchDependencyUI.this.nbvi != null) {
                        SearchDependencyUI.this.lblSelected.setText(SearchDependencyUI.this.nbvi.getGroupId() + " : " + SearchDependencyUI.this.nbvi.getArtifactId() + " : " + SearchDependencyUI.this.nbvi.getVersion() + " [ " + SearchDependencyUI.this.nbvi.getType() + (SearchDependencyUI.this.nbvi.getClassifier() != null ? "," + SearchDependencyUI.this.nbvi.getClassifier() : "") + " ]");
                    } else {
                        SearchDependencyUI.this.lblSelected.setText(null);
                    }
                    SearchDependencyUI.this.addButton.setEnabled(SearchDependencyUI.this.nbvi != null);
                }
            }
        });
        this.explorerManager.setRootContext(SearchDependencyUI.createEmptyNode());
        this.load();
        this.txtClassName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SearchDependencyUI.this.load();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SearchDependencyUI.this.load();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SearchDependencyUI.this.load();
            }
        });
    }

    public NBVersionInfo getSelectedVersion() {
        return this.nbvi;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public synchronized void load() {
        if (this.task == null) {
            this.task = RequestProcessor.getDefault().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Node node;
                    Object object;
                    final String[] stringArray = new String[1];
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                SearchDependencyUI.this.lblSelected.setText(null);
                                SearchDependencyUI.this.beanTreeView.setRootVisible(true);
                                stringArray[0] = SearchDependencyUI.this.getClassSearchName();
                            }
                        });
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                    boolean bl = false;
                    SearchDependencyUI.this.explorerManager.setRootContext(SearchDependencyUI.createLoadingNode());
                    if (stringArray[0].length() > 0) {
                        ArrayList<NBVersionInfo> arrayList;
                        Object object2;
                        NBVersionInfo nBVersionInfo;
                        object = RepositoryQueries.findVersionsByClass((String)stringArray[0], (RepositoryInfo[])new RepositoryInfo[0]);
                        Serializable serializable = SearchDependencyUI.this;
                        synchronized (serializable) {
                            if (SearchDependencyUI.this.retrigger) {
                                SearchDependencyUI.this.retrigger = false;
                                SearchDependencyUI.this.task.schedule(20);
                                return;
                            }
                        }
                        serializable = new HashMap();
                        Set set = object.iterator();
                        while (set.hasNext()) {
                            nBVersionInfo = (NBVersionInfo)set.next();
                            object2 = nBVersionInfo.getGroupId() + " : " + nBVersionInfo.getArtifactId();
                            arrayList = (ArrayList<NBVersionInfo>)serializable.get(object2);
                            if (arrayList == null) {
                                arrayList = new ArrayList<NBVersionInfo>();
                                serializable.put(object2, arrayList);
                            }
                            arrayList.add(nBVersionInfo);
                        }
                        set = serializable.keySet();
                        if (set.size() > 0) {
                            nBVersionInfo = new Children.Array();
                            node = new AbstractNode((Children)nBVersionInfo);
                            object2 = new ArrayList(set);
                            Collections.sort(object2, new HeuristicsComparator());
                            arrayList = object2.iterator();
                            while (arrayList.hasNext()) {
                                String string = (String)arrayList.next();
                                nBVersionInfo.add(new Node[]{new ArtifactNode(string, (List)serializable.get(string))});
                            }
                            bl = false;
                        } else {
                            node = SearchDependencyUI.createEmptyNode();
                            bl = true;
                        }
                    } else {
                        node = SearchDependencyUI.createEmptyNode();
                        bl = true;
                    }
                    object = node;
                    final boolean bl2 = bl;
                    SwingUtilities.invokeLater(new Runnable((Node)object){
                        final /* synthetic */ Node val$fNode;
                        {
                            this.val$fNode = node;
                        }

                        @Override
                        public void run() {
                            SearchDependencyUI.this.beanTreeView.setRootVisible(bl2);
                            SearchDependencyUI.this.explorerManager.setRootContext(this.val$fNode);
                        }
                    });
                }
            }, true);
        }
        if (!this.task.isFinished() && this.task.getDelay() == 0) {
            this.retrigger = true;
        } else {
            this.task.schedule(500);
        }
    }

    public String getClassSearchName() {
        return this.txtClassName.getText().trim();
    }

    private void initComponents() {
        this.lblClassName = new JLabel();
        this.txtClassName = new JTextField();
        this.treeView = new BeanTreeView();
        this.lblMatchingArtifacts = new JLabel();
        this.lblSelected = new JLabel();
        this.lblClassName.setText(NbBundle.getMessage(SearchDependencyUI.class, (String)"LBL_Class_Name"));
        this.treeView.setBorder(BorderFactory.createEtchedBorder(null, UIManager.getDefaults().getColor("ComboBox.selectionBackground")));
        this.lblMatchingArtifacts.setText(NbBundle.getMessage(SearchDependencyUI.class, (String)"LBL_Matching_artifacts"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.lblSelected, -2, 430, -2).add(1, (Component)this.treeView, -1, 430, Short.MAX_VALUE).add((Component)this.txtClassName, -1, 430, Short.MAX_VALUE).add(1, (Component)this.lblMatchingArtifacts, -1, 430, Short.MAX_VALUE).add(1, (Component)this.lblClassName, -1, 430, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.lblClassName).addPreferredGap(0).add((Component)this.txtClassName, -2, -1, -2).addPreferredGap(0).add((Component)this.lblMatchingArtifacts).addPreferredGap(0).add((Component)this.treeView, -1, 214, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lblSelected, -2, 14, -2)));
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public static Node createLoadingNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF){

            public Image getIcon(int n) {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/hints/wait.gif");
            }

            public Image getOpenedIcon(int n) {
                return this.getIcon(n);
            }
        };
        abstractNode.setName("Loading");
        abstractNode.setDisplayName(NbBundle.getMessage(SearchDependencyUI.class, (String)"Node_Loading"));
        return abstractNode;
    }

    public static Node createEmptyNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF){

            public Image getIcon(int n) {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/hints/empty.png");
            }

            public Image getOpenedIcon(int n) {
                return this.getIcon(n);
            }
        };
        abstractNode.setName("Empty");
        abstractNode.setDisplayName(NbBundle.getMessage(SearchDependencyUI.class, (String)"Node_Empty"));
        return abstractNode;
    }

    private class HeuristicsComparator
    implements Comparator<String> {
        private Set<String> privilegedGroupIds = new HashSet<String>();

        private HeuristicsComparator() {
            String string = ((NbMavenProject)SearchDependencyUI.this.project.getLookup().lookup(NbMavenProject.class)).getPackagingType();
            if ("nbm".equalsIgnoreCase(string)) {
                this.privilegedGroupIds.add("org.netbeans.api");
            }
            if ("war".equalsIgnoreCase(string) || "ear".equalsIgnoreCase(string) || "ejb".equalsIgnoreCase(string)) {
                this.privilegedGroupIds.add("javax.activation");
                this.privilegedGroupIds.add("javax.ejb");
                this.privilegedGroupIds.add("javax.faces");
                this.privilegedGroupIds.add("javax.j2ee");
                this.privilegedGroupIds.add("javax.jdo");
                this.privilegedGroupIds.add("javax.jms");
                this.privilegedGroupIds.add("javax.mail");
                this.privilegedGroupIds.add("javax.management");
                this.privilegedGroupIds.add("javax.naming");
                this.privilegedGroupIds.add("javax.persistence");
                this.privilegedGroupIds.add("javax.portlet");
                this.privilegedGroupIds.add("javax.resource");
                this.privilegedGroupIds.add("javax.security");
                this.privilegedGroupIds.add("javax.servlet");
                this.privilegedGroupIds.add("javax.sql");
                this.privilegedGroupIds.add("javax.transaction");
                this.privilegedGroupIds.add("javax.xml");
            }
            NbMavenProject nbMavenProject = (NbMavenProject)SearchDependencyUI.this.project.getLookup().lookup(NbMavenProject.class);
            List list = nbMavenProject.getMavenProject().getDependencies();
            for (Dependency dependency : list) {
                this.privilegedGroupIds.add(dependency.getGroupId());
            }
        }

        @Override
        public int compare(String string, String string2) {
            String[] stringArray = string.split(":");
            String[] stringArray2 = string2.split(":");
            boolean bl = this.privilegedGroupIds.contains(stringArray[0].trim());
            boolean bl2 = this.privilegedGroupIds.contains(stringArray2[0].trim());
            if (bl && !bl2) {
                return -1;
            }
            if (!bl && bl2) {
                return 1;
            }
            return string.compareTo(string2);
        }
    }
}

