/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.filemodels;

import com.sun.javacard.AID;
import com.sun.javacard.filemodels.DeploymentXmlInstanceEntry;
import com.sun.javacard.filemodels.FileModel;
import com.sun.javacard.filemodels.FileModelEntry;
import com.sun.javacard.filemodels.ParseErrorHandler;
import com.sun.javacard.filemodels.WrapperParseErrorHandler;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeploymentXmlAppletEntry
extends FileModel<DeploymentXmlInstanceEntry>
implements FileModelEntry,
Cloneable {
    private int order;
    private String clazzHint;
    private AID appletAid;
    private String displayNameHint;

    public DeploymentXmlAppletEntry() {
    }

    public DeploymentXmlAppletEntry(Element appletElement, int order, ParseErrorHandler handler) throws IOException {
        if (handler == null) {
            handler = ParseErrorHandler.DEFAULT;
        }
        handler = new WrapperParseErrorHandler(handler, this);
        this.order = order;
        NodeList kids = appletElement.getChildNodes();
        int len = kids.getLength();
        int instanceOrder = 0;
        for (int i = 0; i < len; ++i) {
            Node nd = kids.item(i);
            if (nd.getNodeType() != 1) continue;
            Element child = (Element)nd;
            if ("applet-AID".equals(child.getNodeName())) {
                String aidString = child.getTextContent();
                try {
                    AID aid = AID.parse(aidString);
                    this.setAppletAid(aid);
                }
                catch (IllegalArgumentException e) {
                    handler.handleBadAIDError(e, aidString);
                }
                continue;
            }
            if ("class-name-hint".equals(child.getNodeName())) {
                this.setClazzHint(child.getTextContent());
                continue;
            }
            if ("display-name-hint".equals(child.getNodeName())) {
                this.setDisplayNameHint(child.getTextContent());
                continue;
            }
            if ("instance".equals(child.getNodeName())) {
                this.add(new DeploymentXmlInstanceEntry(child, instanceOrder, handler));
                ++instanceOrder;
                continue;
            }
            handler.unrecognizedElementEncountered(child.getNodeName());
        }
    }

    @Override
    public void remove(DeploymentXmlInstanceEntry e) {
        super.remove(e);
    }

    public Object clone() {
        DeploymentXmlAppletEntry nue = new DeploymentXmlAppletEntry();
        nue.order = this.order;
        nue.clazzHint = this.clazzHint;
        nue.appletAid = this.appletAid;
        nue.displayNameHint = this.displayNameHint;
        for (DeploymentXmlInstanceEntry e : this.getData()) {
            nue.add((DeploymentXmlInstanceEntry)e.clone());
        }
        return nue;
    }

    public String getClazzHint() {
        return this.clazzHint;
    }

    public void setClazzHint(String clazzHint) {
        this.clazzHint = clazzHint;
    }

    public AID getAppletAid() {
        return this.appletAid;
    }

    public void setAppletAid(AID appletAid) {
        this.appletAid = appletAid;
    }

    public String getDisplayNameHint() {
        return this.displayNameHint;
    }

    public void setDisplayNameHint(String displayNameHint) {
        this.displayNameHint = displayNameHint;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public String toXml() {
        StringBuilder sb = new StringBuilder("    <applet>\n");
        sb.append("        <applet-AID>");
        sb.append(this.getAppletAid());
        sb.append("</applet-AID>\n");
        sb.append("        <class-name-hint>");
        sb.append(this.getClazzHint());
        sb.append("</class-name-hint>\n");
        sb.append("        <display-name-hint>");
        sb.append(this.getDisplayNameHint());
        sb.append("</display-name-hint>\n");
        for (DeploymentXmlInstanceEntry e : this.getData()) {
            sb.append(e.toXml());
        }
        sb.append("    </applet>\n");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        boolean result = super.equals(obj);
        if (result) {
            DeploymentXmlAppletEntry other = (DeploymentXmlAppletEntry)obj;
            boolean bl = result = this.order == other.order;
            if (result) {
                result = this.appletAid == null ? other.appletAid == null : this.appletAid == other.appletAid || this.appletAid.equals(other.appletAid);
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + this.order;
        hash = 53 * hash + (this.appletAid != null ? this.appletAid.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(FileModelEntry o) {
        assert (o == null || this.getClass() == o.getClass());
        return o == null ? 0 : this.getOrder() - o.getOrder();
    }
}

