/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class FieldsDeclaration
extends BodyDeclaration {
    private final ArrayList<SingleFieldDeclaration> fields = new ArrayList();

    public FieldsDeclaration(int start, int end, int modifier, List variablesAndDefaults) {
        super(start, end, modifier);
        if (variablesAndDefaults == null || variablesAndDefaults.size() == 0) {
            throw new IllegalArgumentException();
        }
        for (Object next : variablesAndDefaults) {
            if (next instanceof SingleFieldDeclaration) {
                this.fields.add((SingleFieldDeclaration)next);
                continue;
            }
            ASTNode[] element = (ASTNode[])next;
            SingleFieldDeclaration field = this.createField((Variable)element[0], (Expression)element[1]);
            this.fields.add(field);
        }
    }

    private SingleFieldDeclaration createField(Variable name, Expression value) {
        int start = name.getStartOffset();
        int end = value == null ? name.getEndOffset() : value.getEndOffset();
        SingleFieldDeclaration result = new SingleFieldDeclaration(start, end, name, value);
        return result;
    }

    public List<SingleFieldDeclaration> getFields() {
        return this.fields;
    }

    public Expression[] getInitialValues() {
        Expression[] result = new Expression[this.fields.size()];
        int i = 0;
        for (SingleFieldDeclaration field : this.fields) {
            result[i++] = field.getValue();
        }
        return result;
    }

    public Variable[] getVariableNames() {
        Variable[] result = new Variable[this.fields.size()];
        int i = 0;
        for (SingleFieldDeclaration field : this.fields) {
            result[i++] = field.getName();
        }
        return result;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

