/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.UseElement;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.openide.util.ImageUtilities;

public class PhpStructureScanner
implements StructureScanner {
    private static ImageIcon INTERFACE_ICON = null;
    private static final String FOLD_CODE_BLOCKS = "codeblocks";
    private static final String FOLD_CLASS = "tags";
    private static final String FOLD_PHPDOC = "comments";
    private static final String FOLD_COMMENT = "initial-comment";
    private static final String FONT_GRAY_COLOR = "<font color=\"#999999\">";
    private static final String CLOSE_FONT = "</font>";
    private static final String LAST_CORRECT_FOLDING_PROPERTY = "LAST_CORRECT_FOLDING_PROPERY";

    public List<? extends StructureItem> scan(ParserResult info) {
        ArrayList<PHPNamespaceStructureItem> items = new ArrayList<PHPNamespaceStructureItem>();
        PHPParseResult result = (PHPParseResult)info;
        Model model = result.getModel();
        FileScope fileScope = model.getFileScope();
        Collection<? extends NamespaceScope> declaredNamespaces = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : declaredNamespaces) {
            ArrayList<PHPNamespaceStructureItem> namespaceChildren;
            ArrayList<PHPNamespaceStructureItem> arrayList = namespaceChildren = namespaceScope.isDefaultNamespace() ? items : new ArrayList<PHPNamespaceStructureItem>();
            if (!namespaceScope.isDefaultNamespace()) {
                items.add(new PHPNamespaceStructureItem(namespaceScope, namespaceChildren));
            }
            Collection<? extends UseElement> declaredUses = namespaceScope.getDeclaredUses();
            for (UseElement useElement : declaredUses) {
                namespaceChildren.add((PHPNamespaceStructureItem)((Object)new PHPUseStructureItem(useElement)));
            }
            Collection<? extends FunctionScope> declaredFunctions = namespaceScope.getDeclaredFunctions();
            for (FunctionScope functionScope : declaredFunctions) {
                if (functionScope.isAnonymous()) continue;
                ArrayList arrayList2 = new ArrayList();
                namespaceChildren.add((PHPNamespaceStructureItem)((Object)new PHPFunctionStructureItem(functionScope, arrayList2)));
            }
            Collection<? extends ConstantElement> collection = namespaceScope.getDeclaredConstants();
            for (ConstantElement constantElement : collection) {
                namespaceChildren.add((PHPNamespaceStructureItem)((Object)new PHPConstantStructureItem(constantElement, "const")));
            }
            Collection<? extends TypeScope> collection2 = namespaceScope.getDeclaredTypes();
            for (TypeScope typeScope : collection2) {
                ArrayList<PHPStructureItem> children = new ArrayList<PHPStructureItem>();
                if (typeScope instanceof ClassScope) {
                    namespaceChildren.add((PHPNamespaceStructureItem)((Object)new PHPClassStructureItem((ClassScope)typeScope, children)));
                } else if (typeScope instanceof InterfaceScope) {
                    namespaceChildren.add((PHPNamespaceStructureItem)((Object)new PHPInterfaceStructureItem((InterfaceScope)typeScope, children)));
                }
                Collection<? extends MethodScope> declaredMethods = typeScope.getDeclaredMethods();
                for (MethodScope methodScope : declaredMethods) {
                    ArrayList arrayList3 = new ArrayList();
                    if (methodScope.isConstructor()) {
                        children.add(new PHPConstructorStructureItem(methodScope, arrayList3));
                        continue;
                    }
                    children.add(new PHPMethodStructureItem(methodScope, arrayList3));
                }
                Collection<? extends ClassConstantElement> declaredClsConstants = typeScope.getDeclaredConstants();
                for (ClassConstantElement classConstantElement : declaredClsConstants) {
                    children.add(new PHPConstantStructureItem(classConstantElement, "con"));
                }
                if (!(typeScope instanceof ClassScope)) continue;
                ClassScope classScope = (ClassScope)typeScope;
                Collection<? extends FieldElement> collection3 = classScope.getDeclaredFields();
                for (FieldElement fieldElement : collection3) {
                    children.add(new PHPFieldStructureItem(fieldElement));
                }
            }
        }
        return items;
    }

    public Map<String, List<OffsetRange>> folds(ParserResult info) {
        HashMap<String, List<OffsetRange>> folds = new HashMap<String, List<OffsetRange>>();
        Program program = Utils.getRoot(info);
        if (program != null) {
            if (program.getStatements().size() == 1 && program.getStatements().get(0) instanceof ASTError) {
                Map lastCorrect;
                Document document = info.getSnapshot().getSource().getDocument(false);
                Map map = lastCorrect = document != null ? (Map)document.getProperty(LAST_CORRECT_FOLDING_PROPERTY) : null;
                if (lastCorrect != null) {
                    return lastCorrect;
                }
                return Collections.emptyMap();
            }
            List<Comment> comments = program.getComments();
            if (comments != null) {
                for (Comment comment : comments) {
                    if (comment.getCommentType() == Comment.Type.TYPE_PHPDOC) {
                        this.getRanges(folds, FOLD_PHPDOC).add(this.createOffsetRange(comment));
                        continue;
                    }
                    if (comment.getCommentType() != Comment.Type.TYPE_MULTILINE) continue;
                    this.getRanges(folds, FOLD_COMMENT).add(this.createOffsetRange(comment));
                }
            }
            PHPParseResult result = (PHPParseResult)info;
            Model model = result.getModel();
            FileScope fileScope = model.getFileScope();
            List<Scope> scopes = this.getEmbededScopes(fileScope, null);
            for (Scope scope : scopes) {
                OffsetRange offsetRange = scope.getBlockRange();
                if (offsetRange == null) continue;
                if (scope instanceof TypeScope) {
                    this.getRanges(folds, FOLD_CLASS).add(offsetRange);
                    continue;
                }
                if (!(scope instanceof FunctionScope) && !(scope instanceof MethodScope)) continue;
                this.getRanges(folds, FOLD_CODE_BLOCKS).add(offsetRange);
            }
            Source source = info.getSnapshot().getSource();
            assert (source != null) : "source was null";
            Document doc = source.getDocument(false);
            if (doc != null) {
                doc.putProperty(LAST_CORRECT_FOLDING_PROPERTY, folds);
            }
            return folds;
        }
        return Collections.emptyMap();
    }

    private OffsetRange createOffsetRange(ASTNode node) {
        return new OffsetRange(node.getStartOffset(), node.getEndOffset());
    }

    private List<OffsetRange> getRanges(Map<String, List<OffsetRange>> folds, String kind) {
        List<OffsetRange> ranges = folds.get(kind);
        if (ranges == null) {
            ranges = new ArrayList<OffsetRange>();
            folds.put(kind, ranges);
        }
        return ranges;
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(true, true);
    }

    private List<Scope> getEmbededScopes(Scope scope, List<Scope> collectedScopes) {
        if (collectedScopes == null) {
            collectedScopes = new ArrayList<Scope>();
        }
        List<? extends ModelElement> elements = scope.getElements();
        for (ModelElement modelElement : elements) {
            if (!(modelElement instanceof Scope)) continue;
            collectedScopes.add((Scope)modelElement);
            this.getEmbededScopes((Scope)modelElement, collectedScopes);
        }
        return collectedScopes;
    }

    private class PHPConstructorStructureItem
    extends PHPStructureItem {
        public PHPConstructorStructureItem(MethodScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "con");
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }

        public MethodScope getMethodScope() {
            return (MethodScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            this.appendFunctionDescription(this.getMethodScope(), formatter);
            return formatter.getText();
        }
    }

    private class PHPInterfaceStructureItem
    extends PHPStructureItem {
        private static final String PHP_INTERFACE_ICON = "org/netbeans/modules/php/editor/resources/interface.png";

        public PHPInterfaceStructureItem(InterfaceScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "cl");
        }

        @Override
        public ImageIcon getCustomIcon() {
            if (INTERFACE_ICON == null) {
                INTERFACE_ICON = new ImageIcon(ImageUtilities.loadImage((String)PHP_INTERFACE_ICON));
            }
            return INTERFACE_ICON;
        }

        public InterfaceScope getInterfaceScope() {
            return (InterfaceScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            formatter.appendText(this.getElementHandle().getName());
            Collection<? extends String> interfaes = this.getInterfaceScope().getSuperInterfaceNames();
            if (interfaes != null && interfaes.size() > 0) {
                formatter.appendHtml("<font color=\"#999999\">::");
                this.appendInterfeas(interfaes, formatter);
                formatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }
    }

    private class PHPMethodStructureItem
    extends PHPStructureItem {
        public PHPMethodStructureItem(MethodScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "fn");
        }

        public MethodScope getMethodScope() {
            return (MethodScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            this.appendFunctionDescription(this.getMethodScope(), formatter);
            return formatter.getText();
        }
    }

    private class PHPFunctionStructureItem
    extends PHPStructureItem {
        public PHPFunctionStructureItem(FunctionScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "fn");
        }

        public FunctionScope getFunctionScope() {
            return (FunctionScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            this.appendFunctionDescription(this.getFunctionScope(), formatter);
            return formatter.getText();
        }
    }

    private class PHPConstantStructureItem
    extends PHPStructureItem {
        public PHPConstantStructureItem(ConstantElement elementHandle, String prefix) {
            super(elementHandle, null, prefix);
        }

        public ConstantElement getConstant() {
            return (ConstantElement)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            formatter.appendText(this.getName());
            ConstantElement constant = this.getConstant();
            String value = constant.getValue();
            if (value != null) {
                formatter.appendText(" ");
                formatter.appendHtml(PhpStructureScanner.FONT_GRAY_COLOR);
                formatter.appendText(value);
                formatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }
    }

    private class PHPClassStructureItem
    extends PHPStructureItem {
        public PHPClassStructureItem(ClassScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "cl");
        }

        public ClassScope getClassScope() {
            return (ClassScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            Collection<? extends String> interfaes;
            formatter.reset();
            formatter.appendText(this.getName());
            String superCalssName = ModelUtils.getFirst(this.getClassScope().getSuperClassNames());
            if (superCalssName != null) {
                formatter.appendHtml("<font color=\"#999999\">::");
                formatter.appendText(superCalssName);
                formatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
            }
            if ((interfaes = this.getClassScope().getSuperInterfaceNames()) != null && interfaes.size() > 0) {
                formatter.appendHtml("<font color=\"#999999\">:");
                this.appendInterfeas(interfaes, formatter);
                formatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }
    }

    private class PHPUseStructureItem
    extends PHPStructureItem {
        public PHPUseStructureItem(UseElement elementHandle) {
            super(elementHandle, null, "aaaa_use");
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            formatter.appendText(this.getName());
            UseElement useElement = (UseElement)this.getElementHandle();
            if (useElement.getAliasName() != null) {
                formatter.appendText(" as ");
                formatter.appendText(useElement.getAliasName());
            }
            return formatter.getText();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.RULE;
        }
    }

    private class PHPNamespaceStructureItem
    extends PHPStructureItem {
        public PHPNamespaceStructureItem(NamespaceScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "namespace");
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            formatter.appendText(this.getName());
            return formatter.getText();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.MODULE;
        }
    }

    private class PHPSimpleStructureItem
    extends PHPStructureItem {
        private String simpleText;

        public PHPSimpleStructureItem(ModelElement elementHandle, String prefix) {
            super(elementHandle, null, prefix);
            this.simpleText = elementHandle.getName();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.appendText(this.simpleText);
            return formatter.getText();
        }
    }

    private class PHPFieldStructureItem
    extends PHPSimpleStructureItem {
        public PHPFieldStructureItem(ModelElement elementHandle) {
            super(elementHandle, "field");
        }

        @Override
        public String getHtml(HtmlFormatter formatter) {
            ElementHandle elementHandle = this.getElementHandle();
            formatter.appendText(elementHandle.getName());
            if (elementHandle instanceof FieldElement) {
                FieldElement fieldElement = (FieldElement)elementHandle;
                Collection<? extends String> types = fieldElement.getDefaultTypeNames();
                StringBuilder sb = null;
                if (!types.isEmpty()) {
                    formatter.appendHtml("<font color=\"#999999\">:");
                    for (String string : types) {
                        if (sb == null) {
                            sb = new StringBuilder();
                        } else {
                            sb.append(", ");
                        }
                        sb.append(string);
                    }
                    formatter.appendText(sb.toString());
                    formatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
                }
            }
            return formatter.getText();
        }
    }

    private abstract class PHPStructureItem
    implements StructureItem {
        private final ModelElement modelElement;
        private final List<? extends StructureItem> children;
        private final String sortPrefix;

        public PHPStructureItem(ModelElement elementHandle, List<? extends StructureItem> children, String sortPrefix) {
            this.modelElement = elementHandle;
            this.sortPrefix = sortPrefix;
            this.children = children != null ? children : Collections.emptyList();
        }

        public boolean equals(Object obj) {
            PHPStructureItem item;
            boolean thesame = false;
            if (obj instanceof PHPStructureItem && (item = (PHPStructureItem)obj).getName() != null && this.getName() != null) {
                thesame = item.modelElement.getName().equals(this.modelElement.getName()) && item.modelElement.getOffset() == this.modelElement.getOffset();
            }
            return thesame;
        }

        public int hashCode() {
            int hashCode = 11;
            if (this.getName() != null) {
                hashCode = 31 * this.getName().hashCode() + hashCode;
            }
            hashCode = (int)(31L * this.getPosition() + (long)hashCode);
            return hashCode;
        }

        public String getName() {
            return this.modelElement.getName();
        }

        public String getSortText() {
            return this.sortPrefix + this.modelElement.getName();
        }

        public ElementHandle getElementHandle() {
            return this.modelElement.getPHPElement();
        }

        public ModelElement getModelElement() {
            return this.modelElement;
        }

        public ElementKind getKind() {
            return this.modelElement.getPHPElement().getKind();
        }

        public Set<Modifier> getModifiers() {
            return this.modelElement.getPHPElement().getModifiers();
        }

        public boolean isLeaf() {
            return this.children.size() == 0;
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.children;
        }

        public long getPosition() {
            return this.modelElement.getOffset();
        }

        public long getEndPosition() {
            OffsetRange blockRange;
            if (this.modelElement instanceof Scope && (blockRange = ((Scope)this.modelElement).getBlockRange()) != null) {
                return blockRange.getEnd();
            }
            return this.modelElement.getNameRange().getEnd();
        }

        public ImageIcon getCustomIcon() {
            return null;
        }

        protected void appendInterfeas(Collection<? extends String> interfaes, HtmlFormatter formatter) {
            boolean first = true;
            for (String string : interfaes) {
                if (string == null) continue;
                if (!first) {
                    formatter.appendText(", ");
                } else {
                    first = false;
                }
                formatter.appendText(string);
            }
        }

        protected void appendFunctionDescription(FunctionScope function, HtmlFormatter formatter) {
            formatter.reset();
            if (function == null) {
                return;
            }
            formatter.appendText(function.getName());
            formatter.appendText("(");
            List<? extends ParameterElement> parameters = function.getParameters();
            if (parameters != null && parameters.size() > 0) {
                boolean first = true;
                for (ParameterElement parameterElement : parameters) {
                    String string = parameterElement.getName();
                    Set<TypeResolver> types = parameterElement.getTypes();
                    if (string == null) continue;
                    if (!first) {
                        formatter.appendText(", ");
                    }
                    if (!types.isEmpty()) {
                        formatter.appendHtml(PhpStructureScanner.FONT_GRAY_COLOR);
                        StringBuilder typeSb = new StringBuilder();
                        for (TypeResolver typeResolver : types) {
                            QualifiedName typeName;
                            if (!typeResolver.isResolved() || (typeName = typeResolver.getTypeName(false)) == null) continue;
                            if (typeSb.length() > 0) {
                                typeSb.append("|");
                            }
                            typeSb.append(typeName.toString());
                        }
                        if (typeSb.length() > 0) {
                            formatter.appendText(typeSb.toString());
                        }
                        formatter.appendText(" ");
                        formatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
                    }
                    formatter.appendText(string);
                    first = false;
                }
            }
            formatter.appendText(")");
            Collection<? extends String> returnTypes = function.getReturnTypeNames();
            if (!returnTypes.isEmpty()) {
                formatter.appendHtml("<font color=\"#999999\">:");
                StringBuilder sb = null;
                for (String string : returnTypes) {
                    if (sb == null) {
                        sb = new StringBuilder();
                    } else {
                        sb.append(", ");
                    }
                    sb.append(string);
                }
                formatter.appendText(sb.toString());
                formatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
            }
        }
    }
}

