/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.Parameter;
import org.openide.util.Exceptions;

public class ParameterImpl
implements Parameter {
    private String name;
    private String defaultValue;
    private List<QualifiedName> types;
    private OffsetRange range;
    private boolean isRawType;

    public ParameterImpl(String name, String defaultValue, List<QualifiedName> types, boolean isRawType, OffsetRange range) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.types = types == null ? Collections.emptyList() : types;
        this.range = range;
        this.isRawType = isRawType;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isMandatory() {
        return this.defaultValue == null;
    }

    @Override
    public List<QualifiedName> getTypes() {
        return this.types;
    }

    @Override
    public OffsetRange getOffsetRange() {
        return this.range;
    }

    @Override
    public String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(":");
        List<QualifiedName> qNames = this.getTypes();
        for (int idx = 0; idx < qNames.size(); ++idx) {
            if (idx > 0) {
                sb.append('|');
            }
            QualifiedName qualifiedName = qNames.get(idx);
            sb.append(qualifiedName.toString());
        }
        sb.append(":");
        sb.append(this.isRawType ? 1 : 0);
        sb.append(":");
        String defValue = this.getDefaultValue();
        if (defValue != null) {
            sb.append(ParameterImpl.encode(defValue));
        }
        return sb.toString();
    }

    public static List<Parameter> toParameters(String args) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (args != null && args.length() > 0) {
            String[] pams;
            for (String par : pams = args.split("\\,")) {
                String[] parts = par.split("\\:");
                if (parts.length <= 0) continue;
                String paramName = parts[0];
                ArrayList<QualifiedName> qualifiedNames = new ArrayList<QualifiedName>();
                if (parts.length > 1) {
                    String[] splittedTypes;
                    String typenames = parts[1];
                    for (String type : splittedTypes = typenames.length() > 0 ? typenames.split("\\|") : new String[]{}) {
                        qualifiedNames.add(QualifiedName.create(type));
                    }
                }
                boolean isRawType = Integer.parseInt(parts[2]) > 0;
                String defValue = parts.length > 3 ? parts[3] : "";
                parameters.add(new ParameterImpl(paramName, defValue.length() != 0 ? ParameterImpl.decode(defValue) : null, qualifiedNames, isRawType, OffsetRange.NONE));
            }
        }
        return parameters;
    }

    private static String encode(String inStr) {
        StringBuffer outStr = new StringBuffer(6 * inStr.length());
        for (int i = 0; i < inStr.length(); ++i) {
            if (inStr.charAt(i) == ':' || inStr.charAt(i) == '|' || inStr.charAt(i) == ';' || inStr.charAt(i) == ',' || ParameterImpl.isEncodedChar(i, inStr)) {
                outStr.append(ParameterImpl.encodeChar(inStr.charAt(i)));
                continue;
            }
            outStr.append(inStr.charAt(i));
        }
        return outStr.toString();
    }

    private static String encodeChar(char ch) {
        String encChar = Integer.toString(ch, 16);
        return "\\u" + "0000".substring(0, "0000".length() - encChar.length()).concat(encChar);
    }

    private static String decode(String inStr) {
        StringBuffer outStr = new StringBuffer(inStr.length());
        try {
            for (int i = 0; i < inStr.length(); ++i) {
                if (ParameterImpl.isEncodedChar(i, inStr)) {
                    String decChar = inStr.substring(i + 2, i + 6);
                    outStr.append((char)Integer.parseInt(decChar, 16));
                    i += 5;
                    continue;
                }
                outStr.append(inStr.charAt(i));
            }
        }
        catch (NumberFormatException e) {
            Exceptions.printStackTrace((Throwable)e);
            return inStr;
        }
        return outStr.toString();
    }

    private static boolean isEncodedChar(int currentPosition, String inStr) {
        boolean isEncodedChar;
        boolean bl = isEncodedChar = currentPosition + 5 < inStr.length();
        if (isEncodedChar) {
            char c;
            isEncodedChar &= inStr.charAt(currentPosition) == '\\' && inStr.charAt(currentPosition + 1) == 'u';
            for (int i = currentPosition + 2; isEncodedChar && i < currentPosition + 6; isEncodedChar &= Character.digit(c = inStr.charAt(i), 16) != -1, ++i) {
            }
        }
        return isEncodedChar;
    }

    @Override
    public boolean hasRawType() {
        return this.isRawType;
    }
}

