/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen.ui;

import java.awt.Image;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.codegen.Property;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.openide.util.ImageUtilities;

public abstract class CheckNode
extends DefaultMutableTreeNode {
    private static String ICON_BASE = "org/netbeans/modules/php/editor/resources/";
    private static String ICON_EXTENSION = ".png";
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    protected int selectionMode;
    protected boolean isSelected;

    public CheckNode() {
        this(null);
    }

    public CheckNode(Object userObject) {
        this(userObject, true, false);
    }

    public CheckNode(Object userObject, boolean allowsChildren, boolean isSelected) {
        super(userObject, allowsChildren);
        this.isSelected = isSelected;
        this.setSelectionMode(4);
    }

    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        if (this.selectionMode == 4 && this.children != null) {
            Enumeration en = this.children.elements();
            while (en.hasMoreElements()) {
                CheckNode node = (CheckNode)en.nextElement();
                node.setSelected(isSelected);
            }
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public abstract Image getIcon();

    public static class MethodPropertyNode
    extends CGSPropertyNode {
        public MethodPropertyNode(Property property) {
            super(property);
            assert (PhpElementKind.METHOD.equals((Object)property.getKind())) : property.getKind();
        }

        @Override
        protected String getName(boolean isPublic, boolean isProtected, boolean isStatic) {
            StringBuilder sb = new StringBuilder();
            sb.append(isStatic ? "methodStatic" : "method");
            sb.append(isPublic ? "Public" : "Protected");
            return sb.toString();
        }
    }

    public static class CGSPropertyNode
    extends CheckNode {
        protected final Property property;

        public CGSPropertyNode(Property property) {
            super(property.getName(), false, property.isSelected());
            this.property = property;
        }

        @Override
        public void setSelected(boolean isSelected) {
            super.setSelected(isSelected);
            this.property.setSelected(isSelected);
        }

        @Override
        public Image getIcon() {
            int modifier = this.property.getModifier();
            boolean isPublic = BodyDeclaration.Modifier.isPublic(modifier);
            boolean isProtected = isPublic ? false : BodyDeclaration.Modifier.isProtected(modifier);
            boolean isStatic = BodyDeclaration.Modifier.isStatic(modifier);
            return ImageUtilities.loadImage((String)(ICON_BASE + this.getName(isPublic, isProtected, isStatic) + ICON_EXTENSION));
        }

        protected String getName(boolean isPublic, boolean isProtected, boolean isStatic) {
            String name = "fieldPrivate";
            if (isPublic) {
                name = "fieldPublic";
            } else if (isProtected) {
                name = "fieldProtected";
            }
            return name;
        }
    }

    public static class CGSClassNode
    extends CheckNode {
        public CGSClassNode(String className) {
            super(className, true, false);
        }

        @Override
        public Image getIcon() {
            return ImageUtilities.loadImage((String)(ICON_BASE + "class" + ICON_EXTENSION));
        }
    }
}

