/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.api.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.openide.filesystems.FileObject;

public abstract class ElementFilter {
    public static ElementFilter allOf(Collection<ElementFilter> filters) {
        return ElementFilter.allOf(filters.toArray(new ElementFilter[filters.size()]));
    }

    public static ElementFilter allOf(final ElementFilter ... filters) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                for (ElementFilter elementFilter : filters) {
                    if (elementFilter.isAccepted(element)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static ElementFilter anyOf(Collection<ElementFilter> filters) {
        return ElementFilter.anyOf(filters.toArray(new ElementFilter[filters.size()]));
    }

    public static ElementFilter anyOf(final ElementFilter ... filters) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                for (ElementFilter elementFilter : filters) {
                    if (!elementFilter.isAccepted(element)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static ElementFilter forName(final NameKind name) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                return name.matchesName(element);
            }
        };
    }

    public static ElementFilter forIncludedNames(final Collection<String> includedNames, final PhpElementKind kind) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                for (String name : includedNames) {
                    if (!NameKind.exact(name).matchesName(kind, element.getName())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static ElementFilter forExcludedNames(final Collection<String> excludedNames, final PhpElementKind kind) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                for (String name : excludedNames) {
                    if (!NameKind.exact(name).matchesName(kind, element.getName())) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T extends PhpElement> ElementFilter forExcludedElements(final Collection<T> excludedElements) {
        return new ElementFilter(){
            private ElementFilter delegate = null;

            @Override
            public boolean isAccepted(PhpElement element) {
                if (this.delegate == null) {
                    PhpElementKind kind = PhpElementKind.CLASS;
                    if (excludedElements.size() > 0) {
                        kind = ((PhpElement)excludedElements.iterator().next()).getPhpElementKind();
                    }
                    this.delegate = ElementFilter.forExcludedNames(ElementFilter.toNames(excludedElements), kind);
                }
                return this.delegate.isAccepted(element);
            }
        };
    }

    public static ElementFilter forOffset(final int offset) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                return element.getOffset() == offset;
            }
        };
    }

    public static ElementFilter forKind(final PhpElementKind kind) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                return element.getPhpElementKind().equals((Object)kind);
            }
        };
    }

    public static ElementFilter forFiles(final FileObject ... files) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                boolean retval = true;
                for (FileObject fileObject : files) {
                    if (fileObject == null) continue;
                    String nameExt = fileObject.getNameExt();
                    String elementURL = element.getFilenameUrl();
                    if ((elementURL == null || elementURL.indexOf(nameExt) >= 0) && element.getFileObject() == fileObject) continue;
                    retval = false;
                    break;
                }
                return retval;
            }
        };
    }

    public static ElementFilter forSuperClassName(final QualifiedName supeClassNameQuery) {
        return new ElementFilter(){
            final NameKind.Exact superNameKind;
            {
                this.superNameKind = NameKind.exact(supeClassNameQuery);
            }

            @Override
            public boolean isAccepted(PhpElement element) {
                if (element instanceof ClassElement) {
                    QualifiedName nextSuperName = ((ClassElement)element).getSuperClassName();
                    return nextSuperName != null ? this.superNameKind.matchesName(PhpElementKind.CLASS, nextSuperName) : false;
                }
                return true;
            }
        };
    }

    public static ElementFilter forSuperInterfaceNames(Set<QualifiedName> supeIfaceNameQueries) {
        HashSet<ElementFilter> filters = new HashSet<ElementFilter>();
        for (QualifiedName qualifiedName : supeIfaceNameQueries) {
            filters.add(ElementFilter.forSuperInterfaceName(qualifiedName));
        }
        return ElementFilter.allOf(filters.toArray(new ElementFilter[filters.size()]));
    }

    public static ElementFilter forSuperInterfaceName(final QualifiedName supeIfaceNameQuery) {
        return new ElementFilter(){
            final NameKind.Exact superNameKind;
            {
                this.superNameKind = NameKind.exact(supeIfaceNameQuery);
            }

            @Override
            public boolean isAccepted(PhpElement element) {
                if (element instanceof TypeElement) {
                    Set<QualifiedName> superInterfaces = ((TypeElement)element).getSuperInterfaces();
                    for (QualifiedName nextSuperName : superInterfaces) {
                        if (!this.superNameKind.matchesName(PhpElementKind.IFACE, nextSuperName)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        };
    }

    public static ElementFilter forTypesFromNamespaces(Set<QualifiedName> namespaces) {
        HashSet<ElementFilter> filters = new HashSet<ElementFilter>();
        for (QualifiedName ns : namespaces) {
            filters.add(ElementFilter.forTypesFromNamespace(ns));
        }
        return ElementFilter.anyOf(filters);
    }

    public static ElementFilter forTypesFromNamespace(QualifiedName namespace) {
        final NameKind.Exact nsName = NameKind.exact(namespace);
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                if (element instanceof TypeElement) {
                    TypeElement type = (TypeElement)element;
                    return nsName.matchesName(type.getPhpElementKind(), type.getNamespaceName());
                }
                return true;
            }
        };
    }

    public static ElementFilter forEqualTypes(TypeElement typeElement) {
        return ElementFilter.allOf(ElementFilter.forName(NameKind.exact(typeElement.getName())), ElementFilter.forFiles(typeElement.getFileObject()));
    }

    public static ElementFilter forMembersOfTypes(Set<TypeElement> typeElements) {
        ArrayList<ElementFilter> filters = new ArrayList<ElementFilter>();
        for (TypeElement typeElement : typeElements) {
            filters.add(ElementFilter.forMembersOfType(typeElement));
        }
        return ElementFilter.anyOf(filters);
    }

    public static ElementFilter forMembersOfType(final TypeElement typeElement) {
        return new ElementFilter(){
            private ElementFilter filterDelegate = null;

            @Override
            public boolean isAccepted(PhpElement element) {
                if (element instanceof TypeMemberElement) {
                    if (this.filterDelegate == null) {
                        this.filterDelegate = 13.forEqualTypes(typeElement);
                    }
                    return this.filterDelegate.isAccepted(((TypeMemberElement)element).getType());
                }
                return true;
            }
        };
    }

    public static ElementFilter forMembersOfTypeName(final TypeElement typeElement) {
        return new ElementFilter(){
            private ElementFilter filterDelegate = null;

            @Override
            public boolean isAccepted(PhpElement element) {
                if (element instanceof TypeMemberElement) {
                    if (this.filterDelegate == null) {
                        this.filterDelegate = 14.forName(NameKind.exact(typeElement.getFullyQualifiedName()));
                    }
                    return this.filterDelegate.isAccepted(((TypeMemberElement)element).getType());
                }
                return true;
            }
        };
    }

    public static <T extends PhpElement> ElementFilter forInstanceOf(final Class<T> cls) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                return cls.isAssignableFrom(element.getClass());
            }
        };
    }

    public static ElementFilter forAnyOfFlags(final int flags) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                return (element.getPhpModifiers().toFlags() & flags) != 0;
            }
        };
    }

    public static ElementFilter forAllOfFlags(final int flags) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                return (element.getPhpModifiers().toFlags() & flags) == flags;
            }
        };
    }

    public static ElementFilter forPublicModifiers(final boolean publicOrNot) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                return element.getPhpModifiers().isPublic() == publicOrNot;
            }
        };
    }

    public static ElementFilter forPrivateModifiers(final boolean privateOrNot) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                return element.getPhpModifiers().isPrivate() == privateOrNot;
            }
        };
    }

    public static ElementFilter forStaticModifiers(final boolean staticOrNot) {
        return new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                return element.getPhpModifiers().isStatic() == staticOrNot;
            }
        };
    }

    public abstract boolean isAccepted(PhpElement var1);

    public <T extends PhpElement> Set<T> filter(T original) {
        return this.filter(Collections.singleton(original));
    }

    public <T extends PhpElement> Set<T> filter(Set<T> original) {
        HashSet<PhpElement> retval = new HashSet<PhpElement>();
        for (PhpElement baseElement : original) {
            if (!this.isAccepted(baseElement)) continue;
            retval.add(baseElement);
        }
        return Collections.unmodifiableSet(retval);
    }

    public <T extends PhpElement> Set<T> reverseFilter(Set<T> original) {
        HashSet<PhpElement> retval = new HashSet<PhpElement>();
        for (PhpElement baseElement : original) {
            if (this.isAccepted(baseElement)) continue;
            retval.add(baseElement);
        }
        return Collections.unmodifiableSet(retval);
    }

    public <T extends PhpElement> Set<T> prefer(Set<T> original) {
        Set<T> retval = original;
        HashSet<PhpElement> notAccepted = new HashSet<PhpElement>();
        HashMap<PhpElement, ElementFilter> accepted = new HashMap<PhpElement, ElementFilter>();
        for (PhpElement phpElement : original) {
            if (this.isAccepted(phpElement)) {
                ArrayList<ElementFilter> filters = new ArrayList<ElementFilter>();
                if (phpElement instanceof FullyQualifiedElement) {
                    FullyQualifiedElement fqnElement = (FullyQualifiedElement)phpElement;
                    filters.add(ElementFilter.forName(NameKind.exact(fqnElement.getFullyQualifiedName())));
                } else {
                    filters.add(ElementFilter.forName(NameKind.exact(phpElement.getName())));
                }
                if (phpElement instanceof TypeMemberElement) {
                    TypeMemberElement member = (TypeMemberElement)phpElement;
                    filters.add(ElementFilter.forMembersOfTypeName(member.getType()));
                }
                accepted.put(phpElement, ElementFilter.allOf(filters));
                continue;
            }
            notAccepted.add(phpElement);
        }
        if (accepted.size() > 0 && notAccepted.size() > 0) {
            retval = new HashSet<T>(original);
            for (Map.Entry entry : accepted.entrySet()) {
                ElementFilter filter = (ElementFilter)entry.getValue();
                retval.removeAll(filter.filter(notAccepted));
            }
        }
        return Collections.unmodifiableSet(retval);
    }

    private static Set<String> toNames(Collection<? extends PhpElement> elements) {
        HashSet<String> names = new HashSet<String>();
        for (PhpElement phpElement : elements) {
            names.add(phpElement.getName());
        }
        return names;
    }
}

